package unisql.itrack;

import java.sql.*;
import unisql.sql.*;
import java.io.*;
import javax.sql.*;
import javax.naming.*;
import java.text.SimpleDateFormat;
import javax.servlet.jsp.*;
import javax.servlet.http.*;
import com.oreilly.servlet.MultipartRequest;

public class ITrackIssueInfo {

/*=======================================================================
 |      PUBLIC VARIABLES
 =======================================================================*/

private static String[][] WHERE_OP_TEXT = 
	{ {"=", "="},
	  {">", ">"},
	  {"<", "<"},
	  {">=", ">="},
	  {"<=", "<="},
	  {"<>", "<>"},
	  {"in", "in"},
	  {"not in", "not in"},
	  {"like", "like"},
	  {"", ""} };
private static String[][] WHERE_OP_SELECT = 
	{ {"=", "="},
	  {"<>", "<>"},
	  {"in", "in"},
	  {"not in", "not in"} };

private static String[][] WHERE_OP_TEXTAREA =
	{
	{ "like", "like" } };

private static String[][] WHERE_OP_DEFAULT = 
	{ {"", ""} };

/*
private static String[][] RESOLUTION_CONDITIONAL_MANDATORY =
	{ {"ħ", "resolved_build_number"},
	  {"ߺ", "duplicate_id"}
	};
	*/

private static String MANDATORY_FIELD_COLOR = "MAGENTA";

/*=======================================================================
 |      PRIVATE VARIABLES
 =======================================================================*/

private String          display_name;
private String          db_attribute_name;
private String          db_attribute_type;
private String          form_element_type;
private Object          select_items;
private String          opened_mandatory;
private String          resolved_mandatory;
private String          closed_mandatory;
private short           detail_view_display_col;
private short           detail_view_display_row;
private String          itrack_system_field;
private int             display_size_x;
private int             display_size_y;
private int		display_brief_size;
private String[][]	grant_mandatory;

private final static String OP_SELECT_SPACE = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

/*=======================================================================
 |      CONSTRUCTOR
 =======================================================================*/

public ITrackIssueInfo(ResultSet rs) throws SQLException
{
  display_name = rs.getString("display_name");
  db_attribute_name = rs.getString("db_attribute_name");
  db_attribute_type = rs.getString("db_attribute_type");
  form_element_type = rs.getString("form_element_type");
  select_items = rs.getObject("select_items");
  opened_mandatory = rs.getString("opened_mandatory");
  resolved_mandatory = rs.getString("resolved_mandatory");
  closed_mandatory = rs.getString("closed_mandatory");
  detail_view_display_col = rs.getShort("detail_view_display_col");
  detail_view_display_row = rs.getShort("detail_view_display_row");
  itrack_system_field = rs.getString("itrack_system_field");
  display_size_x = rs.getInt("display_size_x");
  display_size_y = rs.getInt("display_size_y");

  String[] tmp = (String[]) rs.getObject("grant_mandatory");
  if (tmp == null || tmp.length < 2) {
    grant_mandatory = null;
  }
  else {
    int rows = tmp.length / 2;
    grant_mandatory = new String[rows][2];
    for (int i=0 ; i < rows ; i++) {
      grant_mandatory[i][0] = tmp[i*2];
      grant_mandatory[i][1] = tmp[i*2+1];
    }
  }
}

/*=======================================================================
 |      PUBLIC METHODS
 =======================================================================*/

public static ITrackIssueInfo[] getIssueInfoArray(String table_name)
        throws SQLException, NamingException
{
  ITrackIssueInfo[] issueArr = null;
  Connection con = null;
  String query = "select * from " + table_name +
		 " order by detail_view_display_col, detail_view_display_row ";

  try {
    con = ITrackDB.getConnection();
    Statement stmt = con.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE,
                                         ResultSet.CONCUR_READ_ONLY);
    ResultSet rs = stmt.executeQuery(query);

    rs.last();
    issueArr = new ITrackIssueInfo[rs.getRow()];
    rs.beforeFirst();

    for (int i=0 ; rs.next() ; i++) {
      issueArr[i] = new ITrackIssueInfo(rs);
    }

    rs.close();
    stmt.close();
  } finally {
    ITrackDB.closeConnection(con);
  }

  return issueArr;
}

public static ITrackIssueInfo[] getIssueInfoArray(ITrackIssueInfo[] issueArr, int colNumber)
{
  ITrackIssueInfo[] tmpArr = new ITrackIssueInfo[issueArr.length];

  int count = 0;
  for (int i=0 ; i < issueArr.length ; i++) {
    if (issueArr[i].detail_view_display_col == colNumber) {
      tmpArr[count++] = issueArr[i];
    }
  }
  ITrackIssueInfo[] retArr = new ITrackIssueInfo[count];
  System.arraycopy(tmpArr, 0, retArr, 0, count);
  return retArr;
}

public static void printSearchFormSelect(JspWriter out, ITrackIssueInfo[] infoArr, ITrackSearchForm srchFrm) throws IOException
{
  ITrackHTML.Table(out, "border=0 align=center");
  for (int i=0 ; i < infoArr.length ; i++) {
    if (infoArr[i].db_attribute_name.equals("description") ||
        infoArr[i].db_attribute_name.equals("files") ||
        infoArr[i].db_attribute_name.equals("repro_step"))
    {
      continue;
    }

    ITrackHTML.Td(out, "nowrap");
    ITrackHTML.InputCheckbox(out, "select_" + infoArr[i].db_attribute_name,
			   infoArr[i].display_name,
			   srchFrm.isSelectField(infoArr[i].db_attribute_name),
			   "class='checkbox'");
    if ((i+1) % 3 == 0)
      ITrackHTML.Tr(out);
  }
  ITrackHTML.TableEnd(out);
}

public static void printSearchFormWhere(JspWriter out, int spaceCount, ITrackIssueInfo[] infoArr, ITrackSearchForm srchFrm) throws IOException
{
  String[] conj = {"", "AND", "OR"};
  String[][] attrList = toWhereAttrArr(infoArr);
  int numDefaultWhereCond =  srchFrm.getWhereConditionCount();

  for (int i=0 ; i < ITrackJsp.NUM_SEARCH_FORM_WHERE ; i++) {
    //ITrackHTML.Td(out);

    if (i <= numDefaultWhereCond)
      out.println("<div id=where_cond_" + i + " style='display:'>");
    else
      out.println("<div id=where_cond_" + i + " style='display:none'>");

    if (i < numDefaultWhereCond) {
      ITrackHTML.InputCheckbox(out, "where_cond_chk_" + i, "", true, "style='display:none'");
    }
    else {
      ITrackHTML.InputCheckbox(out, "where_cond_chk_" + i, "", false, "style='display:none'");
    }

    String changeConjFunc = "onChange=\"resetWhereCondition(this.value" +
			    ", where_attr_" + i +
			    ", where_op_" + i +
			    ", where_val_select_" + i +
			    ", where_val_text_" + i +
			    ", where_val_is_select_" + i +
			    ")\"";
    if (i == 0) {
      ITrackHTML.Space(out, spaceCount);
    }
    else if (i < srchFrm.getWhereConditionCount()) {
      ITrackHTML.Select(out, "where_conj_" + i, changeConjFunc, conj,
      			findString(conj, srchFrm.getWhereCondConj(i)));
    }
    else {
      ITrackHTML.Select(out, "where_conj_" + i, changeConjFunc, conj, 1);
    }

    String changeAttrFunc = "onChange=\"changeWhereAttr(this.value" +
			  ", where_cond_chk_" + i +
			  ", where_op_" + i +
			  ", where_val_select_" + i +
			  ", where_val_text_" + i +
			  ", where_val_is_select_" + i +
			  ", 'where_cond_" + (i+1) +
			  "')\"";
    String curAttr = srchFrm.getWhereCondAttr(i);
    ITrackIssueInfo issueInfo = find(infoArr, curAttr);
    ITrackHTML.Select(out, "where_attr_" + i, changeAttrFunc, attrList,
    			findString(attrList, 0, curAttr));

    String changeOpFunc = "onChange=\"changeOperator(" +
			  "this.value" +
			  ", where_val_select_" + i +
			  ", where_val_is_select_" + i +
			  ")\"";
    String[][] opList = null;
    int opListIdx = 0;
    String valSelectStyle = "style='display:none'";
    String[] valList = null;
    int valListIdx = 0;
    String[] valSelected = null;
    String valText = "";
    String valTextStyle = "";
    boolean selectChecked = false;

    if (issueInfo != null) {
      if (issueInfo.form_element_type.equals("select")) {
	opList = WHERE_OP_SELECT;
	opListIdx = findString(opList, 1, srchFrm.getWhereCondOp(i));
	valSelectStyle = "style='display:'";
	valList = (String[]) issueInfo.select_items;
	String[] tmp = selectValueSplit(srchFrm.getWhereCondValue(i));
	if (tmp != null && tmp.length > 1) {
	  valSelected = tmp;
	  valSelectStyle += " multiple size=3 ";
	}
	valListIdx = findString(valList, srchFrm.getWhereCondValue(i));
	valText = "";
	valTextStyle = "style='display:none'";
	selectChecked = true;
      }
      else {
	if (issueInfo.form_element_type.equals("text"))
	  opList = WHERE_OP_TEXT;
	else if (issueInfo.form_element_type.equals("textarea"))
  	  opList = WHERE_OP_TEXTAREA;
	else
	  opList = WHERE_OP_DEFAULT;

	opListIdx = findString(opList, 1, srchFrm.getWhereCondOp(i));
	valSelectStyle = "style='display:none'";
	valList = null;
	valListIdx = 0;
	valText = srchFrm.getWhereCondValue(i);
	valTextStyle = "style='display:'";
	selectChecked = false;
      }
    }

    ITrackHTML.Select(out, "where_op_" + i, changeOpFunc, opList, opListIdx);
    if (valSelected == null)
      ITrackHTML.Select(out, "where_val_select_" + i, valSelectStyle, valList, valListIdx);
    else
      ITrackHTML.Select(out, "where_val_select_" + i, valSelectStyle, valList, valSelected);
    ITrackHTML.InputText4SearchForm(out, "where_val_text_" + i, valText, "class=textbox " + valTextStyle);
    ITrackHTML.InputCheckbox(out, "where_val_is_select_" + i, "", selectChecked, "style='display:none'");

    out.println("</div>");
  }
}

public static void printSearchFormOrderby(JspWriter out, ITrackIssueInfo[] infoArr, ITrackSearchForm srchFrm)
	throws IOException
{
  String[][] attrList = toWhereAttrArr(infoArr);
  int numDefaultOrderby = srchFrm.getOrderbyCount();
  String[] opAsc = {ITrackJsp.ORDERBY_ASC, ITrackJsp.ORDERBY_DESC};

  for (int i=0 ; i < ITrackJsp.NUM_SEARCH_FORM_ORDERBY ; i++) {
    if (i <= numDefaultOrderby)
      out.println("<div id=div_orderby_" + i + " style='display:'>");
    else
      out.println("<div id=div_orderby_" + i + " style='display:none'>");

    if (i < numDefaultOrderby)
      ITrackHTML.InputCheckbox(out, "orderby_chk_" + i, "", true, "style='display:none'");
    else
      ITrackHTML.InputCheckbox(out, "orderby_chk_" + i, "", false, "style='display:none'");

    String changeAttrFunc = "onChange=\"changeOrderbyAttr('div_orderby_" + (i + 1) + "', 'orderby_chk_" + i + "', this" + ")\"";
    			
    ITrackHTML.Select(out, "orderby_attr_" + i, changeAttrFunc, attrList, findString(attrList, 0, srchFrm.getOrderbyAttr(i)));
    ITrackHTML.Select(out, "orderby_asc_" + i, "", opAsc, findString(opAsc, srchFrm.getOrderbyAsc(i)));
    out.println("</div>");
  }
}

public static void printSearchFromJavascript(JspWriter out, ITrackIssueInfo[] infoArr)
	throws IOException
{
  // javascript changeWhereAttr

  out.println("function changeWhereAttr(value, cond_chk, opselect, val_select, val_text, is_select_checkbox, nextdiv) {");

  out.println("clearSelectList(val_select)");
  out.println("val_text.value = ''");
  out.println("divDisplay(nextdiv)");
  out.println("cond_chk.checked = true");

  for (int i=0 ; i < infoArr.length ; i++) {
    if (infoArr[i].form_element_type.equals("select")) {
      out.println("if (value == '" + infoArr[i].db_attribute_name + "') {");
      out.println("val_text.style.display = 'none'");
      out.println("val_select.style.display = ''");
      out.println("is_select_checkbox.checked = true");
      out.println("initSelectOperatorList(opselect)");
      if (infoArr[i].select_items != null) {
	String[] items = (String[]) infoArr[i].select_items;
	for (int j=0 ; j < items.length ; j++) {
	  out.println("val_select.options[" + j + "] = new Option('" +
	  		items[j] + "', '" + items[j] + "', false, false)");
	  if (j == 0) {
	    out.println("val_select.options[0].defaultSelected = true");
	    out.println("val_select.options[0].selected = true");
	  }
	}
      }
      out.println("}");
    }
    else {
      out.println("if (value == '" + infoArr[i].db_attribute_name + "') {");
      out.println("val_text.style.display = ''");
      out.println("val_select.style.display = 'none'");
      out.println("is_select_checkbox.checked = false");
      if (infoArr[i].form_element_type.equals("text"))
	out.println("initTextOperatorList(opselect)");
      else if (infoArr[i].form_element_type.equals("textarea"))
	out.println("initTextAreaOperatorList(opselect)");
      else
	out.println("initDefaultOperatorList(opselect)");
      out.println("}");
    }
  }
  out.println("}");

  // function chageOrderbyAttr
  out.println("function changeOrderbyAttr(nextdiv, cur_checkbox, cur_selbox) {");
  out.println("if (!checkOrderDup(cur_selbox)) return");
  out.println("divDisplay(nextdiv)");
  out.println("cur_checkbox.checked = true");
  out.println("}");

  String[][] op;

  // function initSelectOperatorList
  out.println("function initSelectOperatorList(input_select) {");
  out.println("while (input_select.length > 0)");
  out.println("input_select.options[0] = null");
  op = WHERE_OP_SELECT;
  for (int i=0 ; i < op.length ; i++) {
    out.println("input_select.options[" + i + "] = new Option('" +
    		op[i][1] + "', '" + op[i][0] +
		"', false, false)");
  }
  out.println("input_select.options[0].selected = true");
  out.println("}");

  // function initTextOperatorList
  out.println("function initTextOperatorList(input_select) {");
  out.println("while (input_select.length > 0)");
  out.println("input_select.options[0] = null");
  op = WHERE_OP_TEXT;
  for (int i=0 ; i < op.length ; i++) {
    out.println("input_select.options[" + i + "] = new Option('" +
    		op[i][1] + "', '" + op[i][0] +
		"', false, false)");
  }
  out.println("input_select.options[0].selected = true");
  out.println("}");

  // function initTextAreaOperatorList
  out.println("function initTextAreaOperatorList(input_select) {");
  out.println("while (input_select.length > 0)");
  out.println("input_select.options[0] = null");
  op = WHERE_OP_TEXTAREA;
  for (int i = 0; i < op.length; i++)
  {
    out.println("input_select.options[" + i + "] = new Option('"
                  + op[i][1] + "', '" + op[i][0] + "', false, false)");
  }
  out.println("input_select.options[0].selected = true");
  out.println("}");

  // function initDefaultOperatorList
  out.println("function initDefaultOperatorList(input_select) {");
  out.println("while (input_select.length > 0)");
  out.println("input_select.options[0] = null");
  op = WHERE_OP_DEFAULT;
  for (int i=0 ; i < op.length ; i++) {
    out.println("input_select.options[" + i + "] = new Option('" +
    		op[i][1] + "', '" + op[i][0] +
		"', false, false)");
  }
  out.println("input_select.options[0].selected = true");
  out.println("}");
}

public static String[] getSelectList(HttpServletRequest request, ITrackIssueInfo[] infoArr, String tablename)
{
  String[] selectList = new String[infoArr.length + 2];
  int listLen = 0;
  String paramValue;

  if (tablename != null) {
    selectList[listLen++] = "id";
    selectList[listLen++] = "status";
  }
  for (int i=0 ; i < infoArr.length ; i++) {
    paramValue = request.getParameter("select_" + infoArr[i].db_attribute_name);
    if (paramValue != null && paramValue.equals("on"))
      selectList[listLen++] = infoArr[i].db_attribute_name;
  }
  String[] tmp = new String[listLen];
  System.arraycopy(selectList, 0, tmp, 0, listLen);
  return tmp;
}

public static String[][] getWhereList(HttpServletRequest request, ITrackIssueInfo[] infoArr)
{
  String[][] whereList = new String[infoArr.length][4];
  int listLen = 0;
  String cond_chk, conj, attr, op, val_select, val_text;
  boolean is_select;

  for (int i=0 ; i < ITrackJsp.NUM_SEARCH_FORM_WHERE ; i++) {
    cond_chk = request.getParameter("where_cond_chk_" + i);
    if (cond_chk == null || !cond_chk.equals("on"))
      continue;
    conj = request.getParameter("where_conj_" + i);
    attr = request.getParameter("where_attr_" + i);
    op = request.getParameter("where_op_" + i);
    val_select = selectValueConcat(request.getParameterValues("where_val_select_" + i));
    val_text = request.getParameter("where_val_text_" + i);
    is_select = "on".equals(request.getParameter("where_val_is_select_" + i));
    whereList[listLen][0] = (conj == null) ? "" : conj;
    whereList[listLen][1] = (attr == null) ? "" : attr;
    whereList[listLen][2] = (op == null) ? "" : op;
    if (is_select)
      whereList[listLen][3] = (val_select == null) ? "" : val_select;
    else
      whereList[listLen][3] = (val_text == null) ? "" : val_text;
    listLen++;
  }

  String[][] tmp = new String[listLen][4];
  System.arraycopy(whereList, 0, tmp, 0, listLen);
  return tmp;
}

public static String[][] getOrderbyList(HttpServletRequest request, ITrackIssueInfo[] infoArr)
{
  String[][] orderby = new String[infoArr.length][2];
  int listLen = 0;
  String chk, attr, asc;
  
  for (int i=0 ; i < ITrackJsp.NUM_SEARCH_FORM_ORDERBY ; i++) {
    chk = request.getParameter("orderby_chk_" + i);
    if (chk == null || !chk.equals("on"))
      continue;
    attr = request.getParameter("orderby_attr_" + i);
    asc = request.getParameter("orderby_asc_" + i);
    orderby[listLen][0] = (attr == null) ? "" : attr;
    orderby[listLen][1] = (asc == null) ? "" : asc;
    listLen++;
  }
  String[][] tmp = new String[listLen][2];
  System.arraycopy(orderby, 0, tmp, 0, listLen);
  return tmp;
}

public void printFormElement(JspWriter out, ITrackIssueValue value, boolean printOrgValue, boolean isMultiple, int action, String username, boolean is_mandatory)
	throws IOException
{
  String defaultValue;
  Object valueObj;
  String orgValue;
  
  if (isMultiple)
    defaultValue = "";
  else
    defaultValue = value.getString(db_attribute_name);

  orgValue = defaultValue;

  String tmpDefault = makeDefaultValue(action, username, value);
  if (tmpDefault != null)
    defaultValue = tmpDefault;

  valueObj = value.getObject(db_attribute_name);

  if (form_element_type.equals("text")) {
    String attrStr = "class='textbox' ";
    if (display_size_x > 0)
      attrStr += "size ='" + display_size_x + "' ";

    ITrackHTML.InputText(out, db_attribute_name, defaultValue, attrStr);
  }
  else if (form_element_type.equals("select")) {
    String formEvent = "";
    if (is_mandatory) {
      formEvent = " onClick=\"changeConditionalMandatoryField('" + db_attribute_name + "', this.value)\" ";
    }
    String[] selectOptions = null;
    if (select_items instanceof String[])
      selectOptions = (String[]) select_items;

    ITrackHTML.Select(out, db_attribute_name, formEvent, selectOptions, findString(selectOptions, defaultValue));
  }
  else if (form_element_type.equals("textarea")) {
    String attrStr = "";
    if (display_size_x > 0)
      attrStr += "cols='" + display_size_x + "' ";
    if (display_size_y > 0)
      attrStr += "rows='" + display_size_y + "' ";
      
     attrStr += " onDblClick='displayTextArea(this.value)' ";

    if (db_attribute_name.equals("description")) {
	if (action == ITrackJsp.ITRACK_OPEN)
	  ITrackHTML.Textarea(out, db_attribute_name, defaultValue, attrStr);
 	else
  	  ITrackHTML.Textarea(out, db_attribute_name, "", attrStr);
    }
    else {
      ITrackHTML.Textarea(out, db_attribute_name, defaultValue, attrStr);
    }
  }
  else if (form_element_type.equals("file")) {
    String attrStr = "class=textbox ";
    if (display_size_x > 0)
      attrStr += "size = '" + display_size_x + "' ";

    if (isMultiple == false || valueObj != null) {
      ITrackHTML.InputFile(out, db_attribute_name, attrStr);
    }
  }

  if (printOrgValue) {
    ITrackHTML.InputHidden(out, "org_" + db_attribute_name, orgValue);
  }
}

public static void printIssueDetailView(JspWriter out, ITrackIssueInfo[] infoArr, ITrackIssueValue issueValue, int action, boolean isMultiple, String username)
	throws IOException, SQLException, NamingException
{
  String colSpanStr = "colspan=" + ITrackJsp.ISSUE_DISPLAY_COLUMNS;
  int captionWidth = 80;
  ITrackIssueInfo issueInfo;
  ITrackIssueInfo[] infoGrp;
  String styleMandatory = " style='color:" + MANDATORY_FIELD_COLOR + "' ";
  String styleDefault = "";
  String styleStr;
  String tdAttrStr;
  boolean printOrgValue = (action !=  ITrackJsp.ITRACK_OPEN);

  ITrackHTML.Td(out, colSpanStr);

  infoGrp = ITrackIssueInfo.getIssueInfoArray(infoArr, ITrackJsp.ISSUE_DISPLAY_TOP);
  ITrackHTML.Table(out, "border=0");
  for (int i=0 ; i < infoGrp.length ; i++) {
    issueInfo = infoGrp[i];

    boolean is_mandatory = issueInfo.isMandatory(action, infoArr);
    styleStr = is_mandatory ? styleMandatory : styleDefault;

    ITrackHTML.Td(out, "td_" + issueInfo.db_attribute_name, captionWidth, styleStr);
    out.println(issueInfo.display_name);
    ITrackHTML.Td(out);
    issueInfo.printFormElement(out, issueValue, printOrgValue, isMultiple, action, username, is_mandatory);
    ITrackHTML.Tr(out);
  }
  ITrackHTML.TableEnd(out);

  ITrackHTML.Tr(out);

  for (int cur_col = 1 ; cur_col <= ITrackJsp.ISSUE_DISPLAY_COLUMNS ; cur_col++) {
    ITrackHTML.Td(out, "valign=top ");
    ITrackHTML.Table(out, "border=0 width=230");
    infoGrp = ITrackIssueInfo.getIssueInfoArray(infoArr, cur_col);
    for (int i=0 ; i < infoGrp.length ; i++) {
      issueInfo = infoGrp[i];

      boolean is_mandatory = issueInfo.isMandatory(action, infoArr);
      styleStr = is_mandatory ? styleMandatory : styleDefault;

      ITrackHTML.Td(out, "td_" + issueInfo.db_attribute_name, captionWidth, styleStr);

      out.println(issueInfo.display_name);
      ITrackHTML.Td(out);
      issueInfo.printFormElement(out, issueValue, printOrgValue, isMultiple, action, username, is_mandatory);
      ITrackHTML.Tr(out);
    }
    ITrackHTML.TableEnd(out);
  }
  ITrackHTML.Tr(out);

  // ÷ȭ 
  if (isMultiple == false) {
    ITrackHTML.Td(out, colSpanStr);
    ITrackHTML.Table(out, "width='100%'");
    issueInfo = ITrackIssueInfo.find(infoArr, "files");
    if (issueInfo != null) {
      boolean is_mandatory = issueInfo.isMandatory(action, infoArr);
      styleStr = is_mandatory ? styleMandatory : styleDefault;

      ITrackHTML.Td(out, "td_" + issueInfo.db_attribute_name, captionWidth, styleStr);
      out.println(issueInfo.display_name);
      ITrackHTML.Td(out);
      ITrackHTML.Table(out, "border=0 width='100%'");
      issueInfo.printAttachFile(out, issueValue.getObject("files"), issueValue.getString("id"), username, action);
      ITrackHTML.Td(out, "");
      issueInfo.printFormElement(out, issueValue, printOrgValue, isMultiple, action, username, is_mandatory);
      ITrackHTML.TableEnd(out);
    }
    ITrackHTML.TableEnd(out);
    ITrackHTML.Tr(out);
  }

  //  
  ITrackHTML.Td(out, colSpanStr);
  ITrackHTML.Table(out, "width='100%'");
  issueInfo = ITrackIssueInfo.find(infoArr, "repro_step");
  if (issueInfo != null) {
      boolean is_mandatory = issueInfo.isMandatory(action, infoArr);
      styleStr = is_mandatory ? styleMandatory : styleDefault;

      ITrackHTML.Td(out, "td_" + issueInfo.db_attribute_name, captionWidth, styleStr);
    out.println(issueInfo.display_name);
    ITrackHTML.Td(out);
    issueInfo.printFormElement(out, issueValue, printOrgValue, isMultiple, action, username, is_mandatory);
  }
  ITrackHTML.TableEnd(out);
  ITrackHTML.Tr(out);

  // 󼼼(߰) 
  ITrackHTML.Td(out, colSpanStr);
  ITrackHTML.Table(out, "width='100%'");
  issueInfo = ITrackIssueInfo.find(infoArr, "description");
  if (issueInfo != null) {
    boolean is_mandatory = issueInfo.isMandatory(action, infoArr);
    styleStr = is_mandatory ? styleMandatory : styleDefault;

    ITrackHTML.Td(out, "td_" + issueInfo.db_attribute_name, captionWidth, styleStr);
    if (action == ITrackJsp.ITRACK_OPEN)
      out.println(issueInfo.display_name);
    else
      out.println("󼼼߰");
    ITrackHTML.Td(out);

    issueInfo.printFormElement(out, issueValue, printOrgValue, isMultiple, action, username, is_mandatory);
  }
  ITrackHTML.TableEnd(out);
  ITrackHTML.Tr(out);

  if (isMultiple == false) {
    ITrackHTML.Td(out, colSpanStr);
    issueInfo = ITrackIssueInfo.find(infoArr, "description");
    if (issueInfo != null) {
      issueInfo.printDescription(out, issueValue);
    }
    ITrackHTML.Tr(out);
  }
}

public static void printIssueCheckMandatoryFieldScript(JspWriter out, ITrackIssueInfo[] infoArr, int action, boolean isMultiple)
        throws IOException
{
  out.println("function issue_check_field_and_submit(form) {");
  for (int i=0; i < infoArr.length ; i++) {
    ITrackIssueInfo issueInfo = infoArr[i];
    boolean mandatory;

    mandatory = issueInfo.isMandatory(action, infoArr);

    if (mandatory == true && !isMultiple) {
      if (issueInfo.form_element_type.equals("select")) {
        out.println("if (form." + issueInfo.db_attribute_name +".options[form." + issueInfo.db_attribute_name + ".selectedIndex].value == '') ");
      }
      else if (issueInfo.form_element_type.equals("text")) {
        out.println("if (form." + issueInfo.db_attribute_name + ".value == '') ");
      }
      else if (issueInfo.form_element_type.equals("textarea")) {
        out.println("if (form." + issueInfo.db_attribute_name + ".value == '') ");
      }
      else {
        //throw new IllegalArgumentException();
	continue;
      }
      out.println("{");

      out.println("alert('" + issueInfo.display_name + " : ʼ׸')");
      out.println("form." + issueInfo.db_attribute_name + ".focus()");
      out.println("return false");
      out.println("}");

      if (issueInfo.grant_mandatory != null) {
	String[][] grantMandatory = issueInfo.grant_mandatory;
	for (int j=0 ; j < grantMandatory.length ; j++) {
	  String checkValue = grantMandatory[j][0];
	  String checkField = grantMandatory[j][1];
	  ITrackIssueInfo tmp = find(infoArr, checkField);
	  if (tmp == null)
	    continue;
	  out.println("if (form." + issueInfo.db_attribute_name + ".value == '" + checkValue + "' && form." + checkField + ".value == '') {");
	  out.println("alert('" + tmp.display_name + " : ʼ׸')");
	  out.println("form." + checkField + ".focus()");
	  out.println("return false");
	  out.println("}");
	}
      }
    }
  }
  out.println("return true");
  out.println("}");
}

public static String[] insertIssue(ITrackIssueInfo[] infoArr, MultipartRequest mReq, String username, String working_table)
	throws SQLException, NamingException, IOException
{
  Connection con = null;
  String[] insertResult = new String[2];
  insertResult[0] = "";
  insertResult[1] = "";

  try {
    con = ITrackDB.getConnection();
    con.setAutoCommit(false);

    Object[] attrValues = new Object[infoArr.length + 1];
    int i;
    for (i=0 ; i < attrValues.length - 1; i++) {
      String attr_name = infoArr[i].db_attribute_name;
      String attr_type = infoArr[i].db_attribute_type;

      if (attr_name.equals("description")) {
	attrValues[i] = makeDescriptionValue(mReq, attr_name, username, "");
      }
      else if (attr_type.indexOf("itrack_attach_file") >= 0) {
	attrValues[i] = makeAttachfileValue(con, mReq, attr_name, username);
      }
      else if (attr_type.equals("date")) {
	String dateStr = mReq.getParameter(attr_name);
	if (dateStr == null || dateStr.length() == 0)
	  attrValues[i] = null;
	else
	  attrValues[i] = java.sql.Date.valueOf(mReq.getParameter(attr_name));
      }
      else {
	attrValues[i] = mReq.getParameter(attr_name);
      }

      if (attr_name.equals("assigned")) {
	insertResult[1] = (String) attrValues[i];
      }
    }
    attrValues[i] = new java.sql.Timestamp(System.currentTimeMillis());

    StringBuffer query = new StringBuffer("insert into ");
    query.append(working_table);
    query.append(" (");

    for (i=0 ; i < attrValues.length - 1; i++) {
      if (i != 0)
	query.append(", ");
      query.append(infoArr[i].db_attribute_name);
    }
    query.append(", last_update");
    query.append(") values (");
    for (i=0 ; i < attrValues.length ; i++) {
      if (i != 0)
	query.append(", ");
      query.append("?");
    }
    query.append(") into :insert_obj");

    ITrackDB.executeQuery(con, query.toString(), attrValues, attrValues.length);

    ITrackDB.executeQuery(con, "commit", null, 0);

    String selectQuery = "select :insert_obj.id from db_root";
    Object[] result = ITrackDB.selectQuery(con, selectQuery, null, 0);

    if (result[0] != null)
      insertResult[0] = result[0].toString();

    con.commit();
  } finally {
    ITrackDB.closeConnection(con);
  }

  return insertResult;
}

public static String updateIssue(ITrackIssueInfo[] infoArr, MultipartRequest mReq, String username, String working_table, String[] idArr, String msg, int action)
	throws SQLException, NamingException, IOException, ITrackException
{
  Connection con = null;
  StringBuffer query = new StringBuffer("");
  boolean runUpdate = false;
  StringBuffer changeHistory = new StringBuffer("");;
  String mailTo = null;

  query.append("update ");
  query.append(working_table);
  query.append(" set ");

  try {
    con = ITrackDB.getConnection();
    con.setAutoCommit(false);

    Object[] updateValue = new Object[infoArr.length + 1];
    int updateValueCount = 0;
    int numUpdateCols = 0;

    for (int i=0 ; i < infoArr.length; i++) {
      String attr_name = infoArr[i].db_attribute_name;
      String attr_type = infoArr[i].db_attribute_type;

      if (attr_name.equals("description")) {
      }
      else if (attr_type.indexOf("itrack_attach_file") > 0) {

	updateValue[updateValueCount] = makeAttachfileValue(con, mReq, attr_name, username);
	if (((UniSQLOID[]) updateValue[updateValueCount]).length > 0) {
	  if (updateValueCount != 0) {
	    query.append(", ");
	  }
	  query.append(attr_name);
	  query.append(" = ");
	  query.append(attr_name);
	  query.append(" + ? ");
	  runUpdate = true;
	  updateValueCount++;
	}
      }
      else if (!infoArr[i].reopenClear(action)) {
	String value = mReq.getParameter(attr_name);
	String org = mReq.getParameter("org_" + attr_name);
	if (value != null && org != null) {
	  value = value.trim();
	  org = org.trim();
	  if (!value.equals(org)) {
	    if (updateValueCount != 0) {
	      query.append(", ");
	    }
	    query.append(attr_name);
	    query.append(" = ? ");

	    if (attr_type.equals("date")) {
	      if (value.length() == 0)
		updateValue[updateValueCount] = null;
	      else
		updateValue[updateValueCount] = java.sql.Date.valueOf(value);
	    }
	    else {
	      updateValue[updateValueCount] = value;
	    }
	    updateValueCount++;

	    changeHistory.append("\n");
	    changeHistory.append(infoArr[i].display_name);
	    if (attr_name.equals("repro_step")) {
	      changeHistory.append("  ");
	    }
	    else {
	      changeHistory.append(" : ");
	      if (org.length() > 0) {
		changeHistory.append(org);
		changeHistory.append(" -> ");
	      }
	      changeHistory.append(value);
	    }
	    runUpdate = true;

	    if (attr_name.equals("assigned")) {
	      mailTo = value;
	    }
	  }
	}
      }
    }

    
    if (updateValueCount != 0) {
      query.append(", ");
    }
    query.append(" description = description + ? ");
    updateValue[updateValueCount] = makeDescriptionValue(mReq, "description", username, msg + changeHistory.toString());
    if (((String[]) updateValue[updateValueCount])[1].length() > 0) {
      runUpdate = true;
    }
    updateValueCount++;

    if (mailTo == null)
      appendUpdateAssigned(query, action);

    query.append(", last_update = ?");
    updateValue[updateValueCount] = new java.sql.Timestamp(System.currentTimeMillis());
    updateValueCount++;

    query.append(" where id in {");
    query.append(ITrackJsp.concatId(idArr, ", "));
    query.append("}");

    if (runUpdate == false)
      return null;

    ITrackDB.executeQuery(con, query.toString(), updateValue, updateValueCount);

    String resetQuery = appendUpdateResetQuery(action, infoArr, working_table, idArr);
    if (resetQuery != null)
      ITrackDB.executeQuery(con, resetQuery, null, 0);

    checkMandatoryField(con, action, infoArr, working_table, idArr);

    con.commit();
  } finally {
    ITrackDB.closeConnection(con);
  }

  return mailTo;
}

public static String findDisplayName(ITrackIssueInfo[] infoArr, String attr_name)
{
  for (int i=0 ; i < infoArr.length ; i++) {
    if (infoArr[i].db_attribute_name.equals(attr_name))
      return infoArr[i].display_name;
  }
  return "";
}

public static void printChangeConditionalMandatoryFieldScript(JspWriter out, ITrackIssueInfo[] infoArr, int action)
	throws IOException
{
  out.println("function changeConditionalMandatoryField(attr_name, value) {");

  for (int k=0 ; k < infoArr.length ; k++) {
    ITrackIssueInfo issueInfo = infoArr[k];
    if (!issueInfo.isMandatory(action, infoArr))
      continue;
    String[][] grantMandatory = issueInfo.grant_mandatory;
    if (grantMandatory == null)
      continue;
    out.println("if (attr_name == '" + issueInfo.db_attribute_name + "') {");
    for (int i=0 ; i < grantMandatory.length ; i++) {
      String checkValue = grantMandatory[i][0];
      String checkField = grantMandatory[i][1];
      out.println("tdid = window.document.all('td_" + checkField + "')");
      out.println("if (tdid != null) {");
      out.println("if (value == '" + checkValue + "')");
      out.println("tdid.style.color = '" + MANDATORY_FIELD_COLOR + "'");
      out.println("else");
      out.println("tdid.style.color = ''");
      out.println("}");
    }
    out.println("}");
  }

  out.println("}");
}

public static int findString(String[][] arr, int findcol, String value)
{
  if (arr == null)
    return -1;

  for (int i=0 ; i < arr.length ; i++) {
    if (arr[i][findcol].equals(value))
      return i;
  }
  return -1;
}

public static int findString(Object[] arr, String value)
{
  if (arr == null)
    return -1;

  for (int i=0 ; i < arr.length ; i++) {
    if (arr[i].equals(value))
      return i;
  }
  return -1;
}

/*=======================================================================
 |      PACKAGE ACCESS METHODS
 =======================================================================*/

static String selectValueConcat(String[] value)
{
  if (value == null)
    return null;

  StringBuffer tmp = new StringBuffer("");
  for (int i=0 ; i < value.length ; i++) {
    if (i != 0)
      tmp.append(":::");
    tmp.append(value[i]);
  }
  return tmp.toString();
}

static String[] selectValueSplit(String value)
{
  if (value == null)
    return null;
  return value.split(":::");
}

static String getDbAttributeType(ITrackIssueInfo[] infoArr, String attr_name)
{
  ITrackIssueInfo issueInfo = find(infoArr, attr_name);
  if (issueInfo == null)
    return null;
  return issueInfo.db_attribute_type;
}

/*=======================================================================
 |      PRIVATE METHODS
 =======================================================================*/

private static String[][] toWhereAttrArr(ITrackIssueInfo[] infoArr)
{
  String[][] selectList = new String[infoArr.length+1][2];

  selectList[0][0] = "";
  selectList[0][1] = "";
  for (int i=0 ; i < infoArr.length ; i++) {
    selectList[i+1][0] = infoArr[i].db_attribute_name;
    selectList[i+1][1] = infoArr[i].display_name;
  }
  return selectList;
}

private static ITrackIssueInfo find(ITrackIssueInfo[] infoArr, String attr_name)
{
  for (int i=0 ; i < infoArr.length ; i++) {
    if (infoArr[i].db_attribute_name.equals(attr_name))
      return infoArr[i];
    }
  return null;
}

private boolean isMandatory(int action, ITrackIssueInfo[] infoArr)
{

  if (db_attribute_name.equals("description")) {
    if (action != ITrackJsp.ITRACK_OPEN)
      return false;
  }

  boolean is_mandatory = false;

  if (action == ITrackJsp.ITRACK_OPEN || action == ITrackJsp.ITRACK_REOPEN) {
    if ("Y".equals(opened_mandatory))
      is_mandatory = true;
  }
  else if (action == ITrackJsp.ITRACK_RESOLVE) {
    if ("Y".equals(resolved_mandatory))
      is_mandatory = true;
  }
  else if (action == ITrackJsp.ITRACK_CLOSE) {
    if ("Y".equals(closed_mandatory))
      is_mandatory = true;
  }

  if (is_mandatory) {
    if (infoArr != null) {
      for (int i=0 ; i < infoArr.length ; i++) {
	if (infoArr[i].grant_mandatory == null)
	  continue;
	for (int j=0 ; j < infoArr[i].grant_mandatory.length ; j++) {
	  if (db_attribute_name.equals(infoArr[i].grant_mandatory[j][1]))
	    return false;
	}
      }
    }
    return true;
  }

  return false;
}

private void printAttachFile(JspWriter out, Object obj, String id, String username, int action)
        throws SQLException, IOException, NamingException
{
  if ((obj == null) || !(obj instanceof UniSQLOID[]))
    return;

  UniSQLOID[] oidArr = (UniSQLOID[]) obj;
  Connection con = null;
  String[] attach_file_attr = {"username", "filename"};

  try {
    con = ITrackDB.getConnection();

    for (int i=0 ; i < oidArr.length ; i++) {
      if (oidArr[i] == null) 
      	continue;
      
      ResultSet rs = oidArr[i].getValues(attach_file_attr);
      while (rs.next()) {
	ITrackHTML.Td(out, "");
        ITrackHTML.Space(out, 10);
        String url = "file_download.jsp?oid=" + oidArr[i].getOidString() + "&filename=" + rs.getString(2);
        ITrackHTML.A(out, "href='" + url + "' target='_blank'", rs.getString(2));
        ITrackHTML.Space(out, 1);

        if (username.equals(rs.getString(1))) {
        	ITrackHTML.InputButton(out, "del", "", "onClick=\"win_open('file_delete.jsp?oid=" + oidArr[i].getOidString() + "&id=" + id + "&action=" + action + "', '_self')\"");
        }

	ITrackHTML.Tr(out);
      }
      rs.close();
    }
  } catch (Exception e) {
	  e.printStackTrace();
  } finally {
    ITrackDB.closeConnection(con);
  }
}

private void printDescription(JspWriter out, ITrackIssueValue value)
        throws IOException
{
  Object obj = value.getObject("description");
  if ((obj == null) || !(obj instanceof String[]))
    return;

  ITrackHTML.Table(out, "border=0 celpadding=3 cellspacing=3 width=690");

  String[] description = (String[]) obj;
  int numItem = description.length / 2;
  for (int i = numItem - 1 ; i >= 0 ; i--) {
    ITrackHTML.Tr(out);
    ITrackHTML.Td(out, "colspan=2");

    out.println("<B> -");
    out.println(description[i*2].replaceAll("\n", "<BR>&nbsp;&nbsp;&nbsp;"));
    out.println("</B>");

    ITrackHTML.Tr(out);
    ITrackHTML.Td(out, "width=10");
    ITrackHTML.Td(out);
    String s = description[i*2+1];
    if (s == null)
      s = "";
    s = s.replaceAll("<", "&lt;").replaceAll("\n", "<BR>");
    out.println(s);
  }

  ITrackHTML.TableEnd(out);
}

private static String[] makeDescriptionValue(MultipartRequest mReq, String attr_name, String username, String msg)
{
  SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
  String[] strArr = new String[2];

  strArr[0] = dateFormat.format(new Timestamp(System.currentTimeMillis())) + " (" + username + ") " + msg;
  strArr[1] = mReq.getParameter(attr_name);
  if (strArr[1] == null)
    strArr[1] = "";

  return strArr;
}

private static UniSQLOID[] makeAttachfileValue(Connection con, MultipartRequest mReq, String attr_name, String username)
	throws IOException, SQLException
{
  UniSQLOID[] fileArr = new UniSQLOID[1];
  fileArr[0] = ITrackDB.insertFile(con, mReq.getFile(attr_name), username, mReq.getOriginalFileName(attr_name));

  if (fileArr[0] == null)
    fileArr = new UniSQLOID[0];

  return fileArr;
}

private String makeDefaultValue(int action, String username, ITrackIssueValue value)
{

  if (action == ITrackJsp.ITRACK_OPEN) {
    if (db_attribute_name.equals("status"))
      return "̰";
    if (db_attribute_name.equals("opened_date"))
      return (new Date(System.currentTimeMillis())).toString();
    if (db_attribute_name.equals("opened_by"))
      return username;
    if (db_attribute_name.equals("assigned")) {
      String curStatus = value.getString("status");
      if (curStatus.equals("ذ")) {
	return value.getString("resolved_by");
      }
      else if (curStatus.equals("")) {
	return value.getString("closed_by");
      }
    }
    if ((resolved_mandatory.equals("Y") || closed_mandatory.equals("Y")) &&
        (!opened_mandatory.equals("Y")))
    {
      return "";
    }
  } 
  else if (action == ITrackJsp.ITRACK_REOPEN) {
	if (db_attribute_name.equals("status"))
	  return "̰";

    if (db_attribute_name.equals("assigned")) {
      String curStatus = value.getString("status");

      if (curStatus.equals("ذ")) {
	  	return value.getString("resolved_by");
	  }
	  else if (curStatus.equals("")) {
	  	return value.getString("closed_by");
	  }
	}
	
    if ((resolved_mandatory.equals("Y") || closed_mandatory.equals("Y")) &&
	   (!opened_mandatory.equals("Y")))
	{
	  return "";
	}
  }
  else if (action == ITrackJsp.ITRACK_RESOLVE) {
    if (db_attribute_name.equals("status"))
      return "ذ";
    if (db_attribute_name.equals("resolved_date"))
      return (new Date(System.currentTimeMillis())).toString();
    if (db_attribute_name.equals("resolved_by"))
      return username;
    if (db_attribute_name.equals("assigned"))
      return value.getString("opened_by");
  }
  else if (action == ITrackJsp.ITRACK_CLOSE) {
    if (db_attribute_name.equals("status"))
      return "";
    if (db_attribute_name.equals("closed_date"))
      return (new Date(System.currentTimeMillis())).toString();
    if (db_attribute_name.equals("closed_by"))
      return username;
  }

  return null;
}

private static void checkMandatoryField(Connection con, int action, ITrackIssueInfo[] infoArr, String working_table, String[] idArr)
	throws ITrackException, SQLException, NamingException
{
  if (action == ITrackJsp.ITRACK_NONE)
    return;

  StringBuffer errMsg = new StringBuffer("");

  Object[][] values = ITrackIssueValue.selectIssueValues(con, working_table, idArr);
  if (values == null || values.length <= 1)
    return;

  for (int i=0 ; i < infoArr.length ; i++) {
    ITrackIssueInfo issueInfo = infoArr[i];
    boolean mandatory = issueInfo.isMandatory(action, infoArr);

    if (mandatory) {
      int index;

      index = findString(values[0], issueInfo.db_attribute_name);
      if (index >= 0) {
	int[] nullCols = findNullCols(values, index, 1);
	for (int k=0 ; k < nullCols.length ; k++) {
	  if (errMsg.length() > 0)
	    errMsg.append(", ");
	  errMsg.append(idArr[nullCols[k] - 1]);
	  errMsg.append(":");
	  errMsg.append(issueInfo.display_name);
	}
      }

      String[][] grantMandatory = issueInfo.grant_mandatory;
      if (grantMandatory != null) {
	for (int k=0 ; k < grantMandatory.length ; k++) {
	  int grantMandatoryField = findString(values[0], grantMandatory[k][1]);
	  for (int j=1 ; j < values.length ; j++) {
	    if ((grantMandatory[k][0].equals(values[j][index])) &&
		(values[j][grantMandatoryField] == null ||
		  values[j][grantMandatoryField].equals("")))
	    {
	      if (errMsg.length() > 0)
		errMsg.append(", ");
	      errMsg.append(idArr[j-1]);
	      errMsg.append(":");
	      ITrackIssueInfo tmpInfo = find(infoArr, grantMandatory[k][1]);
	      if (tmpInfo != null)
		errMsg.append(tmpInfo.display_name);
	    }
	  }
	}
      }
    }
  }

  if (errMsg.length() > 0) {
    throw new ITrackException("  ʼ׸<BR>" + errMsg.toString());
  }
}

private static void appendUpdateAssigned(StringBuffer query, int action)
{
  if (action == ITrackJsp.ITRACK_REOPEN) {
    query.append(", assigned = decode(status, 'ذ', resolved_by, '', closed_by, assigned ) ");
  }
  else if (action == ITrackJsp.ITRACK_RESOLVE) {
    query.append(", assigned = opened_by ");
  }
}

private static String appendUpdateResetQuery(int action, ITrackIssueInfo[] infoArr, String tablename, String[] idArr)
{
  if (action != ITrackJsp.ITRACK_REOPEN)
    return null;

  StringBuffer query = new StringBuffer("");
  for (int i=0 ; i < infoArr.length ; i++) {
    /*
    if (("Y".equals(infoArr[i].resolved_mandatory) ||
        ("Y".equals(infoArr[i].closed_mandatory))) &&
	!("Y".equals(infoArr[i].opened_mandatory)))
    */
    if (infoArr[i].reopenClear(action))
    {
      if (query.length() > 0)
	query.append(", ");
      query.append(infoArr[i].db_attribute_name);
      query.append(" = ");
      if (infoArr[i].db_attribute_type.indexOf("date") >= 0)
	query.append("null");
      else
	query.append("''");
      query.append(" ");
    }
  }

  if (query.length() == 0)
    return null;

  return ("update " + tablename + " set " + query.toString() + " where id in { " + ITrackJsp.concatId(idArr, ", ") + " } ");
}

private static int[] findNullCols(Object[][] values, int col, int start_index)
{
  int[] res = new int[values.length];
  int resLen = 0;

  for (int i=start_index ; i < values.length ; i++) {
    if (values[i][col] == null || values[i][col].equals("")) {
      res[resLen++] = i;
    }
  }

  int[] tmp = new int[resLen];
  System.arraycopy(res, 0, tmp, 0, resLen);

  return tmp;
}

private boolean reopenClear(int action)
{
  if (action != ITrackJsp.ITRACK_REOPEN)
    return false;

  if ("Y".equals(opened_mandatory))
    return false;

  if ("Y".equals(resolved_mandatory) || "Y".equals(closed_mandatory))
    return true;

  return false;
}

}
