package unisql.itrack;

import java.io.*;
import java.util.HashMap;

public class ITrackTemplate {

/*=======================================================================
 |      PRIVATE VARIABLES
 =======================================================================*/

private final static int currentFormatVersion = 1;

private Integer formatVersion;

HashMap map;

/*=======================================================================
 |      PACKAGE ACCESS VARIABLES
 =======================================================================*/

/*=======================================================================
 |      CONSTRUCTOR
 =======================================================================*/

public ITrackTemplate(HashMap map)
{
  this.formatVersion = new Integer(currentFormatVersion);
  this.map = map;
}

/*=======================================================================
 |      PACKAGE ACCESS METHODS
 =======================================================================*/

void save(String filename)
        throws IOException
{
  FileOutputStream fo = new FileOutputStream(filename);
  ObjectOutputStream oo = new ObjectOutputStream(fo);

  oo.writeObject(formatVersion);
  oo.writeObject(map);

  oo.close();
  fo.close();
}

static ITrackTemplate load(String filename)
        throws IOException, ClassNotFoundException
{
  File f = new File(filename);
  if (!f.exists())
    return null;

  FileInputStream fi = new FileInputStream(filename);
  ObjectInputStream oi = new ObjectInputStream(fi);

  Integer version = (Integer) oi.readObject();
  if (version.intValue() != currentFormatVersion) {
    throw new ITrackException("   ϴ");
  }

  HashMap map = (HashMap) oi.readObject();
  oi.close();
  fi.close();

  return (new ITrackTemplate(map));
}

/*=======================================================================
 |      PRIVATE METHODS
 =======================================================================*/

}

