<%@ page contentType="text/html;charset=euc-kr" session="true" %>
<%@ page import="java.sql.*" %>
<%@ page import="java.net.*" %>
<%@ page import="java.util.*" %>
<%@ page import="unisql.itrack.*" %>
<% request.setCharacterEncoding("euc-kr"); %>
<% response.setHeader("Cache-Control","No-cache");
%>

<% ITrackHTML.Head(out, "ITrack");  %>

<script language="javascript" src=javascript.js>
</script>

<script language="javascript">
  function check_all(form, value) {
    for (i=0 ; i < form.elements.length ; i++) {
      if (form.elements[i].type == 'checkbox') {
	form.elements[i].checked = value;
      }
    }
  }

  function view_multiple(form, url) {
    selectCount = 0
    querystring = '?'
    idstr = ''
    for (i=0 ; i < form.elements.length ; i++ ) {
      if (form.elements[i].type == 'checkbox') {
	if (form.elements[i].checked) {
	  if (querystring != '')
	    querystring += '&'
	  querystring += 'id=' + form.elements[i].name
	  idstr += form.elements[i].name
	}
      }
    }
    if (querystring == '?') {
      alert('õ ̽ ϴ')
      return
    }
    win = window.open(url + querystring , idstr, "status=yes, resizable=yes, scrollbars=yes");
    win.focus();
  }
</script>

<BODY>

<%
  String working_table = (String) session.getAttribute(ITrackJsp.SESSION_KEY_WORKING_TABLE);
  String userid = (String) session.getAttribute(ITrackJsp.SESSION_KEY_USERID);
  String username = (String) session.getAttribute(ITrackJsp.SESSION_KEY_USERNAME);
  String info_table = (String) session.getAttribute(ITrackJsp.SESSION_KEY_INFO_TABLE);
  if (userid == null) {
    ITrackHTML.writeErrorMsg(out, ITrackMsg.session_invalid);
    return;
  }
  ITrackIssueInfo[] issueInfoArr = ITrackIssueInfo.getIssueInfoArray(info_table);
%>

<%
  String opcode = request.getParameter("opcode");
  if (opcode == null)
    opcode = "";

  if (opcode.equals("load")) {
    String url = "issue_search_form.jsp?form_filename=" + URLEncoder.encode(request.getParameter("form_filename"));
    ITrackJsp.redirect(response, url);
  }
  else if (opcode.equals("delete")) {
    String formFilename = request.getParameter("form_filename");
    ITrackFile.deleteFormfile(working_table, userid, formFilename);
    ITrackJsp.redirect(response, "issue_search_form.jsp");
  }
  else if (opcode.equals("save")) {
    String[] selectList = ITrackIssueInfo.getSelectList(request, issueInfoArr, null);
    String[][] whereList = ITrackIssueInfo.getWhereList(request, issueInfoArr);
    String[][] orderbyList = ITrackIssueInfo.getOrderbyList(request, issueInfoArr);
    ITrackSearchForm srchFrm = new ITrackSearchForm(selectList, whereList, orderbyList);
    String saveFilename = request.getParameter("form_new_filename");
    ITrackFile.saveFormfile(working_table, userid, saveFilename, srchFrm);
    String url = "issue_search_form.jsp?form_filename=" + URLEncoder.encode(saveFilename);
    ITrackJsp.redirect(response, url);
  }
  else if (opcode.equals("search")) {
    //String[] selectList = ITrackIssueInfo.getSelectList(request, issueInfoArr, null);
    String[][] whereList = ITrackIssueInfo.getWhereList(request, issueInfoArr);
    String[][] orderbyList = ITrackIssueInfo.getOrderbyList(request, issueInfoArr);
    /*
    ITrackSearchForm srchFrm = new ITrackSearchForm(selectList, whereList, orderbyList);
    ITrackFile.saveTmpFormfile(working_table, userid, srchFrm);
    */

    String[] selectList = ITrackIssueInfo.getSelectList(request, issueInfoArr, working_table);
    Object[][] queryInfo = ITrackDB.makeQuery(issueInfoArr, selectList, whereList, orderbyList, working_table);

    String query = (String) queryInfo[0][0];

    Connection con = null;
    try {
      con = ITrackDB.getConnection();
      PreparedStatement pstmt = con.prepareStatement(query);
      for (int i=0 ; i < queryInfo[1].length ; i++) {
	pstmt.setObject(i+1, queryInfo[1][i]);
      }
      ResultSet rs = pstmt.executeQuery();

      int colCount = rs.getMetaData().getColumnCount();
      List results = new ArrayList();
      
      while (rs.next()) {
    	 List aRow = new ArrayList();
    	 for(int i = 0; i < colCount; i ++) {
    		 aRow.add(rs.getString(i + 1));
    	 }
    	 results.add(aRow);
      }
      
      rs.close();
%>
˻ : <%= results.size() %> 
<%      
      String colSpanStr = "colspan=" + (selectList.length - 1);

      ITrackHTML.Form(out, "name=multiple_update method=get");

      ITrackHTML.Table(out, "border=0");

      ITrackHTML.Td(out, "");
      for (int i=2 ; i < selectList.length ; i++) {
		ITrackHTML.Td(out, "nowrap align=center");
		out.println(ITrackIssueInfo.findDisplayName(issueInfoArr, selectList[i]));
      }
      ITrackHTML.Tr(out);

      ITrackHTML.Td(out, colSpanStr + " class='lineStyle_th'");
      ITrackHTML.Tr(out);

      StringBuffer idlist = new StringBuffer();
 //     while (rs.next()) {
	 for(Iterator i = results.iterator(); i.hasNext(); ) {
		 List aRow = (List) i.next();
	ITrackHTML.Td(out, "nowrap");

	String imageSrc = "'" + ITrackJsp.getImageFile((String)aRow.get(1)) + "'";
//	String linkAction = "href='#' onClick=\"win_open('" +
//			    ITrackJsp.makeDetailViewURL(rs.getString(1)) +
//			    "', '" + rs.getString(1) + "')\"";

	String linkAction = "href='" + ITrackJsp.makeDetailViewURL((String)aRow.get(0)) +
			    "' target='_blank'";
	idlist.append((String)aRow.get(0));
	idlist.append(",");

	ITrackHTML.InputCheckbox(out, (String)aRow.get(0), "", false, "");

	ITrackHTML.A(out, linkAction, "<IMG SRC=" + imageSrc + ">");
	ITrackHTML.Space(out, 1);

	for (int j=2 ; j < selectList.length ; j++) {
	  ITrackHTML.Td(out, "nowrap");
	  ITrackHTML.Space(out, 1);
	  if (selectList[j].equals("id") || selectList[j].equals("title")) {
	    ITrackHTML.A(out, linkAction, (String)aRow.get(j));
	  }
	  else {
	    String s = (String)aRow.get(j);
	    if (s == null)
	      s = "";
	    out.println(s);
	  }
	  ITrackHTML.Space(out, 1);
	}
	ITrackHTML.Tr(out);
	ITrackHTML.Td(out, colSpanStr + " class='lineStyle_td'");
	ITrackHTML.Tr(out);
      }

      ITrackHTML.Tr(out);
      ITrackHTML.Td(out, colSpanStr + " class='lineStyle_th'");
      ITrackHTML.TableEnd(out);

      ITrackHTML.InputButton(out, "checkAll", "ü", "onClick=\"check_all(multiple_update, true)\"");
      ITrackHTML.InputButton(out, "checkAll", "", "onClick=\"check_all(multiple_update, false)\"");
      ITrackHTML.InputButton(out, "update", "׷", "onClick=\"view_multiple(multiple_update,'" + ITrackJsp.makeDetailViewURL() + "')\"");
      ITrackHTML.Space(out, 10);

      ITrackHTML.FormEnd(out);

      session.setAttribute("searched_list", idlist.toString());
            
      pstmt.close();
    } finally {
      ITrackDB.closeConnection(con);
    }
  }
%>

