/*
 * Created on 2005. 5. 11.
 */
package net.javajigi.initailize;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

import net.javajigi.timer.Log4JConfRefreshTimer;

import org.apache.log4j.Logger;

/**
 * @author Administrator
 */
public class InitializeServlet extends HttpServlet {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = Logger
			.getLogger(InitializeServlet.class);

	private Log4JConfRefreshTimer timer = null; 
	/**
	 * 
	 */
	public InitializeServlet() {
	}

	
	/* (non-Javadoc)
	 * @see javax.servlet.GenericServlet#init()
	 */
	public void init() throws ServletException {
		if( logger.isInfoEnabled() ) {
			logger.info("Application Initialize Start!!");
		}
		
		String log4jFilePath = getInitParameter("log4jFilePath");
		String refreshTime = getInitParameter("refreshTime");
		
		if( logger.isDebugEnabled() ) {
			logger.debug("Log4J Configuration File Path : " + log4jFilePath);
			logger.debug("Timer Refresh Time : " + refreshTime);
		}
		
		long time = 1000;
		if ( refreshTime != null ) {
			time = Long.parseLong(refreshTime);
		}
		
		timer = new Log4JConfRefreshTimer();
		timer.startLogFileMonitor(time, log4jFilePath);
		
		if( logger.isInfoEnabled() ) {
			logger.info("Application Initialize Success!!");
		}		
	}
	
	
	/* (non-Javadoc)
	 * @see javax.servlet.Servlet#destroy()
	 */
	public void destroy() {
		super.destroy();
		timer.cancel();
	}
}
