/*
 * Created on 2005. 5. 10.
 */
package net.javajigi.security.dao.springjdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.List;

import javax.sql.DataSource;

import net.javajigi.security.dao.UserDAO;
import net.javajigi.security.model.User;

import org.apache.log4j.Logger;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.object.MappingSqlQuery;

/**
 * @author Administrator
 */
public class UserDAOSpringJDBC extends JdbcDaoSupport implements UserDAO {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = Logger
			.getLogger(UserDAOSpringJDBC.class);

	/**
	 *  
	 */
	public UserDAOSpringJDBC() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.javajigi.security.dao.UserDAO#addUser(net.javajigi.security.model.User)
	 */
	public void addUser(User newUser) {
		String insertQuery = "insert into userinfo values(?,?,?,?)";

		getJdbcTemplate().update(
				insertQuery,
				new Object[] { newUser.getUserId(), newUser.getPassword(),
						newUser.getName(), newUser.getEmail() });
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.javajigi.security.dao.UserDAO#updateUser(net.javajigi.security.model.User)
	 */
	public void updateUser(User newUser) {
		String updateQuery = "update userinfo set password=?, name=?, email=? where userId=?";

		getJdbcTemplate().update(
				updateQuery,
				new Object[] { newUser.getPassword(), newUser.getName(),
						newUser.getEmail(), newUser.getUserId() });
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.javajigi.security.dao.UserDAO#removeUser(java.lang.String)
	 */
	public void removeUser(String userId) {
		String deleteQuery = "delete from userinfo where userId = ?";

		getJdbcTemplate().update(deleteQuery, new Object[] { userId });
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.javajigi.security.dao.UserDAO#findUser(java.lang.String)
	 */
	public User findUser(String userId) {
		UserQuery query = new UserQuery(getDataSource());

		return (User) query.findObject(userId);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.javajigi.security.dao.UserDAO#findUserList()
	 */
	public List findUserList() {
		String findQuery = "select userId, password, name, email from userinfo";

		UsersQuery query = new UsersQuery(getDataSource(), findQuery);

		return query.execute();
	}

	/**
	 * Abstract base class for all <code>User</code> Query Objects.
	 */
	protected class UsersQuery extends MappingSqlQuery {
		/**
		 * Logger for this class
		 */
		private final Logger logger = Logger.getLogger(UsersQuery.class);

		/**
		 * Create a new instance of OwnersQuery.
		 * 
		 * @param ds
		 *            the DataSource to use for the query
		 * @param sql
		 *            SQL string to use for the query
		 */
		protected UsersQuery(DataSource ds, String sql) {
			super(ds, sql);
		}

		protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
			User user = new User();
			user.setUserId(rs.getString("userId"));
			user.setPassword(rs.getString("password"));
			user.setName(rs.getString("name"));
			user.setEmail(rs.getString("email"));

			return user;
		}
	}

	/**
	 * <code>User</code> by id Query Object.
	 */
	protected class UserQuery extends UsersQuery {
		/**
		 * Logger for this class
		 */
		private final Logger logger = Logger.getLogger(UserQuery.class);

		/**
		 * Create a new instance of OwnerQuery.
		 * 
		 * @param ds
		 *            the DataSource to use for the query
		 */
		protected UserQuery(DataSource ds) {
			super(ds,
					"select userId, password, name, email from userinfo where userId = ?");
			declareParameter(new SqlParameter(Types.VARCHAR));
			compile();
		}
	}
}
