/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.plugins.PluginAssertionFailure;
import org.apache.commons.digester.plugins.PluginWrappedException;
import org.apache.commons.logging.Log;

public class Declaration {
    public static final String DFLT_RULE_METHOD_NAME = "addRules";
    private Class pluginClass;
    private String pluginClassName;
    private String id;
    private String ruleMethodName = "addRules";
    private Class ruleClass;
    private String ruleResource;
    private File ruleFile;
    private boolean autoSetProperties = true;
    private boolean initialized = false;
    static /* synthetic */ Class class$org$apache$commons$digester$Digester;
    static /* synthetic */ Class class$java$lang$String;

    public Declaration(Class pluginClass) {
        this.pluginClass = pluginClass;
        this.pluginClassName = pluginClass.getName();
    }

    public Declaration(String pluginClassName) {
        this.pluginClassName = pluginClassName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRuleMethod(String ruleMethodName) {
        this.ruleMethodName = ruleMethodName;
    }

    public void setRuleClass(Class ruleClass) {
        this.ruleClass = ruleClass;
    }

    public void setRuleResource(String ruleResource) {
        this.ruleResource = ruleResource;
    }

    public void setRuleFile(File ruleFile) {
        this.ruleFile = ruleFile;
    }

    public void setAutoSetProperties(boolean autoSetProperties) {
        this.autoSetProperties = autoSetProperties;
    }

    public String getId() {
        return this.id;
    }

    public Class getPluginClass() {
        return this.pluginClass;
    }

    public Class getRuleClass() {
        return this.ruleClass;
    }

    public boolean autoSetProperties() {
        return this.autoSetProperties;
    }

    public void init(Digester digester) throws PluginWrappedException {
        Log log = digester.getLogger();
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)"init being called!");
        }
        if (this.initialized) {
            throw new PluginAssertionFailure("Init called multiple times.");
        }
        if (this.pluginClass == null && this.pluginClassName != null) {
            try {
                this.pluginClass = digester.getClassLoader().loadClass(this.pluginClassName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new PluginWrappedException("Unable to load class " + this.pluginClassName, cnfe);
            }
        }
        this.initialized = true;
    }

    public void configure(Digester digester, String pattern) throws PluginWrappedException {
        Class<?> ruleClass;
        InputStream is;
        Log log = digester.getLogger();
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)"configure being called!");
        }
        if (!this.initialized) {
            throw new PluginAssertionFailure("Not initialized.");
        }
        if (this.ruleFile != null) {
            FileInputStream is2 = null;
            try {
                is2 = new FileInputStream(this.ruleFile);
            }
            catch (IOException ioe) {
                throw new PluginWrappedException("Unable to process file [" + this.ruleFile + "]", ioe);
            }
            this.loadRulesFromStream(is2, digester, pattern);
            return;
        }
        if (this.ruleResource != null && (is = this.pluginClass.getClassLoader().getResourceAsStream(this.ruleResource)) != null) {
            this.loadRulesFromStream(is, digester, pattern);
            return;
        }
        if (this.ruleClass != null) {
            this.loadRulesFromClass(this.ruleClass, digester, pattern);
            return;
        }
        Class[] paramSpec = new Class[]{class$org$apache$commons$digester$Digester == null ? (class$org$apache$commons$digester$Digester = Declaration.class$("org.apache.commons.digester.Digester")) : class$org$apache$commons$digester$Digester, class$java$lang$String == null ? (class$java$lang$String = Declaration.class$("java.lang.String")) : class$java$lang$String};
        Method ruleMethod = MethodUtils.getAccessibleMethod((Class)this.pluginClass, (String)this.ruleMethodName, (Class[])paramSpec);
        if (ruleMethod != null) {
            try {
                Object[] params = new Object[]{digester, pattern};
                Object none = ruleMethod.invoke(null, params);
            }
            catch (Exception e) {
                throw new PluginWrappedException("Unable to configure class [" + this.pluginClass + "]" + " using method [" + this.ruleMethodName + "]", e);
            }
            return;
        }
        if (debug) {
            log.debug((Object)("plugin class type:" + this.pluginClass.getName()));
        }
        String ruleClassName = this.pluginClass.getName() + "RuleInfo";
        try {
            ruleClass = digester.getClassLoader().loadClass(ruleClassName);
        }
        catch (ClassNotFoundException cnfe) {
            ruleClass = null;
        }
        if (ruleClass != null) {
            this.loadRulesFromClass(ruleClass, digester, pattern);
            return;
        }
        String resourceName = this.pluginClass.getClass().getName().replace('.', '/') + "RuleInfo.xml";
        InputStream is3 = this.pluginClass.getClassLoader().getResourceAsStream(resourceName);
        if (is3 != null) {
            this.loadRulesFromStream(is3, digester, pattern);
            return;
        }
        if (this.autoSetProperties) {
            if (debug) {
                log.debug((Object)("adding autoset for pattern [" + pattern + "]"));
            }
            digester.addSetProperties(pattern);
        }
    }

    private void loadRulesFromStream(InputStream is, Digester digester, String pattern) throws PluginWrappedException {
        try {
            throw new PluginAssertionFailure("Load from stream not yet supported.");
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                is.close();
            }
            catch (IOException ioe) {
                Log log = digester.getLogger();
                log.warn((Object)"Unable to close stream after reading rules", (Throwable)ioe);
            }
            throw throwable;
        }
    }

    private void loadRulesFromClass(Class ruleClass, Digester digester, String pattern) throws PluginWrappedException {
        Class[] paramSpec = new Class[]{class$org$apache$commons$digester$Digester == null ? (class$org$apache$commons$digester$Digester = Declaration.class$("org.apache.commons.digester.Digester")) : class$org$apache$commons$digester$Digester, class$java$lang$String == null ? (class$java$lang$String = Declaration.class$("java.lang.String")) : class$java$lang$String};
        Method ruleMethod = MethodUtils.getAccessibleMethod((Class)ruleClass, (String)this.ruleMethodName, (Class[])paramSpec);
        if (ruleMethod == null) {
            throw new PluginWrappedException("rule class specified, but rules method not found on it.");
        }
        try {
            Object[] params = new Object[]{digester, pattern};
            Object none = ruleMethod.invoke(null, params);
        }
        catch (Exception e) {
            throw new PluginWrappedException("Unable to configure class [" + this.pluginClass + "]" + " using rule class [" + ruleClass + "]" + " method [" + this.ruleMethodName + "]", e);
        }
    }

    public boolean isEquivalent(Declaration d) {
        if (Declaration.different(this.id, d.id)) {
            return false;
        }
        if (this.pluginClass != d.pluginClass) {
            return false;
        }
        if (Declaration.different(this.ruleMethodName, d.ruleMethodName)) {
            return false;
        }
        if (this.ruleClass != d.ruleClass) {
            return false;
        }
        if (Declaration.different(this.ruleResource, d.ruleResource)) {
            return false;
        }
        if (Declaration.different(this.ruleFile, d.ruleFile)) {
            return false;
        }
        return this.autoSetProperties == d.autoSetProperties;
    }

    private static boolean different(Object o1, Object o2) {
        if (o1 == null) {
            return o1 == null;
        }
        return o1.equals(o2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

