/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester.plugins;

import java.io.File;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.plugins.Declaration;
import org.apache.commons.digester.plugins.PluginInvalidInputException;
import org.apache.commons.digester.plugins.PluginManager;
import org.apache.commons.digester.plugins.PluginRules;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;

public class PluginDeclarationRule
extends Rule {
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        Log log = this.digester.getLogger();
        boolean debug = log.isDebugEnabled();
        String id = attributes.getValue("id");
        String pluginClassName = attributes.getValue("class");
        String ruleMethodName = attributes.getValue("method");
        String ruleClassName = attributes.getValue("ruleclass");
        String ruleResource = attributes.getValue("resource");
        String ruleFile = attributes.getValue("file");
        String autoSetPropertiesStr = attributes.getValue("setprops");
        if (debug) {
            log.debug((Object)("mapping id [" + id + "] -> [" + pluginClassName + "]"));
        }
        if (id == null) {
            throw new PluginInvalidInputException("mandatory attribute id not present on tag <" + name + ">");
        }
        if (pluginClassName == null) {
            throw new PluginInvalidInputException("mandatory attribute class not present on tag <" + name + ">");
        }
        Declaration newDecl = new Declaration(pluginClassName);
        newDecl.setId(id);
        if (ruleMethodName != null) {
            newDecl.setRuleMethod(ruleMethodName);
        }
        if (ruleClassName != null) {
            Class<?> ruleClass;
            try {
                ruleClass = this.digester.getClassLoader().loadClass(ruleClassName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ClassNotFoundException("Rule class [" + ruleClassName + "] not found.");
            }
            newDecl.setRuleClass(ruleClass);
        }
        if (ruleResource != null) {
            newDecl.setRuleResource(ruleResource);
        }
        if (ruleFile != null) {
            newDecl.setRuleFile(new File(ruleFile));
        }
        if (autoSetPropertiesStr != null) {
            newDecl.setAutoSetProperties(Boolean.valueOf(autoSetPropertiesStr));
        }
        newDecl.init(this.digester);
        PluginRules rc = (PluginRules)this.digester.getRules();
        PluginManager pm = rc.getPluginManager();
        Declaration oldDecl = pm.getDeclarationById(id);
        if (oldDecl != null) {
            if (oldDecl.isEquivalent(newDecl)) {
                if (debug) {
                    log.debug((Object)"plugin redeclaration is identical: ignoring");
                }
                return;
            }
            throw new PluginInvalidInputException("Plugin id [" + id + "] is not unique");
        }
        if (pm.getDeclarationByClass(pluginClassName) != null) {
            throw new PluginInvalidInputException("Plugin id [" + id + "] maps to class [" + pluginClassName + "]" + " which has already been mapped by some other id.");
        }
        pm.addDeclaration(newDecl);
    }
}

