/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester.plugins;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.RulesBase;
import org.apache.commons.digester.plugins.InitializableRule;
import org.apache.commons.digester.plugins.LogUtils;
import org.apache.commons.digester.plugins.PluginAssertionFailure;
import org.apache.commons.digester.plugins.PluginConfigurationException;
import org.apache.commons.digester.plugins.PluginCreateRule;
import org.apache.commons.digester.plugins.PluginManager;
import org.apache.commons.logging.Log;

public class PluginRules
implements Rules {
    private Rules decoratedRules;
    protected Digester digester = null;
    private PluginCreateRule currPluginCreateRule = null;
    private PluginManager pluginManager;
    private Rules parent;

    public PluginRules() {
        this.decoratedRules = new RulesBase();
        this.pluginManager = new PluginManager();
    }

    public PluginRules(Rules decoratedRules) {
        this.decoratedRules = decoratedRules;
        this.pluginManager = new PluginManager();
    }

    PluginRules(PluginCreateRule pcr, PluginRules parent) {
        this.decoratedRules = new RulesBase();
        this.parent = parent;
        this.pluginManager = new PluginManager(parent.pluginManager);
    }

    public Rules getParent() {
        return this.parent;
    }

    public Digester getDigester() {
        return this.digester;
    }

    public void setDigester(Digester digester) {
        this.digester = digester;
        this.decoratedRules.setDigester(digester);
    }

    public String getNamespaceURI() {
        return this.decoratedRules.getNamespaceURI();
    }

    public void setNamespaceURI(String namespaceURI) {
        this.decoratedRules.setNamespaceURI(namespaceURI);
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public List rules() {
        return this.decoratedRules.rules();
    }

    public void add(String pattern, Rule rule) {
        Log log = LogUtils.getLogger(this.digester);
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("add entry: mapping pattern [" + pattern + "]" + " to rule of type [" + rule.getClass().getName() + "]"));
        }
        if (pattern.startsWith("/")) {
            pattern = pattern.substring(1);
        }
        this.decoratedRules.add(pattern, rule);
        if (rule instanceof InitializableRule) {
            try {
                ((InitializableRule)((Object)rule)).postRegisterInit(pattern);
            }
            catch (PluginConfigurationException e) {
                if (debug) {
                    log.debug((Object)"Rule initialisation failed", (Throwable)e);
                }
                return;
            }
        }
        if (debug) {
            log.debug((Object)("add exit: mapped pattern [" + pattern + "]" + " to rule of type [" + rule.getClass().getName() + "]"));
        }
    }

    public void clear() {
        this.decoratedRules.clear();
    }

    public List match(String pattern) {
        return this.match(null, pattern);
    }

    public List match(String namespaceURI, String pattern) {
        ArrayList<PluginCreateRule> matches;
        Log log = LogUtils.getLogger(this.digester);
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("Matching pattern [" + pattern + "] on rules object " + this.toString()));
        }
        if (this.currPluginCreateRule != null && pattern.length() > this.currPluginCreateRule.getPattern().length()) {
            if (debug) {
                log.debug((Object)("Pattern [" + pattern + "] matching PluginCreateRule " + this.currPluginCreateRule.toString()));
            }
            matches = new ArrayList<PluginCreateRule>(1);
            matches.add(this.currPluginCreateRule);
        } else {
            matches = this.decoratedRules.match(namespaceURI, pattern);
        }
        return matches;
    }

    public void beginPlugin(PluginCreateRule pcr) {
        Log log = LogUtils.getLogger(this.digester);
        boolean debug = log.isDebugEnabled();
        if (this.currPluginCreateRule != null) {
            throw new PluginAssertionFailure("endPlugin called when currPluginCreateRule is not null.");
        }
        if (debug) {
            log.debug((Object)("Entering PluginCreateRule " + pcr.toString() + " on rules object " + this.toString()));
        }
        this.currPluginCreateRule = pcr;
    }

    public void endPlugin(PluginCreateRule pcr) {
        Log log = LogUtils.getLogger(this.digester);
        boolean debug = log.isDebugEnabled();
        if (this.currPluginCreateRule == null) {
            throw new PluginAssertionFailure("endPlugin called when currPluginCreateRule is null.");
        }
        if (this.currPluginCreateRule != pcr) {
            throw new PluginAssertionFailure("endPlugin called with unexpected PluginCreateRule instance.");
        }
        this.currPluginCreateRule = null;
        if (debug) {
            log.debug((Object)("Leaving PluginCreateRule " + pcr.toString() + " on rules object " + this.toString()));
        }
    }
}

