/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodUtils {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$beanutils$MethodUtils == null ? (class$org$apache$commons$beanutils$MethodUtils = MethodUtils.class$("org.apache.commons.beanutils.MethodUtils")) : class$org$apache$commons$beanutils$MethodUtils));
    private static boolean loggedAccessibleWarning = false;
    private static final Class[] emptyClassArray = new Class[0];
    private static final Object[] emptyObjectArray = new Object[0];
    private static WeakHashMap cache = new WeakHashMap();
    static /* synthetic */ Class class$org$apache$commons$beanutils$MethodUtils;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;

    public static Object invokeMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return MethodUtils.invokeMethod(object, methodName, args);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = emptyObjectArray;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return MethodUtils.invokeMethod(object, methodName, args, parameterTypes);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (parameterTypes == null) {
            parameterTypes = emptyClassArray;
        }
        if (args == null) {
            args = emptyObjectArray;
        }
        if ((method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return MethodUtils.invokeExactMethod(object, methodName, args);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = emptyObjectArray;
        }
        int arguments = args.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        return MethodUtils.invokeExactMethod(object, methodName, args, parameterTypes);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args, Class[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (args == null) {
            args = emptyObjectArray;
        }
        if (parameterTypes == null) {
            parameterTypes = emptyClassArray;
        }
        if ((method = MethodUtils.getAccessibleMethod(object.getClass(), methodName, parameterTypes)) == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Method getAccessibleMethod(Class clazz, String methodName, Class parameterType) {
        Class[] parameterTypes = new Class[]{parameterType};
        return MethodUtils.getAccessibleMethod(clazz, methodName, parameterTypes);
    }

    public static Method getAccessibleMethod(Class clazz, String methodName, Class[] parameterTypes) {
        try {
            MethodDescriptor md = new MethodDescriptor(clazz, methodName, parameterTypes, true);
            Method method = (Method)cache.get(md);
            if (method != null) {
                return method;
            }
            method = MethodUtils.getAccessibleMethod(clazz.getMethod(methodName, parameterTypes));
            cache.put(md, method);
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Class<?> clazz = method.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return method;
        }
        method = MethodUtils.getAccessibleMethodFromInterfaceNest(clazz, method.getName(), method.getParameterTypes());
        return method;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class clazz, String methodName, Class[] parameterTypes) {
        Method method = null;
        while (clazz != null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!Modifier.isPublic(interfaces[i].getModifiers())) continue;
                try {
                    method = interfaces[i].getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (method != null || (method = MethodUtils.getAccessibleMethodFromInterfaceNest(interfaces[i], methodName, parameterTypes)) != null) break;
            }
            clazz = clazz.getSuperclass();
        }
        if (method != null) {
            return method;
        }
        return null;
    }

    public static Method getMatchingAccessibleMethod(Class clazz, String methodName, Class[] parameterTypes) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Matching name=" + methodName + " on " + clazz));
        }
        MethodDescriptor md = new MethodDescriptor(clazz, methodName, parameterTypes, false);
        try {
            Method method = (Method)cache.get(md);
            if (method != null) {
                return method;
            }
            method = clazz.getMethod(methodName, parameterTypes);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Found straight match: " + method));
                log.trace((Object)("isPublic:" + Modifier.isPublic(method.getModifiers())));
            }
            try {
                method.setAccessible(true);
            }
            catch (SecurityException se) {
                if (!loggedAccessibleWarning) {
                    boolean vunerableJVM = false;
                    try {
                        String specVersion = System.getProperty("java.specification.version");
                        if (specVersion.charAt(0) == '1' && (specVersion.charAt(0) == '0' || specVersion.charAt(0) == '1' || specVersion.charAt(0) == '2' || specVersion.charAt(0) == '3')) {
                            vunerableJVM = true;
                        }
                    }
                    catch (SecurityException e) {
                        vunerableJVM = true;
                    }
                    if (vunerableJVM) {
                        log.warn((Object)"Current Security Manager restricts use of workarounds for reflection bugs  in pre-1.4 JVMs.");
                    }
                    loggedAccessibleWarning = true;
                }
                log.debug((Object)"Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", (Throwable)se);
            }
            cache.put(md, method);
            return method;
        }
        catch (NoSuchMethodException e) {
            int paramSize = parameterTypes.length;
            Method[] methods = clazz.getMethods();
            int size = methods.length;
            for (int i = 0; i < size; ++i) {
                Class<?>[] methodsParams;
                int methodParamSize;
                if (!methods[i].getName().equals(methodName)) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Found matching name:");
                    log.trace((Object)methods[i]);
                }
                if ((methodParamSize = (methodsParams = methods[i].getParameterTypes()).length) != paramSize) continue;
                boolean match = true;
                for (int n = 0; n < methodParamSize; ++n) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Param=" + parameterTypes[n].getName()));
                        log.trace((Object)("Method=" + methodsParams[n].getName()));
                    }
                    if (MethodUtils.isAssignmentCompatible(methodsParams[n], parameterTypes[n])) continue;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)(methodsParams[n] + " is not assignable from " + parameterTypes[n]));
                    }
                    match = false;
                    break;
                }
                if (!match) continue;
                Method method = MethodUtils.getAccessibleMethod(methods[i]);
                if (method != null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)(method + " accessible version of " + methods[i]));
                    }
                    try {
                        method.setAccessible(true);
                    }
                    catch (SecurityException se) {
                        if (!loggedAccessibleWarning) {
                            log.warn((Object)"Cannot use JVM pre-1.4 access bug workaround die to restrictive security manager.");
                            loggedAccessibleWarning = true;
                        }
                        log.debug((Object)"Cannot setAccessible on method. Therefore cannot use jvm access bug workaround.", (Throwable)se);
                    }
                    cache.put(md, method);
                    return method;
                }
                log.trace((Object)"Couldn't find accessible method.");
            }
            log.trace((Object)"No match found.");
            return null;
        }
    }

    public static final boolean isAssignmentCompatible(Class parameterType, Class parameterization) {
        Class parameterWrapperClazz;
        if (parameterType.isAssignableFrom(parameterization)) {
            return true;
        }
        if (parameterType.isPrimitive() && (parameterWrapperClazz = MethodUtils.getPrimitiveWrapper(parameterType)) != null) {
            return parameterWrapperClazz.equals(parameterization);
        }
        return false;
    }

    public static Class getPrimitiveWrapper(Class primitiveType) {
        if (Boolean.TYPE.equals(primitiveType)) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = MethodUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (Float.TYPE.equals(primitiveType)) {
            return class$java$lang$Float == null ? (class$java$lang$Float = MethodUtils.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (Long.TYPE.equals(primitiveType)) {
            return class$java$lang$Long == null ? (class$java$lang$Long = MethodUtils.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (Integer.TYPE.equals(primitiveType)) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = MethodUtils.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (Short.TYPE.equals(primitiveType)) {
            return class$java$lang$Short == null ? (class$java$lang$Short = MethodUtils.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (Byte.TYPE.equals(primitiveType)) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = MethodUtils.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (Double.TYPE.equals(primitiveType)) {
            return class$java$lang$Double == null ? (class$java$lang$Double = MethodUtils.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (Character.TYPE.equals(primitiveType)) {
            return class$java$lang$Character == null ? (class$java$lang$Character = MethodUtils.class$("java.lang.Character")) : class$java$lang$Character;
        }
        return null;
    }

    public static Class getPrimitiveType(Class wrapperType) {
        if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = MethodUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(wrapperType)) {
            return Boolean.TYPE;
        }
        if ((class$java$lang$Float == null ? (class$java$lang$Float = MethodUtils.class$("java.lang.Float")) : class$java$lang$Float).equals(wrapperType)) {
            return Float.TYPE;
        }
        if ((class$java$lang$Long == null ? (class$java$lang$Long = MethodUtils.class$("java.lang.Long")) : class$java$lang$Long).equals(wrapperType)) {
            return Long.TYPE;
        }
        if ((class$java$lang$Integer == null ? (class$java$lang$Integer = MethodUtils.class$("java.lang.Integer")) : class$java$lang$Integer).equals(wrapperType)) {
            return Integer.TYPE;
        }
        if ((class$java$lang$Short == null ? (class$java$lang$Short = MethodUtils.class$("java.lang.Short")) : class$java$lang$Short).equals(wrapperType)) {
            return Short.TYPE;
        }
        if ((class$java$lang$Byte == null ? (class$java$lang$Byte = MethodUtils.class$("java.lang.Byte")) : class$java$lang$Byte).equals(wrapperType)) {
            return Byte.TYPE;
        }
        if ((class$java$lang$Double == null ? (class$java$lang$Double = MethodUtils.class$("java.lang.Double")) : class$java$lang$Double).equals(wrapperType)) {
            return Double.TYPE;
        }
        if ((class$java$lang$Character == null ? (class$java$lang$Character = MethodUtils.class$("java.lang.Character")) : class$java$lang$Character).equals(wrapperType)) {
            return Character.TYPE;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Not a known primitive wrapper class: " + wrapperType));
        }
        return null;
    }

    public static Class toNonPrimitiveClass(Class clazz) {
        if (clazz.isPrimitive()) {
            Class primitiveClazz = MethodUtils.getPrimitiveWrapper(clazz);
            if (primitiveClazz != null) {
                return primitiveClazz;
            }
            return clazz;
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MethodDescriptor {
        private Class cls;
        private String methodName;
        private Class[] paramTypes;
        private boolean exact;
        private int hashCode;

        public MethodDescriptor(Class cls, String methodName, Class[] paramTypes, boolean exact) {
            if (cls == null) {
                throw new IllegalArgumentException("Class cannot be null");
            }
            if (methodName == null) {
                throw new IllegalArgumentException("Method Name cannot be null");
            }
            if (paramTypes == null) {
                paramTypes = emptyClassArray;
            }
            this.cls = cls;
            this.methodName = methodName;
            this.paramTypes = paramTypes;
            this.exact = exact;
            this.hashCode = methodName.length();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodDescriptor)) {
                return false;
            }
            MethodDescriptor md = (MethodDescriptor)obj;
            return this.exact == md.exact && this.methodName.equals(md.methodName) && this.cls.equals(md.cls) && Arrays.equals(this.paramTypes, md.paramTypes);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

