/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import java.sql.SQLException;
import javax.jdo.JDOException;
import javax.jdo.JDOUnsupportedOptionException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.jdo.JdoDialect;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;

public class DefaultJdoDialect
implements JdoDialect {
    protected Log logger = LogFactory.getLog(this.getClass());
    private PersistenceManagerFactory persistenceManagerFactory;
    private SQLExceptionTranslator jdbcExceptionTranslator;

    public DefaultJdoDialect() {
    }

    public DefaultJdoDialect(PersistenceManagerFactory pmf) {
        this.setPersistenceManagerFactory(pmf);
    }

    public void setPersistenceManagerFactory(PersistenceManagerFactory pmf) {
        this.persistenceManagerFactory = pmf;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.persistenceManagerFactory;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        if (this.jdbcExceptionTranslator == null) {
            this.jdbcExceptionTranslator = PersistenceManagerFactoryUtils.newJdbcExceptionTranslator(this.persistenceManagerFactory);
        }
        return this.jdbcExceptionTranslator;
    }

    public Object beginTransaction(Transaction transaction, TransactionDefinition definition) throws JDOException, SQLException, TransactionException {
        if (definition.getIsolationLevel() != -1) {
            throw new InvalidIsolationLevelException("Standard JDO does not support custom isolation levels - use a special JdoDialect for your JDO implementation");
        }
        transaction.begin();
        return null;
    }

    public void cleanupTransaction(Object transactionData) {
    }

    public ConnectionHandle getJdbcConnection(PersistenceManager pm, boolean readOnly) throws JDOException, SQLException {
        return null;
    }

    public void releaseJdbcConnection(ConnectionHandle conHandle, PersistenceManager pm) throws JDOException, SQLException {
    }

    public void applyQueryTimeout(Query query, int remainingTimeInSeconds) throws JDOException {
        this.logger.info((Object)"DefaultJdoDialect does not support query timeouts: ignoring remaining transaction time");
    }

    public void flush(PersistenceManager pm) throws JDOException {
        throw new JDOUnsupportedOptionException("Cannot eagerly flush persistence manager");
    }

    public DataAccessException translateException(JDOException ex) {
        if (ex.getCause() instanceof SQLException) {
            return this.getJdbcExceptionTranslator().translate("JDO operation", null, (SQLException)ex.getCause());
        }
        return PersistenceManagerFactoryUtils.convertJdoAccessException(ex);
    }
}

