/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink;

import java.io.IOException;
import oracle.toplink.sessions.DatabaseSession;
import oracle.toplink.sessions.SessionLog;
import oracle.toplink.tools.sessionconfiguration.XMLLoader;
import oracle.toplink.tools.sessionmanagement.SessionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.toplink.SessionFactory;
import org.springframework.orm.toplink.sessions.SessionLog904;

public class SessionFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    public static final String DEFAULT_SESSIONS_XML = "sessions.xml";
    public static final String DEFAULT_SESSION_NAME = "Session";
    private String sessionsConfig = "sessions.xml";
    private String sessionName = "Session";
    private ClassLoader sessionClassLoader;
    private boolean redirectLogging = false;
    private String logName = null;
    protected SessionFactory sessionFactory;
    protected final Log logger = LogFactory.getLog(this.getClass());
    static /* synthetic */ Class class$org$springframework$orm$toplink$SessionFactory;

    public void setSessionsConfig(String sessionsConfig) {
        this.sessionsConfig = sessionsConfig;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setSessionClassLoader(ClassLoader sessionClassLoader) {
        this.sessionClassLoader = sessionClassLoader;
    }

    public void setRedirectTopLinkLogging(String category) {
        this.logName = category;
        this.redirectLogging = true;
    }

    public void afterPropertiesSet() throws IllegalArgumentException, IOException {
        DatabaseSession session;
        this.logger.info((Object)"initializing a SessionFactoryBean for SpringTopLink");
        if (this.sessionsConfig == null) {
            this.sessionsConfig = DEFAULT_SESSIONS_XML;
        }
        XMLLoader loader = new XMLLoader(this.sessionsConfig);
        SessionManager sm = SessionManager.getManager();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.sessionClassLoader != null) {
            classLoader = this.sessionClassLoader;
        }
        if (!(session = (DatabaseSession)sm.getSession(loader, this.sessionName, classLoader, false, false)).isServerSession()) {
            this.logger.fatal((Object)"The current sessions.xml file is configured to use a single-threaded DatabaseSession instead of a ServerSession");
            this.logger.fatal((Object)"The TopLink SessionFactory is designed to be used in a multi-threaded environment");
            throw new IllegalArgumentException("sessions.xml should not be configured to use a single-threaded DatabaseSession");
        }
        if (this.redirectLogging) {
            session.setSessionLog((SessionLog)new SessionLog904());
            session.logMessages();
        }
        if (!session.isConnected()) {
            session.login();
        }
        this.sessionFactory = new SessionFactory(session);
    }

    public Object getObject() {
        return this.sessionFactory;
    }

    public Class getObjectType() {
        return this.sessionFactory != null ? this.sessionFactory.getClass() : (class$org$springframework$orm$toplink$SessionFactory == null ? (class$org$springframework$orm$toplink$SessionFactory = SessionFactoryBean.class$("org.springframework.orm.toplink.SessionFactory")) : class$org$springframework$orm$toplink$SessionFactory);
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.sessionFactory.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

