/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink;

import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.sessions.Session;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.orm.toplink.SessionFactoryUtils;
import org.springframework.orm.toplink.TopLinkAccessor;
import org.springframework.orm.toplink.sessions.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TopLinkInterceptor
extends TopLinkAccessor
implements MethodInterceptor {
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        boolean existingTransaction = false;
        Session s = SessionFactoryUtils.getSession(this.getSessionFactory(), true, true);
        if (TransactionSynchronizationManager.hasResource(this.getSessionFactory())) {
            this.logger.debug((Object)"Found thread-bound session for Toplink interceptor");
            existingTransaction = true;
        } else {
            this.logger.debug((Object)"Using new session for Toplink interceptor");
            TransactionSynchronizationManager.bindResource(this.getSessionFactory(), new SessionHolder(s));
        }
        try {
            Object retVal;
            Object object = retVal = methodInvocation.proceed();
            return object;
        }
        catch (TopLinkException ex) {
            throw this.convertToplinkAccessException(ex);
        }
        finally {
            if (existingTransaction) {
                this.logger.debug((Object)"Not closing pre-bound Toplink session after interceptor");
            } else {
                TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
                SessionFactoryUtils.closeSessionIfNecessary(s, this.getSessionFactory());
            }
        }
    }
}

