/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.toplink;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.sessions.ObjectCopyingPolicy;
import oracle.toplink.sessions.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.toplink.SessionFactory;
import org.springframework.orm.toplink.SessionFactoryUtils;
import org.springframework.orm.toplink.TopLinkAccessor;
import org.springframework.orm.toplink.TopLinkCallback;

public class TopLinkTemplate
extends TopLinkAccessor {
    private boolean allowCreate = true;

    public TopLinkTemplate() {
    }

    public TopLinkTemplate(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
        this.afterPropertiesSet();
    }

    public TopLinkTemplate(SessionFactory sessionFactory, boolean allowCreate) {
        this.setSessionFactory(sessionFactory);
        this.setAllowCreate(allowCreate);
        this.afterPropertiesSet();
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public Object execute(TopLinkCallback action) throws DataAccessException {
        Session session = SessionFactoryUtils.getSession(this.getSessionFactory(), this.allowCreate);
        try {
            Object result;
            Object object = result = action.doInToplink(session);
            return object;
        }
        catch (TopLinkException ex) {
            throw this.convertToplinkAccessException(ex);
        }
        catch (SQLException ex) {
            throw this.convertJdbcAccessException(ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            SessionFactoryUtils.closeSessionIfNecessary(session, this.getSessionFactory());
        }
    }

    public List executeFind(TopLinkCallback action) throws DataAccessException {
        return (List)this.execute(action);
    }

    public Object mergeClone(final Object entity) throws DataAccessException {
        return this.execute(new TopLinkCallback(){

            public Object doInToplink(Session session) throws TopLinkException, SQLException {
                session.readObject(entity);
                return session.getActiveUnitOfWork().mergeClone(entity);
            }
        });
    }

    public Object deepMergeClone(final Object entity) throws DataAccessException {
        return this.execute(new TopLinkCallback(){

            public Object doInToplink(Session session) throws TopLinkException, SQLException {
                session.readObject(entity);
                return session.getActiveUnitOfWork().deepMergeClone(entity);
            }
        });
    }

    public Object shallowMergeClone(final Object entity) throws DataAccessException {
        return this.execute(new TopLinkCallback(){

            public Object doInToplink(Session session) throws TopLinkException, SQLException {
                session.readObject(entity);
                return session.getActiveUnitOfWork().shallowMergeClone(entity);
            }
        });
    }

    public Object mergeCloneWithReferences(final Object entity) throws DataAccessException {
        return this.execute(new TopLinkCallback(){

            public Object doInToplink(Session session) throws TopLinkException, SQLException {
                session.readObject(entity);
                return session.getActiveUnitOfWork().mergeCloneWithReferences(entity);
            }
        });
    }

    public void delete(final Object entity) throws DataAccessException {
        this.execute(new TopLinkCallback(){

            public Object doInToplink(Session session) throws TopLinkException, SQLException {
                return session.getActiveUnitOfWork().deleteObject(entity);
            }
        });
    }

    public void deleteAll(final Collection entities) throws DataAccessException {
        this.execute(new TopLinkCallback(){

            public Object doInToplink(Session session) throws TopLinkException, SQLException {
                session.getActiveUnitOfWork().deleteAllObjects(entities);
                return null;
            }
        });
    }

    public List findByNamedQuery(final Class entityClass, final String queryName, final Vector params, final boolean readOnly) throws DataAccessException {
        return this.executeFind(new TopLinkCallback(){

            public Object doInToplink(Session session) throws TopLinkException, SQLException {
                Session s = readOnly ? session : session.getActiveUnitOfWork();
                return s.executeQuery(queryName, entityClass, params);
            }
        });
    }

    public List findByNamedQuery(Class entityClass, String queryName, Vector params) throws DataAccessException {
        return this.findByNamedQuery(entityClass, queryName, params, false);
    }

    public Object refresh(final Object object, final boolean readOnly) throws DataAccessException {
        return this.execute(new TopLinkCallback(){

            public Object doInToplink(Session session) throws TopLinkException, SQLException {
                Session s = readOnly ? session : session.getActiveUnitOfWork();
                return s.refreshObject(object);
            }
        });
    }

    public Object load(final Class entityClass, final Vector keys, final boolean readOnly) throws DataAccessException {
        return this.execute(new TopLinkCallback(){

            public Object doInToplink(Session session) throws TopLinkException, SQLException {
                Session s = readOnly ? session : session.getActiveUnitOfWork();
                ReadObjectQuery readObjectQuery = new ReadObjectQuery(entityClass);
                readObjectQuery.setSelectionKey(keys);
                return s.executeQuery((DatabaseQuery)readObjectQuery);
            }
        });
    }

    public Object load(Class entityClass, Object id, boolean readOnly) throws DataAccessException {
        Vector<Object> v = new Vector<Object>();
        v.add(id);
        return this.load(entityClass, v, readOnly);
    }

    public Object loadAndCopy(final Class entityClass, final Vector keys) throws DataAccessException {
        return this.execute(new TopLinkCallback(){

            public Object doInToplink(Session session) throws TopLinkException, SQLException {
                ReadObjectQuery readObjectQuery = new ReadObjectQuery(entityClass);
                readObjectQuery.setSelectionKey(keys);
                Object object = session.executeQuery((DatabaseQuery)readObjectQuery);
                ObjectCopyingPolicy copyPolicy = new ObjectCopyingPolicy();
                copyPolicy.cascadeAllParts();
                copyPolicy.setShouldResetPrimaryKey(false);
                return session.copyObject(object, copyPolicy);
            }
        });
    }

    public Object loadAndCopy(Class entityClass, Object id) throws DataAccessException {
        Vector<Object> v = new Vector<Object>();
        v.add(id);
        return this.loadAndCopy(entityClass, v);
    }

    public Object registerObject(final Object object) {
        return this.execute(new TopLinkCallback(){

            public Object doInToplink(Session session) throws TopLinkException, SQLException {
                return session.getActiveUnitOfWork().registerObject(object);
            }
        });
    }
}

