/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import org.apache.commons.validator.util.Flags;

public class CreditCardValidator {
    private static final String AMEX_PREFIX = "34,37,";
    private static final String VISA_PREFIX = "4";
    private static final String MASTERCARD_PREFIX = "51,52,53,54,55,";
    private static final String DISCOVER_PREFIX = "6011";
    public static final int AMEX = 1;
    public static final int VISA = 2;
    public static final int MASTERCARD = 4;
    public static final int DISCOVER = 8;
    private static final Flags defaultOptions = new Flags(15L);
    private Flags options = null;

    public CreditCardValidator() {
        this.options = defaultOptions;
    }

    public CreditCardValidator(int options) {
        this.options = new Flags(options);
    }

    public boolean isValid(String card) {
        if (card == null || card.length() < 13 || card.length() > 19) {
            return false;
        }
        if (!this.luhnCheck(card)) {
            return false;
        }
        if (this.isVisa(card)) {
            return this.options.isOn(2L);
        }
        if (this.isAmex(card)) {
            return this.options.isOn(1L);
        }
        if (this.isMastercard(card)) {
            return this.options.isOn(4L);
        }
        if (this.isDiscover(card)) {
            return this.options.isOn(8L);
        }
        return false;
    }

    protected boolean luhnCheck(String cardNumber) {
        int digits = cardNumber.length();
        int oddOrEven = digits & 1;
        long sum = 0L;
        for (int count = 0; count < digits; ++count) {
            int digit = 0;
            try {
                digit = Integer.parseInt(String.valueOf(cardNumber.charAt(count)));
            }
            catch (NumberFormatException e) {
                return false;
            }
            if ((count & 1 ^ oddOrEven) == 0 && (digit *= 2) > 9) {
                digit -= 9;
            }
            sum += (long)digit;
        }
        if (sum == 0L) {
            return false;
        }
        return sum % 10L == 0L;
    }

    protected boolean isValidPrefix(String card) {
        if (card.length() < 13) {
            return false;
        }
        return this.isVisa(card) || this.isAmex(card) || this.isMastercard(card) || this.isDiscover(card);
    }

    private boolean isAmex(String card) {
        String prefix2 = card.substring(0, 2) + ",";
        return AMEX_PREFIX.indexOf(prefix2) != -1 && card.length() == 15;
    }

    private boolean isVisa(String card) {
        return card.substring(0, 1).equals(VISA_PREFIX) && (card.length() == 13 || card.length() == 16);
    }

    private boolean isMastercard(String card) {
        String prefix2 = card.substring(0, 2) + ",";
        return MASTERCARD_PREFIX.indexOf(prefix2) != -1 && card.length() == 16;
    }

    private boolean isDiscover(String card) {
        return card.substring(0, 4).equals(DISCOVER_PREFIX) && card.length() == 16;
    }
}

