/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.apache.commons.validator.util.ValidatorUtils;

public class Validator
implements Serializable {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$commons$validator$Validator == null ? (class$org$apache$commons$validator$Validator = Validator.class$("org.apache.commons.validator.Validator")) : class$org$apache$commons$validator$Validator));
    public static final String BEAN_PARAM = "java.lang.Object";
    public static final String BEAN_KEY = "java.lang.Object";
    public static final String VALIDATOR_ACTION_PARAM = "org.apache.commons.validator.ValidatorAction";
    public static final String VALIDATOR_ACTION_KEY = "org.apache.commons.validator.ValidatorAction";
    public static final String FIELD_PARAM = "org.apache.commons.validator.Field";
    public static final String FIELD_KEY = "org.apache.commons.validator.Field";
    public static final String VALIDATOR_PARAM = "org.apache.commons.validator.Validator";
    public static final String VALIDATOR_KEY = "org.apache.commons.validator.Validator";
    public static final String LOCALE_PARAM = "java.util.Locale";
    public static final String LOCALE_KEY = "java.util.Locale";
    protected ValidatorResources resources = null;
    protected String formName = null;
    protected Map parameters = new HashMap();
    protected HashMap hResources = (HashMap)this.parameters;
    protected int page = 0;
    protected ClassLoader classLoader = null;
    protected boolean useContextClassLoader = false;
    protected boolean onlyReturnErrors = false;
    static /* synthetic */ Class class$org$apache$commons$validator$Validator;

    public Validator(ValidatorResources resources) {
        this(resources, null);
    }

    public Validator(ValidatorResources resources, String formName) {
        if (resources == null) {
            throw new IllegalArgumentException("Resources cannot be null.");
        }
        this.resources = resources;
        this.formName = formName;
    }

    public void addResource(String parameterClassName, Object parameterValue) {
        this.setParameter(parameterClassName, parameterValue);
    }

    public void setParameter(String parameterClassName, Object parameterValue) {
        this.parameters.put(parameterClassName, parameterValue);
    }

    public Object getResource(String parameterClassName) {
        return this.getParameterValue(parameterClassName);
    }

    public Object getParameterValue(String parameterClassName) {
        return this.parameters.get(parameterClassName);
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void clear() {
        this.formName = null;
        this.parameters = new HashMap();
        this.hResources = (HashMap)this.parameters;
        this.page = 0;
    }

    public boolean getUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setUseContextClassLoader(boolean use) {
        this.useContextClassLoader = use;
    }

    public ClassLoader getClassLoader() {
        ClassLoader contextLoader;
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.useContextClassLoader && (contextLoader = Thread.currentThread().getContextClassLoader()) != null) {
            return contextLoader;
        }
        return this.getClass().getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private boolean validateFieldForRule(Field field, ValidatorAction va, ValidatorResults results, Map actions, int pos) throws ValidatorException {
        ValidatorResult result = results.getValidatorResult(field.getKey());
        if (result != null && result.containsAction(va.getName())) {
            return result.isValid(va.getName());
        }
        if (!this.runDependentValidators(field, va, results, actions, pos)) {
            return false;
        }
        return this.executeValidationMethod(field, va, results, pos);
    }

    private boolean runDependentValidators(Field field, ValidatorAction va, ValidatorResults results, Map actions, int pos) throws ValidatorException {
        if (va.getDepends() == null) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(va.getDepends(), ",");
        while (st.hasMoreTokens()) {
            String depend = st.nextToken().trim();
            ValidatorAction action = (ValidatorAction)actions.get(depend);
            if (action == null) {
                log.error((Object)("No ValidatorAction named " + depend + " found for field " + field.getProperty()));
                return false;
            }
            if (this.validateFieldForRule(field, action, results, actions, pos)) continue;
            return false;
        }
        return true;
    }

    private boolean executeValidationMethod(Field field, ValidatorAction va, ValidatorResults results, int pos) throws ValidatorException {
        try {
            Object result;
            boolean valid;
            this.setParameter("org.apache.commons.validator.ValidatorAction", va);
            this.setParameter("org.apache.commons.validator.Field", field);
            Class<?> validationClass = this.getClassLoader().loadClass(va.getClassname());
            List params = va.getMethodParamsList();
            Class[] paramClass = this.getParameterClasses(params);
            Object[] paramValue = this.getParameterValues(params);
            Method validationMethod = validationClass.getMethod(va.getMethod(), paramClass);
            if (!Modifier.isStatic(validationMethod.getModifiers())) {
                this.storeClassInAction(validationClass, va);
            }
            if (field.isIndexed()) {
                this.handleIndexedField(field, pos, params, paramValue);
            }
            if (!(valid = this.isValid(result = validationMethod.invoke(va.getClassnameInstance(), paramValue))) || valid && !this.onlyReturnErrors) {
                results.add(field, va.getName(), valid, result);
            }
            if (!valid) {
                return false;
            }
        }
        catch (Exception e) {
            log.error((Object)("reflection: " + e.getMessage()), (Throwable)e);
            results.add(field, va.getName(), false);
            if (e instanceof ValidatorException) {
                throw (ValidatorException)e;
            }
            return false;
        }
        return true;
    }

    private Class[] getParameterClasses(List paramNames) throws ClassNotFoundException {
        Class[] paramClass = new Class[paramNames.size()];
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramClassName = (String)paramNames.get(i);
            paramClass[i] = this.getClassLoader().loadClass(paramClassName);
        }
        return paramClass;
    }

    private Object[] getParameterValues(List paramNames) {
        Object[] paramValue = new Object[paramNames.size()];
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramClassName = (String)paramNames.get(i);
            paramValue[i] = this.getParameterValue(paramClassName);
        }
        return paramValue;
    }

    private void storeClassInAction(Class validationClass, ValidatorAction va) {
        try {
            if (va.getClassnameInstance() == null) {
                va.setClassnameInstance(validationClass.newInstance());
            }
        }
        catch (Exception ex) {
            log.error((Object)("Couldn't load instance of class " + va.getClassname() + ".  " + ex.getMessage()));
        }
    }

    private void handleIndexedField(Field field, int pos, List params, Object[] paramValue) throws ValidatorException {
        int beanIndexPos = params.indexOf("java.lang.Object");
        int fieldIndexPos = params.indexOf("org.apache.commons.validator.Field");
        Object[] indexedList = this.getIndexedProperty(field);
        paramValue[beanIndexPos] = indexedList[pos];
        Field indexedField = (Field)field.clone();
        indexedField.setKey(ValidatorUtils.replace(indexedField.getKey(), "[]", "[" + pos + "]"));
        paramValue[fieldIndexPos] = indexedField;
    }

    private void validateField(Field field, ValidatorResults allResults) throws ValidatorException {
        int numberOfFieldsToValidate = field.isIndexed() ? this.getIndexedProperty(field).length : 1;
        Map actions = this.resources.getValidatorActions();
        for (int fieldNumber = 0; fieldNumber < numberOfFieldsToValidate; ++fieldNumber) {
            StringTokenizer st = new StringTokenizer(field.getDepends(), ",");
            while (st.hasMoreTokens()) {
                String depend = st.nextToken().trim();
                ValidatorAction action = (ValidatorAction)actions.get(depend);
                if (action == null) {
                    log.error((Object)("No ValidatorAction named " + depend + " found for field " + field.getProperty()));
                    return;
                }
                ValidatorResults results = new ValidatorResults();
                boolean good = this.validateFieldForRule(field, action, results, actions, fieldNumber);
                allResults.merge(results);
                if (good) continue;
                return;
            }
        }
    }

    private Object[] getIndexedProperty(Field field) throws ValidatorException {
        Object indexedProperty = null;
        try {
            indexedProperty = PropertyUtils.getProperty((Object)this.getParameterValue("java.lang.Object"), (String)field.getIndexedListProperty());
        }
        catch (IllegalAccessException e) {
            throw new ValidatorException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ValidatorException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new ValidatorException(e.getMessage());
        }
        if (indexedProperty instanceof Collection) {
            return ((Collection)indexedProperty).toArray();
        }
        if (indexedProperty.getClass().isArray()) {
            return (Object[])indexedProperty;
        }
        throw new ValidatorException("Non-collection, non-array indexed property " + field.getKey() + " found");
    }

    public ValidatorResults validate() throws ValidatorException {
        ValidatorResults results = new ValidatorResults();
        Locale locale = (Locale)this.getParameterValue("java.util.Locale");
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.setParameter("org.apache.commons.validator.Validator", this);
        Form form = this.resources.getForm(locale, this.formName);
        if (form != null) {
            Iterator fields = form.getFields().iterator();
            while (fields.hasNext()) {
                Field field = (Field)fields.next();
                if (field.getPage() > this.page || field.getDepends() == null) continue;
                this.validateField(field, results);
            }
        }
        return results;
    }

    private boolean isValid(Object result) {
        if (result instanceof Boolean) {
            Boolean valid = (Boolean)result;
            return valid;
        }
        return result != null;
    }

    public boolean getOnlyReturnErrors() {
        return this.onlyReturnErrors;
    }

    public void setOnlyReturnErrors(boolean onlyReturnErrors) {
        this.onlyReturnErrors = onlyReturnErrors;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

