/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidatorAction
implements Serializable {
    private String name = null;
    private String classname = null;
    private String method = null;
    private String methodParams = "java.lang.Object,org.apache.commons.validator.ValidatorAction,org.apache.commons.validator.Field";
    private String depends = null;
    private String msg = null;
    private String jsFunctionName = null;
    private String jsFunction = null;
    private String javascript = null;
    private Object instance = null;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$validator$ValidatorAction == null ? (class$org$apache$commons$validator$ValidatorAction = ValidatorAction.class$("org.apache.commons.validator.ValidatorAction")) : class$org$apache$commons$validator$ValidatorAction));
    private List dependencyList = Collections.synchronizedList(new ArrayList());
    private List methodParameterList = new ArrayList();
    static /* synthetic */ Class class$org$apache$commons$validator$ValidatorAction;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethodParams() {
        return this.methodParams;
    }

    public void setMethodParams(String methodParams) {
        this.methodParams = methodParams;
        this.methodParameterList.clear();
        StringTokenizer st = new StringTokenizer(methodParams, ",");
        while (st.hasMoreTokens()) {
            String value = st.nextToken().trim();
            if (value == null || value.length() <= 0) continue;
            this.methodParameterList.add(value);
        }
    }

    public List getMethodParamsList() {
        return Collections.unmodifiableList(this.methodParameterList);
    }

    public String getDepends() {
        return this.depends;
    }

    public void setDepends(String depends) {
        this.depends = depends;
        this.dependencyList.clear();
        StringTokenizer st = new StringTokenizer(depends, ",");
        while (st.hasMoreTokens()) {
            String depend = st.nextToken().trim();
            if (depend == null || depend.length() <= 0) continue;
            this.dependencyList.add(depend);
        }
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getJsFunctionName() {
        return this.jsFunctionName;
    }

    public void setJsFunctionName(String jsFunctionName) {
        this.jsFunctionName = jsFunctionName;
    }

    public void setJsFunction(String jsFunction) {
        if (this.javascript != null) {
            throw new IllegalStateException("Cannot call setJsFunction() after calling setJavascript()");
        }
        this.jsFunction = jsFunction;
    }

    public String getJavascript() {
        return this.javascript;
    }

    public void setJavascript(String javascript) {
        if (this.jsFunction != null) {
            throw new IllegalStateException("Cannot call setJavascript() after calling setJsFunction()");
        }
        this.javascript = javascript;
    }

    public Object getClassnameInstance() {
        return this.instance;
    }

    public void setClassnameInstance(Object instance) {
        this.instance = instance;
    }

    protected void init() {
        this.loadJavascriptFunction();
    }

    protected synchronized void loadJavascriptFunction() {
        if (this.javascriptAlreadyLoaded()) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"  Loading function begun");
        }
        if (this.jsFunction == null) {
            this.jsFunction = this.generateJsFunction();
        }
        String javascriptFileName = this.formatJavascriptFileName();
        if (log.isTraceEnabled()) {
            log.trace((Object)("  Loading js function '" + javascriptFileName + "'"));
        }
        this.javascript = this.readJavascriptFile(javascriptFileName);
        if (log.isTraceEnabled()) {
            log.trace((Object)"  Loading javascript function completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String readJavascriptFile(String javascriptFileName) {
        StringBuffer function;
        block13: {
            InputStream is;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            if ((is = classLoader.getResourceAsStream(javascriptFileName)) == null) {
                is = this.getClass().getResourceAsStream(javascriptFileName);
            }
            if (is == null) {
                log.debug((Object)("  Unable to read javascript name " + javascriptFileName));
                return null;
            }
            function = new StringBuffer();
            int bufferSize = is.available();
            while (bufferSize > 0) {
                byte[] buffer = new byte[bufferSize];
                int bytesRead = is.read(buffer, 0, bufferSize);
                if (bytesRead > 0) {
                    String functionPart = new String(buffer, 0, bytesRead);
                    function.append(functionPart);
                }
                bufferSize = is.available();
            }
            Object var10_11 = null;
            try {
                is.close();
            }
            catch (IOException e2) {
                log.error((Object)"readJavascriptFile()", (Throwable)e2);
            }
            break block13;
            {
                catch (IOException e) {
                    log.error((Object)"readJavascriptFile()", (Throwable)e);
                    Object var10_12 = null;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        log.error((Object)"readJavascriptFile()", (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    is.close();
                }
                catch (IOException e2) {
                    log.error((Object)"readJavascriptFile()", (Throwable)e2);
                }
                throw throwable;
            }
        }
        String strFunction = function.toString();
        return strFunction.equals("") ? null : strFunction;
    }

    private String formatJavascriptFileName() {
        String name = this.jsFunction.substring(1);
        if (!this.jsFunction.startsWith("/")) {
            name = this.jsFunction.replace('.', '/') + ".js";
        }
        return name;
    }

    private boolean javascriptAlreadyLoaded() {
        return this.javascript != null;
    }

    private String generateJsFunction() {
        StringBuffer jsName = new StringBuffer("org.apache.commons.validator.javascript");
        jsName.append(".validate");
        jsName.append(this.name.substring(0, 1).toUpperCase());
        jsName.append(this.name.substring(1, this.name.length()));
        return jsName.toString();
    }

    public synchronized void process(Map globalConstants) {
    }

    public boolean isDependency(String validatorName) {
        return this.dependencyList.contains(validatorName);
    }

    public Collection getDependencies() {
        return this.getDependencyList();
    }

    public List getDependencyList() {
        return Collections.unmodifiableList(this.dependencyList);
    }

    public String toString() {
        StringBuffer results = new StringBuffer("ValidatorAction: ");
        results.append(this.name);
        results.append("\n");
        return results.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

