/*
 * Created on 2005. 5. 10.
 */
package net.javajigi.security.dao;

import java.util.List;

import junit.framework.TestCase;
import net.javajigi.security.model.User;

import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * @author Administrator
 */
public class UserDAOTest extends TestCase {
    /**
     * Logger for this class
     */
    private static final Logger logger = Logger.getLogger(UserDAOTest.class);

    private UserDAO userDAO = null;

    private ApplicationContext ctx = null;

    private String userId = null;

    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        String[] paths = { "/WEB-INF/applicationContext.xml" };
        ctx = new ClassPathXmlApplicationContext(paths);
        userDAO = (UserDAO) ctx.getBean("userDAO");

        userId = "javajigi";
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
        userDAO = null;
    }

    public void testAddAndFindUser() {
        User user = addUser();
        User dbUser = userDAO.findUser(userId);

        assertEquals(user, dbUser);

        userDAO.removeUser(userId);
        if (logger.isDebugEnabled()) {
            logger.debug("Removed " + userId + " User");
        }
    }

    /**
     * @return
     */
    private User addUser() {
        User user = new User();
        user.setUserId(userId);
        user.setPassword("password");
        user.setName("缺");
        user.setEmail("javajigi@gmail.com");

        userDAO.addUser(user);

        if (logger.isDebugEnabled()) {
            logger.debug("Added " + userId + " User");
        }
        return user;
    }

    public void testUpdateUser() {
        User user = addUser();

        user.setPassword("javapass");
        user.setName("ڿ");
        user.setEmail("yeeun@gmail.com");

        userDAO.updateUser(user);

        User dbUser = userDAO.findUser(userId);

        assertEquals(user, dbUser);

        userDAO.removeUser(userId);
    }

    public void testRemoveUser() {
        userDAO.removeUser(userId);
    }

    public void testFindUserList() {
        addUser();
        List userList = userDAO.findUserList();
        assertEquals(userList.size(), 1);
        userDAO.removeUser(userId);
    }
}
