/*
 * Created on 2005. 5. 3.
 */
package net.javajigi.security.service;

import java.util.List;

import net.javajigi.security.model.User;

import org.apache.log4j.Logger;

/**
 * @author 缺
 */
public class UserManagerTest extends SecurityBaseTest {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = Logger
			.getLogger(UserManagerTest.class);
	
	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	protected void setUp() throws Exception {
		super.setUp();
	}
	
	/**
	 *  
	 */
	protected void removeUser() {
		String userId = "javajigi";
		
		if( logger.isDebugEnabled() ) {
			logger.debug("removing User : " + userId);
		}
		getUserManager().removeUser(userId);
	}	
	
	public void testAddAndFindUser() {
		String userId = "javajigi";
		String password = "password";
		
		User user = addUser(userId, password);
		
		assertTrue(user.getUserId() != null);

		if( logger.isDebugEnabled() ) {
			logger.debug("finding User : " + userId);
		}
		User dbUser = getUserManager().findUser(userId);

		assertEquals(dbUser, user);
		
		removeUser();
	}
	
	public void testUpdateUser() {
		String userId = "javajigi";
		String password = "password";
		
		User user = addUser(userId, password);

		user.setPassword("javapass");
		user.setName("ڿ");
		user.setEmail("yeeun@gmail.com");

		if( logger.isDebugEnabled() ) {
			logger.debug("updating User!!");
		}
		getUserManager().updateUser(user);

		if ( logger.isDebugEnabled() ) {
			logger.debug("finding User!!");
		}
		User dbUser = getUserManager().findUser("javajigi");

		assertEquals(dbUser, user);
		
		removeUser();		
	}

	public void testFindUserList() {
		String userId = "javajigi";
		String password = "password";
		
		User user = addUser(userId, password);
		
		if( logger.isDebugEnabled() ) {
			logger.debug("finding User List!!");
		}
		List userList = getUserManager().findUserList();
		
		assertEquals(userList.size(), 1);
		
		removeUser();
	}
}