/*
 * Created on 2005. 5. 27.
 */
package net.javajigi.security.web.action;

import net.javajigi.security.dao.UserDAO;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import servletunit.struts.MockStrutsTestCase;

/**
 * @author Administrator
 */
public class UserActionFormValidationTest extends MockStrutsTestCase {
	private UserDAO userDAO = null;

	private ApplicationContext ctx = null;

    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
		super.setUp();
		
		String[] paths = { "/WEB-INF/applicationContext.xml" };
		ctx = new ClassPathXmlApplicationContext(paths);
		userDAO = (UserDAO) ctx.getBean("userDAO");
    }
    
    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }
    
    public void testRequiredUserId() throws Exception {
	    if( logger.isDebugEnabled() ) {
	        logger.debug("Starting addUser method!!");
	    }
	    
		setRequestPathInfo("/user");
		addRequestParameter("method", "add");
		addRequestParameter("user.password", "password");
		addRequestParameter("user.email", "javajigi@hotmail.com");
		addRequestParameter("user.name", "缺");

		if( logger.isDebugEnabled() ) {
		    logger.debug("Adding new User!!");
		}
		
		actionPerform();

		verifyForward("add");
		verifyActionErrors(new String[] { "errors.required" });
		
		if( logger.isDebugEnabled() ) {
		    logger.debug("End addUser method!!");
		}
    }
}
