/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.jmassmailer.mail;

import java.io.IOException;
import java.util.Properties;
import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.internet.AddressException;
import net.kldp.jmassmailer.Configurator;
import net.kldp.jmassmailer.data.PeopleList;
import net.kldp.jmassmailer.data.PeopleListObserver;
import net.kldp.jmassmailer.mail.AddressObserver;
import net.kldp.jmassmailer.mail.SessionHandler;
import net.kldp.jmassmailer.mail.SessionHandlerControllerInterface;
import net.kldp.jmassmailer.mail.SmtpHostObserver;
import net.kldp.jmassmailer.ui.MailerView;

public class SessionHandlerController
implements SessionHandlerControllerInterface,
SmtpHostObserver,
PeopleListObserver,
AddressObserver {
    private SessionHandler model;
    private MailerView view;
    private Configurator conf;
    private boolean isSmtpHostSet;
    private boolean isAddressSet;

    public SessionHandlerController(SessionHandler model, Configurator conf) {
        this.model = model;
        this.conf = conf;
        this.view = new MailerView(this, model, conf);
        this.view.createView();
        this.view.createMenu();
        conf.setSessionHandler(model);
        try {
            conf.getSessionConfigure(model);
            this.isSmtpHostSet = true;
            this.isAddressSet = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setPeopleList(PeopleList people) {
        this.model.setPeopleList(people);
    }

    public void setMessage(String subject, String text) {
        this.model.setMessage(subject, text);
    }

    public void setReplyTo(String replyto) throws AddressException {
        this.model.setReplyTo(replyto);
    }

    public void setFrom(String email) throws AddressException {
        this.model.setFrom(email);
    }

    public void setFrom(String email, String name) throws AddressException {
        this.model.setFrom(email, name);
    }

    public void sendMessages() throws NoSuchProviderException, AuthenticationFailedException, MessagingException {
        this.model.transfer();
    }

    public void updateSessionConfiguration(String username, String password, Properties props) throws MessagingException {
        this.isSmtpHostSet = true;
        this.model.createSession(username, password, props);
    }

    public void updateSessionConfiguration(Properties props) {
        this.isSmtpHostSet = true;
        this.model.createSession(props);
    }

    public void updatePeopleList(PeopleList people) throws MessagingException {
        this.model.setPeopleList(people);
    }

    public void updateAddress(String from, String name, String replyto) throws AddressException {
        this.isAddressSet = true;
        this.model.setFrom(from, name);
        this.model.setReplyTo(replyto);
    }

    public boolean isAddressSet() {
        return this.isAddressSet;
    }

    public boolean isSmtpHostSet() {
        return this.isSmtpHostSet;
    }

    public void finalizer() {
        this.conf.write();
    }
}

