/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.struts.util.GenericConnection;

public class GenericDataSource
implements DataSource {
    private static final String SQLEXCEPTION_GETCONNECTION = "getConnection(String username, String password)  Method not supported. Use getConnection() instead.";
    protected boolean closed = false;
    protected LinkedList connections = new LinkedList();
    protected Driver driver = null;
    protected int loginTimeout = 0;
    protected PrintWriter logWriter = null;
    protected int activeCount = 0;
    protected boolean autoCommit = true;
    protected int debug = 0;
    protected String description = null;
    protected String driverClass = null;
    protected int maxCount = 2;
    protected int minCount = 1;
    protected String password = null;
    protected String pingCommand = null;
    protected String pingQuery = null;
    protected Properties properties = new Properties();
    protected boolean readOnly = false;
    protected String url = null;
    protected int useCount = 0;
    protected String user = null;

    public void addProperty(String name, String value) {
        ((Hashtable)this.properties).put(name, value);
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public void setMinCount(int minCount) {
        this.minCount = minCount;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.addProperty("password", this.password);
    }

    public String getPingCommand() {
        return this.pingCommand;
    }

    public void setPingCommand(String pingCommand) {
        this.pingCommand = pingCommand;
    }

    public String getPingQuery() {
        return this.pingQuery;
    }

    public void setPingQuery(String pingQuery) {
        this.pingQuery = pingQuery;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getUseCount() {
        return this.useCount;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
        this.addProperty("user", this.user);
    }

    public Connection getConnection() throws SQLException {
        int seconds = 0;
        if (this.debug >= 2) {
            this.log("  getConnection()");
        }
        if (this.closed) {
            throw new SQLException("getConnection:  Data source is closed");
        }
        if (this.driver == null) {
            this.open();
        }
        while (true) {
            Connection connection;
            if (this.debug >= 3) {
                this.log("   Check for timeout, activeCount=" + this.activeCount + ", useCount=" + this.useCount);
            }
            if (this.loginTimeout > 0 && seconds >= this.loginTimeout) break;
            LinkedList linkedList = this.connections;
            synchronized (linkedList) {
                if (!this.connections.isEmpty()) {
                    connection = (GenericConnection)this.connections.removeFirst();
                    if (this.debug >= 3) {
                        this.log("   Found available connection");
                    }
                    ((GenericConnection)connection).setClosed(false);
                    try {
                        this.ping(connection);
                    }
                    catch (SQLException e) {
                        if (this.debug >= 3) {
                            this.log("   Connection stale, releasing");
                        }
                        try {
                            ((GenericConnection)connection).getConnection().close();
                        }
                        catch (SQLException f) {
                            // empty catch block
                        }
                        --this.activeCount;
                        continue;
                    }
                    ++this.useCount;
                    if (this.debug >= 3) {
                        this.log("   Return allocated connection, activeCount=" + this.activeCount + ", useCount=" + this.useCount);
                    }
                    Connection e = connection;
                    return e;
                }
            }
            if (this.activeCount < this.maxCount && (connection = this.createConnection()) != null) {
                this.ping(connection);
                ++this.useCount;
                if (this.debug >= 3) {
                    this.log("   Return new connection, activeCount=" + this.activeCount + ", useCount=" + this.useCount);
                }
                return connection;
            }
            if (this.debug >= 3) {
                this.log("   Sleep until next test");
            }
            try {
                Thread.sleep(1000L);
                ++seconds;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.debug >= 3) {
            this.log("   Timeout awaiting connection");
        }
        throw new SQLException("getConnection: Timeout awaiting connection");
    }

    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException(SQLEXCEPTION_GETCONNECTION);
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.loginTimeout = loginTimeout;
    }

    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.logWriter = logWriter;
    }

    public void close() throws SQLException {
        if (this.closed) {
            throw new SQLException("close:  Data Source already closed");
        }
        if (this.debug >= 1) {
            this.log(" close()");
        }
        while (this.activeCount > 0) {
            GenericConnection conn = (GenericConnection)this.getConnection();
            conn.getConnection().close();
            --this.activeCount;
        }
        this.closed = true;
        this.driver = null;
    }

    public void open() throws SQLException {
        if (this.driver != null) {
            return;
        }
        if (this.debug >= 1) {
            this.log(" open()");
        }
        try {
            Class<?> clazz = Class.forName(this.driverClass);
            this.driver = (Driver)clazz.newInstance();
        }
        catch (Throwable t) {
            throw new SQLException("open: " + t);
        }
        LinkedList linkedList = this.connections;
        synchronized (linkedList) {
            int i = 0;
            while (i < this.minCount) {
                this.connections.addLast(this.createConnection());
                ++i;
            }
        }
        this.closed = false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("GenericDataSource[");
        sb.append("activeCount=");
        sb.append(this.activeCount);
        sb.append(", autoCommit=");
        sb.append(this.autoCommit);
        sb.append(", closed=");
        sb.append(this.closed);
        if (this.description != null) {
            sb.append(", description=");
            sb.append(this.description);
        }
        sb.append(", driverClass=");
        sb.append(this.driverClass);
        sb.append(", loginTimeout=");
        sb.append(this.loginTimeout);
        sb.append(", maxCount=");
        sb.append(this.maxCount);
        sb.append(", minCount=");
        sb.append(this.minCount);
        sb.append(", password=");
        sb.append(this.password);
        sb.append(", readOnly=");
        sb.append(this.readOnly);
        sb.append(", url=");
        sb.append(this.url);
        sb.append(", useCount=");
        sb.append(this.useCount);
        sb.append(", user=");
        sb.append(this.user);
        sb.append("]");
        return sb.toString();
    }

    protected synchronized Connection createConnection() throws SQLException {
        if (this.activeCount < this.maxCount) {
            if (this.debug >= 3) {
                this.log("   createConnection()");
            }
            Connection conn = this.driver.connect(this.url, this.properties);
            ++this.activeCount;
            return new GenericConnection(this, conn, this.autoCommit, this.readOnly);
        }
        if (this.debug >= 3) {
            this.log("   createConnection() returning null");
        }
        return null;
    }

    protected void log(String message) {
        if (this.logWriter != null) {
            this.logWriter.print("GenericDataSource[");
            this.logWriter.print(this.description);
            this.logWriter.print("]: ");
            this.logWriter.println(message);
        }
    }

    protected void log(String message, Throwable throwable) {
        if (this.logWriter != null) {
            this.logWriter.print("GenericDataSource[");
            this.logWriter.print(this.description);
            this.logWriter.print("]: ");
            this.logWriter.println(message);
            throwable.printStackTrace(this.logWriter);
        }
    }

    protected void ping(Connection conn) throws SQLException {
        if (this.pingCommand != null) {
            if (this.debug >= 4) {
                this.log("    ping(" + this.pingCommand + ")");
            }
            Statement stmt = conn.createStatement();
            try {
                stmt.execute(this.pingCommand);
                stmt.close();
            }
            catch (SQLException e) {
                if (this.debug >= 5) {
                    this.log("     ping() failed:  " + e);
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException f) {
                    // empty catch block
                }
                throw e;
            }
        }
        if (this.pingQuery != null) {
            if (this.debug >= 4) {
                this.log("    ping(" + this.pingQuery + ")");
            }
            ResultSet rs = null;
            Statement stmt = conn.createStatement();
            try {
                rs = stmt.executeQuery(this.pingQuery);
                while (rs.next()) {
                }
                rs.close();
                stmt.close();
            }
            catch (SQLException e) {
                if (this.debug >= 5) {
                    this.log("     ping() failed: " + e);
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException f) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException f) {
                    // empty catch block
                }
                throw e;
            }
        }
    }

    void returnConnection(GenericConnection conn) {
        if (this.debug >= 2) {
            this.log("  releaseConnection(), activeCount=" + this.activeCount + ", useCount=" + (this.useCount - 1));
        }
        LinkedList linkedList = this.connections;
        synchronized (linkedList) {
            this.connections.addLast(conn);
            --this.useCount;
        }
    }
}

