/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.OutputStreamWatcher;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.WatchableOutputStream;
import com.mysql.jdbc.WatchableWriter;
import com.mysql.jdbc.WriterWatcher;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.SQLException;

public class Clob
implements java.sql.Clob,
OutputStreamWatcher,
WriterWatcher {
    private String charData;

    Clob(String charData) {
        this.charData = charData;
    }

    public OutputStream setAsciiStream(long indexToWriteAt) throws SQLException {
        if (indexToWriteAt < 1L) {
            throw new SQLException("indexToWriteAt must be >= 1", "S1009");
        }
        WatchableOutputStream bytesOut = new WatchableOutputStream();
        bytesOut.setWatcher(this);
        if (indexToWriteAt > 0L) {
            bytesOut.write(this.charData.getBytes(), 0, (int)(indexToWriteAt - 1L));
        }
        return bytesOut;
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.charData != null) {
            return new ByteArrayInputStream(this.charData.getBytes());
        }
        return null;
    }

    public Writer setCharacterStream(long indexToWriteAt) throws SQLException {
        if (indexToWriteAt < 1L) {
            throw new SQLException("indexToWriteAt must be >= 1", "S1009");
        }
        WatchableWriter writer = new WatchableWriter();
        writer.setWatcher(this);
        if (indexToWriteAt > 1L) {
            writer.write(this.charData, 0, (int)(indexToWriteAt - 1L));
        }
        return writer;
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.charData != null) {
            return new StringReader(this.charData);
        }
        return null;
    }

    public int setString(long pos, String str) throws SQLException {
        if (pos < 1L) {
            throw new SQLException("Starting position can not be < 1", "S1009");
        }
        if (str == null) {
            throw new SQLException("String to set can not be NULL", "S1009");
        }
        StringBuffer charBuf = new StringBuffer(this.charData);
        int strLength = str.length();
        charBuf.replace((int)(--pos), (int)(pos + (long)strLength), str);
        this.charData = charBuf.toString();
        return strLength;
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        if (pos < 1L) {
            throw new SQLException("Starting position can not be < 1", "S1009");
        }
        if (str == null) {
            throw new SQLException("String to set can not be NULL", "S1009");
        }
        StringBuffer charBuf = new StringBuffer(this.charData);
        String replaceString = str.substring(offset, len);
        charBuf.replace((int)(--pos), (int)(pos + (long)replaceString.length()), replaceString);
        this.charData = charBuf.toString();
        return len;
    }

    public String getSubString(long startPos, int length) throws SQLException {
        if (startPos < 1L) {
            throw new SQLException("CLOB start position can not be < 1", "S1009");
        }
        if (this.charData != null) {
            if (startPos - 1L + (long)length > (long)this.charData.length()) {
                throw new SQLException("CLOB start position + length can not be > length of CLOB", "S1009");
            }
            return this.charData.substring((int)(startPos - 1L), length);
        }
        return null;
    }

    public long length() throws SQLException {
        if (this.charData != null) {
            return this.charData.length();
        }
        return 0L;
    }

    public long position(String stringToFind, long startPos) throws SQLException {
        if (startPos < 1L) {
            throw new SQLException("Illegal starting position for search, '" + startPos + "'", "S1009");
        }
        if (this.charData != null) {
            if (startPos - 1L > (long)this.charData.length()) {
                throw new SQLException("Starting position for search is past end of CLOB", "S1009");
            }
            int pos = this.charData.indexOf(stringToFind, (int)(startPos - 1L));
            return pos == -1 ? -1L : (long)(pos + 1);
        }
        return -1L;
    }

    public long position(java.sql.Clob arg0, long arg1) throws SQLException {
        return this.position(arg0.getSubString(0L, (int)arg0.length()), arg1);
    }

    public void streamClosed(byte[] byteData) {
        this.charData = StringUtils.toAsciiString(byteData);
    }

    public void truncate(long length) throws SQLException {
        if (length > (long)this.charData.length()) {
            throw new SQLException("Cannot truncate CLOB of length " + this.charData.length() + " to length of " + length + ".");
        }
        this.charData = this.charData.substring(0, (int)length);
    }

    public void writerClosed(char[] charData) {
        this.charData = new String(charData);
    }
}

