/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.jdbc.logging;

import com.ibatis.db.jdbc.logging.BaseLogProxy;
import com.ibatis.db.jdbc.logging.PreparedStatementLogProxy;
import com.ibatis.db.jdbc.logging.StatementLogProxy;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import net.sf.cglib.InvocationHandler;
import net.sf.cglib.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionLogProxy
extends BaseLogProxy
implements InvocationHandler {
    private static final Log log = LogFactory.getLog((Class)(class$java$sql$Connection == null ? (class$java$sql$Connection = ConnectionLogProxy.class$("java.sql.Connection")) : class$java$sql$Connection));
    private Connection connection;
    static /* synthetic */ Class class$java$sql$Connection;

    private ConnectionLogProxy(Connection connection) {
        this.connection = connection;
        if (log.isDebugEnabled()) {
            log.debug((Object)("{conn-" + this.id + "} Connection"));
        }
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if ("prepareStatement".equals(method.getName())) {
            PreparedStatement preparedStatement = (PreparedStatement)method.invoke((Object)this.connection, objectArray);
            preparedStatement = PreparedStatementLogProxy.newInstance(preparedStatement, (String)objectArray[0]);
            return preparedStatement;
        }
        if ("prepareCall".equals(method.getName())) {
            PreparedStatement preparedStatement = (PreparedStatement)method.invoke((Object)this.connection, objectArray);
            preparedStatement = PreparedStatementLogProxy.newInstance(preparedStatement, (String)objectArray[0]);
            return preparedStatement;
        }
        if ("createStatement".equals(method.getName())) {
            Statement statement = (Statement)method.invoke((Object)this.connection, objectArray);
            statement = StatementLogProxy.newInstance(statement);
            return statement;
        }
        return method.invoke((Object)this.connection, objectArray);
    }

    public static Connection newInstance(Connection connection) {
        ConnectionLogProxy connectionLogProxy = new ConnectionLogProxy(connection);
        ClassLoader classLoader = (class$java$sql$Connection == null ? (class$java$sql$Connection = ConnectionLogProxy.class$("java.sql.Connection")) : class$java$sql$Connection).getClassLoader();
        return (Connection)Proxy.newProxyInstance((ClassLoader)classLoader, (Class[])new Class[]{class$java$sql$Connection == null ? (class$java$sql$Connection = ConnectionLogProxy.class$("java.sql.Connection")) : class$java$sql$Connection}, (InvocationHandler)connectionLogProxy);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

