/**
 * User: Clinton Begin
 * Date: Jul 13, 2003
 * Time: 8:25:37 PM
 */
package com.ibatis.jpetstore.persistence.dao.sqlmapdao.mssql;

import com.ibatis.jpetstore.persistence.dao.sqlmapdao.*;
import com.ibatis.jpetstore.domain.*;
import com.ibatis.db.dao.*;

public class OrderMsSqlDao extends OrderSqlMapDao {

  /**
   * Whacked out MS SQL Server hack to allow Item ID to be retrieved so
   * that we can use it to link the foreign key of the Line Items!
   *
   * @param order
   * @throws DaoException
   */
  public void doInsertOrder(Order order)
      throws DaoException {
    Integer orderId = (Integer)executeQueryForObject("msSqlServerInsertOrder", order);

    order.setOrderId(orderId.intValue());

    executeUpdate("insertOrderStatus", order);
    for (int i = 0; i < order.getLineItems().size(); i++) {
      LineItem lineItem = (LineItem) order.getLineItems().get(i);
      lineItem.setOrderId(order.getOrderId());
      executeUpdate("insertLineItem", lineItem);
    }
  }
  
}
