package yoshida.tak.taglib;

import org.apache.struts.taglib.html.Constants;
import org.apache.struts.util.RequestUtils;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;


/**
 * @author Tak Yoshida
 * @version $Revision: 1.3 $
 */

public abstract class FormatterTag
    extends TagSupport {

  protected String name;

  public void setName(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  protected String property;

  public void setProperty(String property) {
    this.property = property;
  }

  public String getProperty() {
    return property;
  }

  protected String format;

  public void setFormat(String format) {
    this.format = format;
  }

  public String getFormat() {
    return format;
  }

  public int doStartTag() throws JspTagException {
    try {
      String beanName = Constants.BEAN_KEY;
      if (name != null) {
        beanName = name;
      }
      Object value = RequestUtils.lookup(pageContext, beanName, property, null);
      if (value != null) {
        pageContext.getOut().write(formatProperty(value));
      }

    } catch (IllegalArgumentException e) {
      // nested reference to a property returns null
    } catch (Exception e) {
      throw new JspTagException(e.getMessage());
    }

    return SKIP_BODY;
  }

  protected abstract String formatProperty(Object bean);

}