/*
 * Decompiled with CFR 0.152.
 */
package JpicDriver;

import JPICSDK.JpicDocument;
import JPICSDK.JpicDriverInterface;
import JPICSDK.JpicDriverOwnerInterface;
import JPICSDK.JpicXmlDocMaker;
import JpicDriver.PerformanceShowDriverInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.tidy.Tidy;

public class PerformanceShowDriver
implements JpicDriverInterface,
Runnable {
    private Thread thread_;
    private JpicXmlDocMaker jpicXmlDocMaker_;
    private JpicDriverOwnerInterface owner_;
    private String uri_;
    private String convertUri_;
    private int type_ = 0;
    private PerformanceShowDriverInfo info = new PerformanceShowDriverInfo();
    private String option_;
    private boolean isCachingOn_;
    private Map<String, JpicDocument> cachedUriAndDocMap_;
    private int CachSize_ = 10;
    private Queue<String> cachQueue_;

    public PerformanceShowDriver() {
        this.convertUri_ = new String();
        this.uri_ = new String();
        this.option_ = new String();
        this.cachedUriAndDocMap_ = new HashMap<String, JpicDocument>();
        this.cachQueue_ = new LinkedList<String>();
    }

    public void setOwner(JpicDriverOwnerInterface owner) {
        this.owner_ = owner;
    }

    private boolean cachMapChecking(String uri) {
        JpicDocument jDoc = this.cachedUriAndDocMap_.get(uri);
        if (jDoc != null) {
            Calendar timeCal = jDoc.timeGet();
            Calendar timeNow = Calendar.getInstance();
            long day = (timeNow.getTime().getTime() - timeCal.getTime().getTime()) / 86400000L;
            if (day > 1L) {
                this.cachedUriAndDocMap_.remove(uri);
                this.cachQueue_.remove(uri);
                return false;
            }
            this.owner_.onResponse(this.uri_, jDoc.DocumentGet());
            return true;
        }
        return false;
    }

    public void setCaching(boolean isCachingOn) {
        this.isCachingOn_ = isCachingOn;
    }

    public boolean isCachingOn() {
        return this.isCachingOn_;
    }

    public int getCachSize() {
        return this.CachSize_;
    }

    public void setCachSize(int size) {
        this.CachSize_ = size;
    }

    public JpicDriverOwnerInterface getOwner() {
        return this.owner_;
    }

    public boolean request(String uri) {
        if (this.owner_ == null) {
            return false;
        }
        if (this.thread_ != null && this.thread_.isAlive()) {
            return false;
        }
        this.uri_ = uri;
        if (this.cachMapChecking(uri)) {
            return true;
        }
        this.thread_ = new Thread(this);
        this.thread_.start();
        return true;
    }

    private String convertHexa(String str) throws UnsupportedEncodingException {
        String hexStr = new String();
        String strHexcode = "";
        byte[] utfByte = str.getBytes("utf-8");
        int i = 0;
        while (i < utfByte.length) {
            hexStr = String.valueOf(hexStr) + "%";
            if (utfByte[i] > 0 && utfByte[i] < 16) {
                hexStr = String.valueOf(hexStr) + "0";
            }
            strHexcode = Integer.toHexString(utfByte[i] & 0xFF).toUpperCase();
            hexStr = String.valueOf(hexStr) + strHexcode;
            ++i;
        }
        return hexStr;
    }

    private boolean uriAnalysis(String uri) throws UnsupportedEncodingException {
        String[] uriItem = uri.split("/");
        int uriLength = uriItem.length;
        this.type_ = 0;
        this.convertUri_ = this.info.baseUrl();
        if (uriItem[1].compareTo("\uacf5\uc5f0\ubaa9\ub85d") == 0) {
            if (uriItem[2].compareTo("\ud0a4\uc6cc\ub4dc") == 0) {
                this.type_ = 1;
                this.convertUri_ = String.valueOf(this.convertUri_) + this.info.searchUrl();
            } else if (uriItem[2].compareTo("\uc9c0\uc5ed") == 0) {
                this.type_ = 2;
                this.convertUri_ = String.valueOf(this.convertUri_) + this.info.locationUrl();
            }
        } else {
            if (uriItem[1].compareTo("\uc138\ubd80\uc0ac\ud56d") == 0) {
                if (uriLength == 4) {
                    this.type_ = 3;
                    this.convertUri_ = String.valueOf(this.convertUri_) + this.info.detailUrl();
                    this.convertUri_ = String.valueOf(this.convertUri_) + "ar_frac=" + uriItem[2] + "&";
                    this.convertUri_ = String.valueOf(this.convertUri_) + "ar_seq=" + uriItem[3] + "&";
                    return true;
                }
                return false;
            }
            if (uriItem[1].compareTo("\ud56d\ubaa9") == 0) {
                if (uriLength == 3) {
                    this.convertUri_ = String.valueOf(this.convertUri_) + this.info.itemUrl();
                    if (uriItem[2].compareTo("\ubd84\uc57c") == 0) {
                        this.type_ = 6;
                        this.option_ = "\ubd84\uc57c";
                    } else if (uriItem[2].compareTo("\uc9c0\uc5ed") == 0) {
                        this.type_ = 4;
                        this.option_ = "\uc9c0\uc5ed";
                    } else {
                        this.type_ = 5;
                        this.convertUri_ = String.valueOf(this.convertUri_) + "ar_sido=" + this.convertHexa(uriItem[2]) + "&";
                        this.option_ = uriItem[2];
                    }
                    return true;
                }
                return false;
            }
        }
        if (this.type_ == 1) {
            int i = 3;
            while (i < uriLength) {
                String temp = uriItem[i];
                switch (i) {
                    case 3: {
                        this.convertUri_ = String.valueOf(this.convertUri_) + "ar_search_kw=" + this.convertHexa(temp) + "&";
                        break;
                    }
                    case 4: {
                        if (temp.compareTo("\uc5f0\uadf9") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccm_code=A000&";
                            break;
                        }
                        if (temp.compareTo("\uc74c\uc545") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccm_code=B000&";
                            break;
                        }
                        if (temp.compareTo("\ubb34\uc6a9") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccm_code=C000&";
                            break;
                        }
                        if (temp.compareTo("\ubbf8\uc220") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccm_code=D000&";
                            break;
                        }
                        if (temp.compareTo("\uac74\ucd95") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccm_code=E000&";
                            break;
                        }
                        if (temp.compareTo("\uc601\uc0c1") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccm_code=G000&";
                            break;
                        }
                        if (temp.compareTo("\ubb38\ud559") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccm_code=H000&";
                            break;
                        }
                        if (temp.compareTo("\ucd95\uc81c\ubb38\ud654\uacf5\uac04") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccm_code=J000&";
                            break;
                        }
                        if (temp.compareTo("\uc804\uccb4\ubd84\uc57c") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccms_code=&";
                            break;
                        }
                        this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccms_code=&";
                        break;
                    }
                    case 5: {
                        if (temp.compareTo("\uc804\uccb4\uc2dc\uc791\uc77c") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_sdate=&";
                            break;
                        }
                        this.convertUri_ = String.valueOf(this.convertUri_) + "ar_sdate=" + temp + "&";
                        break;
                    }
                    case 6: {
                        if (temp.compareTo("\uc804\uccb4\uc885\ub8cc\uc77c") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_edate=&";
                            break;
                        }
                        this.convertUri_ = String.valueOf(this.convertUri_) + "ar_edate=" + temp + "&";
                        break;
                    }
                    case 7: {
                        this.convertUri_ = String.valueOf(this.convertUri_) + "ar_cpage=" + temp + "&";
                    }
                }
                ++i;
            }
            return true;
        }
        if (this.type_ == 2) {
            int i = 3;
            while (i < uriLength) {
                String temp = uriItem[i];
                switch (i) {
                    case 3: {
                        if (temp.compareTo("\uc804\uccb4\uc2dc\ub3c4") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_sido=&";
                            break;
                        }
                        this.convertUri_ = String.valueOf(this.convertUri_) + "ar_sido=" + this.convertHexa(temp) + "&";
                        break;
                    }
                    case 4: {
                        if (temp.compareTo("\uc804\uccb4\uad6c\uad70") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_gugun_c=&";
                            break;
                        }
                        this.convertUri_ = String.valueOf(this.convertUri_) + "ar_gugun_c=" + this.convertHexa(temp) + "&";
                        break;
                    }
                    case 5: {
                        if (temp.compareTo("\uc5f0\uadf9") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccm_code=A000&";
                            break;
                        }
                        if (temp.compareTo("\uc74c\uc545") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccm_code=B000&";
                            break;
                        }
                        if (temp.compareTo("\ubb34\uc6a9") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccm_code=C000&";
                            break;
                        }
                        if (temp.compareTo("\ubbf8\uc220") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccm_code=D000&";
                            break;
                        }
                        if (temp.compareTo("\uac74\ucd95") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccm_code=E000&";
                            break;
                        }
                        if (temp.compareTo("\uc601\uc0c1") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccm_code=G000&";
                            break;
                        }
                        if (temp.compareTo("\ubb38\ud559") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccm_code=H000&";
                            break;
                        }
                        if (temp.compareTo("\ucd95\uc81c\ubb38\ud654\uacf5\uac04") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccm_code=J000&";
                            break;
                        }
                        if (temp.compareTo("\uc804\uccb4\ubd84\uc57c") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccms_code=&";
                            break;
                        }
                        this.convertUri_ = String.valueOf(this.convertUri_) + "ar_select_ccms_code=&";
                        break;
                    }
                    case 6: {
                        if (temp.compareTo("\uc804\uccb4\uc2dc\uc791\uc77c") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_sdate=&";
                            break;
                        }
                        this.convertUri_ = String.valueOf(this.convertUri_) + "ar_sdate=" + temp + "&";
                        break;
                    }
                    case 7: {
                        if (temp.compareTo("\uc804\uccb4\uc885\ub8cc\uc77c") == 0) {
                            this.convertUri_ = String.valueOf(this.convertUri_) + "ar_edate=&";
                            break;
                        }
                        this.convertUri_ = String.valueOf(this.convertUri_) + "ar_edate=" + temp + "&";
                        break;
                    }
                    case 8: {
                        this.convertUri_ = String.valueOf(this.convertUri_) + "ar_cpage=" + temp + "&";
                    }
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private InputStream HttpSourceGet(String url) throws IOException {
        URL hUrl = new URL(url);
        URLConnection connection = hUrl.openConnection();
        connection.connect();
        return connection.getInputStream();
    }

    @Override
    public void run() {
        try {
            if (this.uriAnalysis(this.uri_)) {
                System.out.println(this.convertUri_);
                if (this.type_ == 1 || this.type_ == 2) {
                    this.listInfo(this.convertUri_);
                } else if (this.type_ == 3) {
                    this.detailInfo(this.convertUri_);
                } else if (this.type_ == 4 || this.type_ == 5 || this.type_ == 6) {
                    this.optionInfo(this.convertUri_);
                }
            } else {
                this.owner_.onResponse(this.uri_, null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String mergeChildText(NodeList nodeList) {
        String mergedText = new String();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                mergedText = String.valueOf(mergedText) + node.getNodeValue() + "\n";
            } else if (node.hasChildNodes()) {
                mergedText = String.valueOf(mergedText) + this.mergeChildText(node.getChildNodes());
            }
            ++i;
        }
        return mergedText;
    }

    private void listInfo(String url) throws ParserConfigurationException, IOException {
        InputStream in = this.HttpSourceGet(url);
        Tidy tidy = new Tidy();
        tidy.setInputEncoding("utf-8");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.newDocument();
        Document doc = tidy.parseDOM(in, null);
        Element root = document.createElement("Culture");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:noNamespaceSchemaLocation", "PerformanceShowDriverDocument.xsd");
        document.appendChild(root);
        Element mainUrl = document.createElement("Exhibition");
        root.appendChild(mainUrl);
        mainUrl.setAttribute("url", this.info.toString());
        Element infoList = document.createElement("List");
        root.appendChild(infoList);
        NodeList ul_List = doc.getElementsByTagName("ul");
        int i = 0;
        while (i < ul_List.getLength()) {
            Element element = (Element)ul_List.item(i);
            if (element.getAttribute("class").compareTo("imgList col4 scrap") == 0) {
                NodeList li_List = element.getElementsByTagName("li");
                int j = 0;
                while (j < li_List.getLength()) {
                    Element info = document.createElement("performance");
                    Element detail_uri = document.createElement("code");
                    Element img = document.createElement("main_image");
                    Element title = document.createElement("title");
                    Element term = document.createElement("term");
                    Element place = document.createElement("place");
                    info.appendChild(detail_uri);
                    info.appendChild(title);
                    info.appendChild(place);
                    info.appendChild(term);
                    info.appendChild(img);
                    NodeList p_List = ((Element)li_List.item(j)).getElementsByTagName("p");
                    int k = 0;
                    while (k < p_List.getLength()) {
                        Text objText;
                        NodeList a_List;
                        Element elementPart = (Element)p_List.item(k);
                        if (elementPart.getAttribute("class").compareTo("img") == 0) {
                            NodeList img_List = elementPart.getElementsByTagName("img");
                            a_List = elementPart.getElementsByTagName("a");
                            Element imgAttr = (Element)img_List.item(0);
                            Element detailAttr = (Element)a_List.item(0);
                            String imgStr = imgAttr.getAttribute("src");
                            String detailStr = detailAttr.getAttribute("href");
                            detailStr = detailStr.substring(detailStr.indexOf("(") + 1, detailStr.indexOf(")"));
                            String[] str = detailStr.split(",");
                            detailStr = "/" + str[0].replaceAll("'", "").trim();
                            detailStr = String.valueOf(detailStr) + "/" + str[1].replaceAll("'", "").trim();
                            objText = document.createTextNode(imgStr);
                            img.appendChild(objText);
                            objText = document.createTextNode(detailStr);
                            detail_uri.appendChild(objText);
                        } else if (elementPart.getAttribute("class").compareTo("txt") == 0) {
                            NodeList span_List = elementPart.getElementsByTagName("span");
                            Element intoList = (Element)span_List.item(0);
                            Node part = intoList.getLastChild();
                            if (part.getNodeValue().compareTo("\uc81c\ubaa9") == 0) {
                                a_List = elementPart.getElementsByTagName("a");
                                Element intoList2 = (Element)a_List.item(0);
                                if (intoList2 != null) {
                                    Node nameNode = intoList2.getLastChild();
                                    objText = document.createTextNode(nameNode.getNodeValue());
                                    title.appendChild(objText);
                                }
                            } else if (part.getNodeValue().compareTo("\ub0a0\uc9dc") == 0) {
                                Node termNode = elementPart.getLastChild().getPreviousSibling();
                                objText = document.createTextNode(termNode.getNodeValue());
                                term.appendChild(objText);
                            } else if (part.getNodeValue().compareTo("\uc7a5\uc18c") == 0) {
                                Node locationNode = elementPart.getLastChild();
                                objText = document.createTextNode(locationNode.getNodeValue());
                                place.appendChild(objText);
                            }
                        }
                        ++k;
                    }
                    infoList.appendChild(info);
                    ++j;
                }
            }
            ++i;
        }
        if (this.isCachingOn_) {
            if (this.cachQueue_.size() >= this.CachSize_) {
                this.cachQueue_.remove();
            }
            this.cachQueue_.add(this.uri_);
            JpicDocument jDoc = new JpicDocument();
            jDoc.timeSet();
            jDoc.DocumentSet(document);
            this.cachedUriAndDocMap_.put(this.uri_, jDoc);
        }
        this.owner_.onResponse(this.uri_, document);
    }

    private void detailInfo(String url) throws IOException, ParserConfigurationException {
        InputStream in = this.HttpSourceGet(url);
        Tidy tidy = new Tidy();
        tidy.setInputEncoding("UTF-8");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.newDocument();
        Document doc = tidy.parseDOM(in, null);
        Element root = document.createElement("Culture");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:noNamespaceSchemaLocation", "PerformanceShowDriverDocument.xsd");
        Element mainUrl = document.createElement("Exhibition");
        root.appendChild(mainUrl);
        mainUrl.setAttribute("url", this.info.toString());
        Element infoDetail = document.createElement("Infomation");
        document.appendChild(root);
        root.appendChild(infoDetail);
        NodeList div = doc.getElementsByTagName("div");
        int i = 0;
        while (i < div.getLength()) {
            Element element = (Element)div.item(i);
            if (element.getAttribute("id").compareTo("contentArea") == 0) {
                Element title = document.createElement("title");
                Element img = document.createElement("main_image");
                Element depart = document.createElement("category");
                Element place = document.createElement("place");
                Element location = document.createElement("location");
                Element term = document.createElement("term");
                Element ticket = document.createElement("ticket");
                Element telephone = document.createElement("telephone");
                Element viewUrl = document.createElement("viewURL");
                infoDetail.appendChild(title);
                infoDetail.appendChild(img);
                infoDetail.appendChild(depart);
                infoDetail.appendChild(place);
                infoDetail.appendChild(location);
                infoDetail.appendChild(term);
                infoDetail.appendChild(ticket);
                infoDetail.appendChild(telephone);
                infoDetail.appendChild(viewUrl);
                NodeList div_List = element.getElementsByTagName("div");
                int j = 0;
                while (j < div_List.getLength()) {
                    Text objText;
                    Element elementPart = (Element)div_List.item(j);
                    if (elementPart.getAttribute("class").compareTo("photoBg") == 0) {
                        NodeList img_List = elementPart.getElementsByTagName("img");
                        Element imgAttr = (Element)img_List.item(0);
                        String imgStr = imgAttr.getAttribute("src");
                        objText = document.createTextNode(imgStr);
                        img.appendChild(objText);
                    } else if (elementPart.getAttribute("class").compareTo("dataInfo") == 0) {
                        NodeList h2_List = elementPart.getElementsByTagName("h2");
                        Element titleElement = (Element)h2_List.item(0);
                        String titleStr = titleElement.getLastChild().getNodeValue();
                        objText = document.createTextNode(titleStr);
                        title.appendChild(objText);
                        NodeList table_List = elementPart.getElementsByTagName("table");
                        NodeList tbody_List = ((Element)table_List.item(0)).getElementsByTagName("tbody");
                        NodeList item_List = ((Element)tbody_List.item(0)).getElementsByTagName("tr");
                        int k = 0;
                        while (k < item_List.getLength()) {
                            Node nameNode;
                            Element intoList2;
                            NodeList td_List;
                            Element infoElement = (Element)item_List.item(k);
                            NodeList th_List = infoElement.getElementsByTagName("th");
                            Node part = ((Element)th_List.item(0)).getLastChild();
                            if (part.getNodeValue().compareTo("\uacf5\uc5f0\uc77c") == 0) {
                                td_List = infoElement.getElementsByTagName("td");
                                intoList2 = (Element)td_List.item(0);
                                if (intoList2 != null) {
                                    Node termNode = intoList2.getElementsByTagName("strong").item(0);
                                    String termStr = termNode.getFirstChild().getNodeValue();
                                    objText = document.createTextNode(termStr);
                                    term.appendChild(objText);
                                }
                            } else if (part.getNodeValue().compareTo("\ubd84\uc57c") == 0) {
                                td_List = infoElement.getElementsByTagName("td");
                                intoList2 = (Element)td_List.item(0);
                                if (intoList2 != null) {
                                    Node departNode = intoList2.getLastChild();
                                    objText = document.createTextNode(departNode.getNodeValue());
                                    depart.appendChild(objText);
                                }
                            } else if (part.getNodeValue().compareTo("\uad00\ub78cURL") == 0) {
                                td_List = infoElement.getElementsByTagName("td");
                                intoList2 = (Element)td_List.item(0);
                                if (intoList2 != null) {
                                    Node viewNode = intoList2.getElementsByTagName("a").item(0);
                                    String viewStr = ((Element)viewNode).getAttribute("href");
                                    objText = document.createTextNode(viewStr);
                                    viewUrl.appendChild(objText);
                                }
                            } else if (part.getNodeValue().compareTo("\ud2f0\ucf13\uc694\uae08") == 0) {
                                td_List = infoElement.getElementsByTagName("td");
                                intoList2 = (Element)td_List.item(0);
                                if (intoList2 != null) {
                                    nameNode = intoList2.getLastChild();
                                    objText = document.createTextNode(nameNode.getNodeValue());
                                    ticket.appendChild(objText);
                                }
                            } else if (part.getNodeValue().compareTo("\uc9c0\uc5ed") == 0) {
                                td_List = infoElement.getElementsByTagName("td");
                                intoList2 = (Element)td_List.item(0);
                                if (intoList2 != null) {
                                    nameNode = intoList2.getLastChild();
                                    objText = document.createTextNode(nameNode.getNodeValue());
                                    location.appendChild(objText);
                                }
                            } else if (part.getNodeValue().compareTo("\uc7a5\uc18c") == 0) {
                                td_List = infoElement.getElementsByTagName("td");
                                intoList2 = (Element)td_List.item(0);
                                if (intoList2 != null) {
                                    nameNode = intoList2.getLastChild();
                                    objText = document.createTextNode(nameNode.getNodeValue());
                                    place.appendChild(objText);
                                }
                            } else if (part.getNodeValue().compareTo("\ubb38\uc758\ucc98") == 0 && (intoList2 = (Element)(td_List = infoElement.getElementsByTagName("td")).item(0)) != null) {
                                nameNode = intoList2.getLastChild();
                                objText = document.createTextNode(nameNode.getNodeValue());
                                telephone.appendChild(objText);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            } else if (element.getAttribute("class").compareTo("db_con") == 0) {
                Text objText;
                Element contents = document.createElement("contents");
                Element subImg = document.createElement("imagelist");
                Element imgAttr = null;
                infoDetail.appendChild(contents);
                String text = new String();
                NodeList img_List = null;
                img_List = element.getElementsByTagName("img");
                NodeList nodeList = element.getChildNodes();
                int l = 0;
                while (l < nodeList.getLength()) {
                    if (nodeList.item(l).getNodeName().compareTo("script") == 0) {
                        element.removeChild(nodeList.item(l));
                    }
                    ++l;
                }
                if (element.hasChildNodes()) {
                    text = this.mergeChildText(nodeList).trim();
                    objText = document.createTextNode(text);
                    contents.appendChild(objText);
                }
                if (img_List != null) {
                    infoDetail.appendChild(subImg);
                    int j = 0;
                    while (j < img_List.getLength()) {
                        Element addImg = document.createElement("image");
                        imgAttr = (Element)img_List.item(j);
                        String imgStr = imgAttr.getAttribute("src");
                        objText = document.createTextNode(imgStr);
                        subImg.appendChild(objText);
                        addImg.appendChild(subImg);
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (this.isCachingOn_) {
            if (this.cachQueue_.size() >= this.CachSize_) {
                this.cachQueue_.remove();
            }
            this.cachQueue_.add(this.uri_);
            JpicDocument jDoc = new JpicDocument();
            jDoc.timeSet();
            jDoc.DocumentSet(document);
            this.cachedUriAndDocMap_.put(this.uri_, jDoc);
        }
        this.owner_.onResponse(this.uri_, document);
    }

    private void optionInfo(String url) throws IOException, Exception {
        InputStream in = this.HttpSourceGet(url);
        Tidy tidy = new Tidy();
        tidy.setInputEncoding("UTF-8");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.newDocument();
        Document doc = tidy.parseDOM(in, null);
        Element root = document.createElement("Culture");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:noNamespaceSchemaLocation", "PerformanceShowDriverDocument.xsd");
        Element mainUrl = document.createElement("Exhibition");
        root.appendChild(mainUrl);
        mainUrl.setAttribute("url", this.info.toString());
        Element infoList = document.createElement("Question");
        document.appendChild(root);
        root.appendChild(infoList);
        Element menu = document.createElement("option");
        infoList.appendChild(menu);
        menu.setAttribute("type", this.option_);
        NodeList form = doc.getElementsByTagName("form");
        int i = 0;
        while (i < form.getLength()) {
            Element element = (Element)form.item(i);
            if (element.getAttribute("class").compareTo("boardSearch2 mTm") == 0) {
                Element info;
                Text objText;
                String infoStr;
                Element elementInfo;
                int j;
                NodeList info_List;
                NodeList type_List;
                Element findThis = null;
                if (this.type_ == 4 || this.type_ == 5) {
                    type_List = element.getElementsByTagName("select");
                    int j2 = 0;
                    while (j2 < type_List.getLength()) {
                        Element elementInfo2 = (Element)type_List.item(j2);
                        if (this.type_ == 4 && elementInfo2.getAttribute("id").compareTo("ar_sido") == 0) {
                            findThis = elementInfo2;
                            break;
                        }
                        if (this.type_ == 5 && elementInfo2.getAttribute("id").compareTo("ar_gugun_c") == 0) {
                            findThis = elementInfo2;
                            break;
                        }
                        ++j2;
                    }
                    info_List = findThis.getElementsByTagName("option");
                    j = 0;
                    while (j < info_List.getLength()) {
                        elementInfo = (Element)info_List.item(j);
                        infoStr = elementInfo.getLastChild().getNodeValue();
                        objText = document.createTextNode(infoStr);
                        info = document.createElement("item");
                        info.appendChild(objText);
                        menu.appendChild(info);
                        ++j;
                    }
                } else if (this.type_ == 6) {
                    type_List = element.getElementsByTagName("ul");
                    int j3 = 0;
                    while (j3 < type_List.getLength()) {
                        Element elementInfo3 = (Element)type_List.item(j3);
                        if (elementInfo3.getAttribute("class").compareTo("radioList") == 0) {
                            findThis = elementInfo3;
                            break;
                        }
                        ++j3;
                    }
                    info_List = findThis.getElementsByTagName("label");
                    j = 0;
                    while (j < info_List.getLength()) {
                        elementInfo = (Element)info_List.item(j);
                        infoStr = elementInfo.getLastChild().getNodeValue();
                        objText = document.createTextNode(infoStr);
                        info = document.createElement("item");
                        info.appendChild(objText);
                        menu.appendChild(info);
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (this.isCachingOn_) {
            if (this.cachQueue_.size() >= this.CachSize_) {
                this.cachQueue_.remove();
            }
            this.cachQueue_.add(this.uri_);
            JpicDocument jDoc = new JpicDocument();
            jDoc.timeSet();
            jDoc.DocumentSet(document);
            this.cachedUriAndDocMap_.put(this.uri_, jDoc);
        }
        this.owner_.onResponse(this.uri_, document);
    }
}

