/*
 * Decompiled with CFR 0.152.
 */
package JpicDriver;

import JPICSDK.JpicDocument;
import JPICSDK.JpicDriverInterface;
import JPICSDK.JpicDriverOwnerInterface;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.tidy.Tidy;

public class USAFlightDelayDriver
implements JpicDriverInterface,
Runnable {
    private Thread thread_;
    private JpicDriverOwnerInterface owner_;
    private String uri_;
    private long timeout_ = 60L;
    private boolean isCachingOn_;
    private Map<String, JpicDocument> cachedUriAndDocMap_ = new HashMap<String, JpicDocument>();
    private int CacheSize_ = 10;
    private Queue<String> cacheQueue_ = new LinkedList<String>();

    private boolean cacheMapChecking(String uri) {
        JpicDocument jDoc = this.cachedUriAndDocMap_.get(uri);
        if (jDoc != null) {
            Calendar timeCal = jDoc.timeGet();
            Calendar timeNow = Calendar.getInstance();
            long day = (timeNow.getTime().getTime() - timeCal.getTime().getTime()) / 60000L;
            if (day > this.timeout_) {
                this.cachedUriAndDocMap_.remove(uri);
                this.cacheQueue_.remove(uri);
                return false;
            }
            this.owner_.onResponse(this.uri_, jDoc.DocumentGet());
            return true;
        }
        return false;
    }

    public void setCaching(boolean isCachingOn) {
        this.isCachingOn_ = isCachingOn;
    }

    public void setCacheValidTime(long timeout) {
        this.timeout_ = timeout;
    }

    public long getCacheValidTime() {
        return this.timeout_;
    }

    public boolean isCachingOn() {
        return this.isCachingOn_;
    }

    public int getCacheSize() {
        return this.CacheSize_;
    }

    public void setCacheSize(int size) {
        this.CacheSize_ = size;
    }

    public void setOwner(JpicDriverOwnerInterface owner) {
        this.owner_ = owner;
    }

    public JpicDriverOwnerInterface getOwner() {
        return this.owner_;
    }

    public boolean request(String uri) {
        if (this.owner_ == null) {
            return false;
        }
        if (this.thread_ != null && this.thread_.isAlive()) {
            return false;
        }
        this.uri_ = uri;
        if (this.cacheMapChecking(uri)) {
            return true;
        }
        this.thread_ = new Thread(this);
        this.thread_.start();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Element airportNameInfoElement;
        Element driverInfoElement;
        Element airportNameRootElement;
        String[] arguments = this.uri_.split("/");
        String mapInfoUrl = "www.fly.faa.gov/flyfaa/";
        String mapAreaWord = null;
        String airportRegion = null;
        String airportInfoUrl = "www.fly.faa.gov/flyfaa";
        String airportInfoIndexUrl = "/flyfaaindex.jsp?ARPT=";
        String airportWord = null;
        String airportInfoDefaultUrl = "&p=0";
        if (arguments.length <= 1) {
            this.owner_.onResponse(this.uri_, null);
            return;
        }
        if (arguments.length == 4) {
            if (arguments[1].compareTo("airportlist") != 0) {
                this.owner_.onResponse(this.uri_, null);
                return;
            }
            if (arguments[2].compareTo("region") == 0) {
                if (arguments[3].compareTo("nw") == 0) {
                    mapAreaWord = "nwmap.jsp";
                    airportRegion = "North Western";
                } else if (arguments[3].compareTo("nc") == 0) {
                    mapAreaWord = "ncmap.jsp";
                    airportRegion = "North Central";
                } else if (arguments[3].compareTo("ne") == 0) {
                    mapAreaWord = "nemap.jsp";
                    airportRegion = "North Eastern";
                } else if (arguments[3].compareTo("sw") == 0) {
                    mapAreaWord = "swmap.jsp";
                    airportRegion = "South Western";
                } else if (arguments[3].compareTo("sc") == 0) {
                    mapAreaWord = "scmap.jsp";
                    airportRegion = "South Central";
                } else if (arguments[3].compareTo("se") == 0) {
                    mapAreaWord = "semap.jsp";
                    airportRegion = "South Eastern";
                } else {
                    if (arguments[3].compareTo("fw") != 0) {
                        this.owner_.onResponse(this.uri_, null);
                        return;
                    }
                    mapAreaWord = "fwmap.jsp";
                    airportRegion = "Alaska & Hawaii";
                }
            }
            mapInfoUrl = String.valueOf(mapInfoUrl) + mapAreaWord;
        } else {
            if (arguments.length != 3) {
                this.owner_.onResponse(this.uri_, null);
                return;
            }
            if (arguments[1].compareTo("airportdelayinfo") == 0) {
                airportWord = arguments[2].toUpperCase();
                airportInfoUrl = String.valueOf(airportInfoUrl) + airportInfoIndexUrl + airportWord + airportInfoDefaultUrl;
            }
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Document resultDocument = documentBuilder.newDocument();
        String[] mapArguments = mapInfoUrl.split("/");
        String[] delayArguments = airportInfoUrl.split("/");
        if (mapArguments.length == 3) {
            airportNameRootElement = resultDocument.createElement("AirportInformation");
            resultDocument.appendChild(airportNameRootElement);
            airportNameRootElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            airportNameRootElement.setAttribute("xsi:noNamespaceSchemaLocation", "USAFlightDelayDriverDocument.xsd");
            driverInfoElement = resultDocument.createElement("AirTrafficControlSystemCommandCenter");
            driverInfoElement.setAttribute("url", "www.fly.faa.gov");
            airportNameRootElement.appendChild(driverInfoElement);
            airportNameInfoElement = resultDocument.createElement("NameInformation");
            airportNameRootElement.appendChild(airportNameInfoElement);
            airportNameInfoElement.appendChild(this.createTextElement(resultDocument, "Region", airportRegion));
            Element dataElement = resultDocument.createElement("List");
            airportNameInfoElement.appendChild(dataElement);
            resultDocument = this.getAirportNameInfo(resultDocument, dataElement, mapInfoUrl);
        }
        if (delayArguments.length == 3) {
            airportNameRootElement = resultDocument.createElement("AirportInformation");
            resultDocument.appendChild(airportNameRootElement);
            airportNameRootElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            airportNameRootElement.setAttribute("xsi:noNamespaceSchemaLocation", "USAFlightDelayDriverDocument.xsd");
            driverInfoElement = resultDocument.createElement("AirTrafficControlSystemCommandCenter");
            driverInfoElement.setAttribute("url", "www.fly.faa.gov");
            airportNameRootElement.appendChild(driverInfoElement);
            airportNameInfoElement = resultDocument.createElement("DelayInformation");
            airportNameRootElement.appendChild(airportNameInfoElement);
            resultDocument = this.getAirportDelayInfo(resultDocument, airportNameInfoElement, airportInfoUrl);
        }
        if (this.isCachingOn_) {
            if (this.cacheQueue_.size() >= this.CacheSize_) {
                this.cacheQueue_.remove();
            }
            this.cacheQueue_.add(this.uri_);
            JpicDocument jDoc = new JpicDocument();
            jDoc.timeSet();
            jDoc.DocumentSet(resultDocument);
            this.cachedUriAndDocMap_.put(this.uri_, jDoc);
        }
        this.owner_.onResponse(this.uri_, resultDocument);
    }

    private Document getAirportNameInfo(Document resultDocument, Element dataElement, String mapInfoUrl) {
        NodeList bTagList;
        block7: {
            mapInfoUrl = "http://" + mapInfoUrl;
            URL url = new URL(mapInfoUrl);
            URLConnection connection = url.openConnection();
            connection.connect();
            Tidy tidy = new Tidy();
            tidy.setInputEncoding("UTF-8");
            Document doc = tidy.parseDOM(connection.getInputStream(), null);
            bTagList = doc.getElementsByTagName("b");
            boolean isFound = false;
            if (bTagList.getLength() != 0) {
                isFound = true;
            }
            if (isFound) break block7;
            this.owner_.onResponse(this.uri_, null);
            return null;
        }
        try {
            String bTagAirportNameText = null;
            String bTagAirportFullNameText = null;
            String bTagAirportKeyText = null;
            String bTagAirportRegionText = null;
            String bTagAirportCityText = null;
            String bTagAirportStateText = null;
            int i = 0;
            while (i < bTagList.getLength()) {
                Element airportDataElement = resultDocument.createElement("Airport");
                dataElement.appendChild(airportDataElement);
                bTagAirportRegionText = bTagList.item(i).getChildNodes().item(2).getNodeValue();
                StringTokenizer airportRegionToken = new StringTokenizer(bTagAirportRegionText, ",");
                bTagAirportCityText = airportRegionToken.nextToken();
                airportDataElement.appendChild(this.createTextElement(resultDocument, "City", bTagAirportCityText));
                bTagAirportStateText = airportRegionToken.nextToken();
                airportDataElement.appendChild(this.createTextElement(resultDocument, "State", bTagAirportStateText));
                bTagAirportNameText = bTagList.item(i).getChildNodes().item(0).getNodeValue();
                StringTokenizer airportNameToken = new StringTokenizer(bTagAirportNameText, "()");
                bTagAirportFullNameText = airportNameToken.nextToken();
                airportDataElement.appendChild(this.createTextElement(resultDocument, "Name", bTagAirportFullNameText));
                bTagAirportKeyText = airportNameToken.nextToken();
                airportDataElement.appendChild(this.createTextElement(resultDocument, "Keyword", bTagAirportKeyText));
                ++i;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultDocument;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Document getAirportDelayInfo(Document resultDocument, Element dataElement, String airportInfoUrl) {
        block35: {
            try {
                airportInfoUrl = "http://" + airportInfoUrl;
                URL url = new URL(airportInfoUrl);
                URLConnection connection = url.openConnection();
                connection.connect();
                Tidy tidy = new Tidy();
                tidy.setInputEncoding("UTF-8");
                Document doc = tidy.parseDOM(connection.getInputStream(), null);
                NodeList thTagList = doc.getElementsByTagName("th");
                boolean nameInfoIsFound = false;
                if (thTagList.getLength() != 0) {
                    nameInfoIsFound = true;
                }
                if (!nameInfoIsFound) {
                    this.owner_.onResponse(this.uri_, null);
                    return null;
                }
                String trTagAirportInfo = null;
                String trTagAirportFullName = null;
                String trTagAirportKey = null;
                trTagAirportInfo = thTagList.item(0).getChildNodes().item(0).getNodeValue();
                StringTokenizer airportNameToken = new StringTokenizer(trTagAirportInfo, "()");
                trTagAirportFullName = airportNameToken.nextToken();
                dataElement.appendChild(this.createTextElement(resultDocument, "Name", trTagAirportFullName));
                trTagAirportKey = airportNameToken.nextToken();
                dataElement.appendChild(this.createTextElement(resultDocument, "Keyword", trTagAirportKey));
                NodeList tableList = doc.getElementsByTagName("table");
                Element tableTagElement = null;
                boolean isFound = false;
                int i = 0;
                while (i < tableList.getLength()) {
                    if (((Element)tableList.item(i)).getAttribute("border").compareTo("1") == 0) {
                        tableTagElement = (Element)tableList.item(i);
                        isFound = true;
                        break;
                    }
                    ++i;
                }
                if (!isFound) {
                    this.owner_.onResponse(this.uri_, null);
                    return null;
                }
                NodeList tdTagList = tableTagElement.getElementsByTagName("td");
                NodeList fontTagList = tableTagElement.getElementsByTagName("font");
                NodeList liTagList = tableTagElement.getElementsByTagName("li");
                NodeList bTagList = doc.getElementsByTagName("b");
                if (tdTagList.getLength() == 3) {
                    String tdTagDelaysByDestination = "";
                    String tdTagGeneralDepartureDelays = "";
                    String tdTagGeneralArrivalDelays = "";
                    String bTagLastUpdatedTime = "";
                    if (liTagList.getLength() != 0) {
                        int i2 = 0;
                        while (i2 < liTagList.getLength()) {
                            NodeList liTagNode = liTagList.item(i2).getChildNodes();
                            boolean liIsFound = false;
                            if (liTagNode.getLength() != 0) {
                                liIsFound = true;
                            }
                            if (liIsFound) {
                                int j = 0;
                                while (j < liTagNode.getLength()) {
                                    if (liTagNode.item(j).getNodeType() == 3) {
                                        tdTagDelaysByDestination = String.valueOf(tdTagDelaysByDestination) + liTagNode.item(j).getNodeValue();
                                    } else if (liTagNode.item(j).hasChildNodes()) {
                                        tdTagDelaysByDestination = String.valueOf(tdTagDelaysByDestination) + liTagNode.item(j).getChildNodes().item(0).getNodeValue();
                                    }
                                    ++j;
                                }
                            }
                            dataElement.appendChild(this.createTextElement(resultDocument, "DelaysByDestination", tdTagDelaysByDestination));
                            tdTagDelaysByDestination = "";
                            ++i2;
                        }
                        tdTagGeneralDepartureDelays = tdTagList.item(1).getChildNodes().item(0).getNextSibling().getNodeValue();
                        dataElement.appendChild(this.createTextElement(resultDocument, "GeneralDepartureDelays", tdTagGeneralDepartureDelays));
                        tdTagGeneralArrivalDelays = tdTagList.item(2).getChildNodes().item(0).getNextSibling().getNodeValue();
                        dataElement.appendChild(this.createTextElement(resultDocument, "GeneralArrivalDelays", tdTagGeneralArrivalDelays));
                        bTagLastUpdatedTime = bTagList.item(bTagList.getLength() - 1).getChildNodes().item(0).getNodeValue();
                        dataElement.appendChild(this.createTextElement(resultDocument, "LastUpdatedTime", bTagLastUpdatedTime));
                    } else {
                        boolean delayInfoIsFound = false;
                        if (tdTagList.getLength() != 0) {
                            delayInfoIsFound = true;
                        }
                        if (!delayInfoIsFound) {
                            this.owner_.onResponse(this.uri_, null);
                            return null;
                        }
                        tdTagDelaysByDestination = tdTagList.item(0).getChildNodes().item(0).getNextSibling().getNodeValue();
                        dataElement.appendChild(this.createTextElement(resultDocument, "DelaysByDestination", tdTagDelaysByDestination));
                        tdTagGeneralDepartureDelays = tdTagList.item(1).getChildNodes().item(0).getNextSibling().getNodeValue();
                        dataElement.appendChild(this.createTextElement(resultDocument, "GeneralDepartureDelays", tdTagGeneralDepartureDelays));
                        tdTagGeneralArrivalDelays = tdTagList.item(2).getChildNodes().item(0).getNextSibling().getNodeValue();
                        dataElement.appendChild(this.createTextElement(resultDocument, "GeneralArrivalDelays", tdTagGeneralArrivalDelays));
                        bTagLastUpdatedTime = bTagList.item(bTagList.getLength() - 1).getChildNodes().item(0).getNodeValue();
                        dataElement.appendChild(this.createTextElement(resultDocument, "LastUpdatedTime", bTagLastUpdatedTime));
                    }
                    break block35;
                }
                if (tdTagList.getLength() == 4) {
                    String airportStatus = "";
                    NodeList airportStatusNode = fontTagList.item(0).getChildNodes();
                    if (airportStatusNode.getLength() != 0) {
                        int i3 = 0;
                        while (i3 < airportStatusNode.getLength()) {
                            airportStatus = airportStatusNode.item(i3).getNodeType() == 3 ? String.valueOf(airportStatus) + airportStatusNode.item(i3).getNodeValue() : String.valueOf(airportStatus) + airportStatusNode.item(i3).getChildNodes().item(0).getNodeValue();
                            ++i3;
                        }
                        dataElement.appendChild(this.createTextElement(resultDocument, "Status", airportStatus));
                    }
                    String tdTagDelaysByDestination = "";
                    String tdTagGeneralDepartureDelays = "";
                    String tdTagGeneralArrivalDelays = "";
                    String bTagLastUpdatedTime = "";
                    if (liTagList.getLength() != 0) {
                        int i4 = 0;
                        while (i4 < liTagList.getLength()) {
                            NodeList liTagNode = liTagList.item(i4).getChildNodes();
                            boolean liIsFound = false;
                            if (liTagNode.getLength() != 0) {
                                liIsFound = true;
                            }
                            if (liIsFound) {
                                int j = 0;
                                while (j < liTagNode.getLength()) {
                                    if (liTagNode.item(j).getNodeType() == 3) {
                                        tdTagDelaysByDestination = String.valueOf(tdTagDelaysByDestination) + liTagNode.item(j).getNodeValue();
                                    } else if (liTagNode.item(j).hasChildNodes()) {
                                        tdTagDelaysByDestination = String.valueOf(tdTagDelaysByDestination) + liTagNode.item(j).getChildNodes().item(0).getNodeValue();
                                    }
                                    ++j;
                                }
                            }
                            dataElement.appendChild(this.createTextElement(resultDocument, "DelaysByDestination", tdTagDelaysByDestination));
                            tdTagDelaysByDestination = "";
                            ++i4;
                        }
                        tdTagGeneralDepartureDelays = tdTagList.item(1).getChildNodes().item(0).getNextSibling().getNodeValue();
                        dataElement.appendChild(this.createTextElement(resultDocument, "GeneralDepartureDelays", tdTagGeneralDepartureDelays));
                        tdTagGeneralArrivalDelays = tdTagList.item(2).getChildNodes().item(0).getNextSibling().getNodeValue();
                        dataElement.appendChild(this.createTextElement(resultDocument, "GeneralArrivalDelays", tdTagGeneralArrivalDelays));
                        bTagLastUpdatedTime = bTagList.item(bTagList.getLength() - 1).getChildNodes().item(0).getNodeValue();
                        dataElement.appendChild(this.createTextElement(resultDocument, "LastUpdatedTime", bTagLastUpdatedTime));
                    } else {
                        boolean delayInfoIsFound = false;
                        if (tdTagList.getLength() != 0) {
                            delayInfoIsFound = true;
                        }
                        if (!delayInfoIsFound) {
                            this.owner_.onResponse(this.uri_, null);
                            return null;
                        }
                        tdTagDelaysByDestination = tdTagList.item(1).getChildNodes().item(0).getNextSibling().getNodeValue();
                        dataElement.appendChild(this.createTextElement(resultDocument, "DelaysByDestination", tdTagDelaysByDestination));
                        tdTagGeneralDepartureDelays = tdTagList.item(2).getChildNodes().item(0).getNextSibling().getNodeValue();
                        dataElement.appendChild(this.createTextElement(resultDocument, "GeneralDepartureDelays", tdTagGeneralDepartureDelays));
                        tdTagGeneralArrivalDelays = tdTagList.item(3).getChildNodes().item(0).getNextSibling().getNodeValue();
                        dataElement.appendChild(this.createTextElement(resultDocument, "GeneralArrivalDelays", tdTagGeneralArrivalDelays));
                        bTagLastUpdatedTime = bTagList.item(bTagList.getLength() - 1).getChildNodes().item(0).getNodeValue();
                        dataElement.appendChild(this.createTextElement(resultDocument, "LastUpdatedTime", bTagLastUpdatedTime));
                    }
                    break block35;
                }
                this.owner_.onResponse(this.uri_, null);
                return null;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultDocument;
    }

    private Element createTextElement(Document creator, String elementName, String text) {
        Element elementNode = creator.createElement(elementName);
        Text textNode = creator.createTextNode(text);
        elementNode.appendChild(textNode);
        return elementNode;
    }
}

