/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Widget;

public class Caret
extends Widget {
    Canvas parent;
    int x;
    int y;
    int width;
    int height;
    boolean isVisible;
    boolean isShowing;
    int blinkRate;
    Image image;
    Font font;

    public Caret(Canvas canvas, int n) {
        super(canvas, n);
        this.parent = canvas;
        this.createWidget();
    }

    boolean blinkCaret() {
        if (!this.isVisible) {
            return true;
        }
        if (!this.isShowing) {
            return this.showCaret();
        }
        if (this.blinkRate == 0) {
            return true;
        }
        return this.hideCaret();
    }

    void createWidget() {
        super.createWidget();
        this.blinkRate = this.display.getCaretBlinkTime();
        this.isVisible = true;
        if (this.parent.getCaret() == null) {
            this.parent.setCaret(this);
        }
    }

    boolean drawCaret() {
        if (this.parent == null) {
            return false;
        }
        if (this.parent.isDisposed()) {
            return false;
        }
        int n = this.parent.handle;
        if (!this.parent.isDrawing(n)) {
            return false;
        }
        int n2 = this.width;
        int n3 = this.height;
        if (n2 <= 0) {
            n2 = 1;
        }
        int n4 = OS.GetControlOwner(n);
        int n5 = OS.GetWindowPort(n4);
        int[] nArray = new int[1];
        OS.GetPort(nArray);
        OS.SetPort(n5);
        int n6 = OS.NewRgn();
        int n7 = this.parent.getVisibleRegion(n, true);
        OS.GetClip(n6);
        OS.SetClip(n7);
        Rect rect = new Rect();
        OS.GetControlBounds(n, rect);
        CGPoint cGPoint = new CGPoint();
        int[] nArray2 = new int[1];
        OS.HIViewFindByID(OS.HIViewGetRoot(n4), OS.kHIViewWindowContentID(), nArray2);
        OS.HIViewConvertPoint(cGPoint, OS.HIViewGetSuperview(n), nArray2[0]);
        rect.left = (short)(rect.left + (int)cGPoint.x);
        rect.top = (short)(rect.top + (int)cGPoint.y);
        int n8 = rect.left + this.x;
        int n9 = rect.top + this.y;
        if (this.image == null) {
            OS.SetRect(rect, (short)n8, (short)n9, (short)(n8 + n2), (short)(n9 + n3));
            RGBColor rGBColor = new RGBColor();
            rGBColor.red = (short)-1;
            rGBColor.green = (short)-1;
            rGBColor.blue = (short)-1;
            OS.RGBBackColor(rGBColor);
            OS.InvertRect(rect);
        } else {
            int n10 = this.image.handle;
            n2 = OS.CGImageGetWidth(n10);
            n3 = OS.CGImageGetHeight(n10);
            int n11 = OS.CGImageGetBytesPerRow(n10);
            Rect rect2 = new Rect();
            rect2.right = (short)n2;
            rect2.bottom = (short)n3;
            Rect rect3 = new Rect();
            OS.GetWindowBounds(n4, (short)33, rect3);
            OS.SetRect(rect, (short)(n8 += rect3.left), (short)(n9 += rect3.top), (short)(n8 + n2), (short)(n9 + n3));
            int[] nArray3 = new int[1];
            OS.NewGWorldFromPtr(nArray3, 32, rect2, 0, 0, 0, this.image.data, n11);
            int[] nArray4 = new int[1];
            int[] nArray5 = new int[1];
            OS.GetGWorld(nArray4, nArray5);
            OS.SetGWorld(nArray3[0], nArray5[0]);
            int n12 = OS.GetPortBitMapForCopyBits(n5);
            int n13 = OS.GetPortBitMapForCopyBits(nArray3[0]);
            OS.OffsetRgn(n7, rect3.left, rect3.top);
            OS.CopyBits(n13, n12, rect2, rect, (short)6, n7);
            OS.OffsetRgn(n7, -rect3.left, -rect3.top);
            OS.SetGWorld(nArray4[0], nArray5[0]);
            OS.DisposeGWorld(nArray3[0]);
        }
        OS.SetClip(n6);
        OS.DisposeRgn(n7);
        OS.DisposeRgn(n6);
        OS.SetPort(nArray[0]);
        return true;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rectangle = this.image.getBounds();
            return new Rectangle(this.x, this.y, rectangle.width, rectangle.height);
        }
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Point getLocation() {
        this.checkWidget();
        return new Point(this.x, this.y);
    }

    public Canvas getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Point getSize() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rectangle = this.image.getBounds();
            return new Point(rectangle.width, rectangle.height);
        }
        return new Point(this.width, this.height);
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.isVisible;
    }

    boolean hideCaret() {
        if (!this.isShowing) {
            return true;
        }
        this.isShowing = false;
        return this.drawCaret();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.isVisible && this.parent.isVisible() && this.parent.hasFocus();
    }

    boolean isFocusCaret() {
        return this == this.display.currentCaret;
    }

    void killFocus() {
        if (this.display.currentCaret != this) {
            return;
        }
        this.display.setCurrentCaret(null);
        if (this.isVisible) {
            this.hideCaret();
        }
    }

    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getCaret()) {
            this.parent.setCaret(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.display.currentCaret == this) {
            this.hideCaret();
            this.display.setCurrentCaret(null);
        }
        this.parent = null;
        this.image = null;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.checkWidget();
        if (this.x == n && this.y == n2 && this.width == n3 && this.height == n4) {
            return;
        }
        boolean bl = this.isFocusCaret();
        if (bl && this.isVisible) {
            this.hideCaret();
        }
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        if (bl && this.isVisible) {
            this.showCaret();
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            this.error(4);
        }
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void setFocus() {
        if (this.display.currentCaret == this) {
            return;
        }
        this.display.setCurrentCaret(this);
        if (this.isVisible) {
            this.showCaret();
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
    }

    public void setImage(Image image) {
        boolean bl;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((bl = this.isFocusCaret()) && this.isVisible) {
            this.hideCaret();
        }
        this.image = image;
        if (bl && this.isVisible) {
            this.showCaret();
        }
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.setBounds(n, n2, this.width, this.height);
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setSize(int n, int n2) {
        this.checkWidget();
        this.setBounds(this.x, this.y, n, n2);
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSize(point.x, point.y);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (bl == this.isVisible) {
            return;
        }
        this.isVisible = bl;
        if (!this.isFocusCaret()) {
            return;
        }
        if (this.isVisible) {
            this.showCaret();
        } else {
            this.hideCaret();
        }
    }

    boolean showCaret() {
        if (this.isShowing) {
            return true;
        }
        this.isShowing = true;
        return this.drawCaret();
    }
}

