/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.carbon.ColorPickerInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;

    public ColorDialog(Shell shell) {
        this(shell, 65536);
    }

    public ColorDialog(Shell shell, int n) {
        super(shell, n);
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB open() {
        int n;
        int n2;
        ColorPickerInfo colorPickerInfo = new ColorPickerInfo();
        if (this.rgb != null) {
            colorPickerInfo.red = (short)(this.rgb.red * 257);
            colorPickerInfo.green = (short)(this.rgb.green * 257);
            colorPickerInfo.blue = (short)(this.rgb.blue * 257);
        } else {
            colorPickerInfo.red = (short)-1;
            colorPickerInfo.green = (short)-1;
            colorPickerInfo.blue = (short)-1;
        }
        colorPickerInfo.flags = 3;
        colorPickerInfo.placeWhere = 0;
        Point point = new Point();
        OS.GetGlobalMouse(point);
        colorPickerInfo.v = point.v;
        colorPickerInfo.h = point.h;
        if (this.title != null) {
            colorPickerInfo.prompt = new byte[256];
            n2 = this.title.length();
            if (n2 > 255) {
                n2 = 255;
            }
            colorPickerInfo.prompt[0] = (byte)n2;
            n = 0;
            while (n < n2) {
                colorPickerInfo.prompt[n + 1] = (byte)this.title.charAt(n);
                ++n;
            }
        }
        this.rgb = null;
        if (OS.PickColor(colorPickerInfo) == 0 && colorPickerInfo.newColorChosen) {
            n2 = colorPickerInfo.red >> 8 & 0xFF;
            n = colorPickerInfo.green >> 8 & 0xFF;
            int n3 = colorPickerInfo.blue >> 8 & 0xFF;
            this.rgb = new RGB(n2, n, n3);
        }
        return this.rgb;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

