/**
 * 
 */
package net.kldp.jzip;

import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Button;

/**
 * 파일 덮어쓰기 대화상자
 * 
 * @author jeongseungwon
 * 
 */
public class OverwriteDialog {

	public static final int YES = 0;	// 예

	public static final int NO = 1;	// 아니오

	public static final int ALL_YES = 2;	// 모두 예

	public static final int ALL_NO = 3;	// 모두 아니오

	public static final int CANCEL = 4;	// 취소

	private Shell sShell = null; // @jve:decl-index=0:visual-constraint="10,10"

	private Label label = null;

	private Composite composite = null;

	private Button buttonYes = null;

	private Button buttonNo = null;

	private Button buttonAllYes = null;

	private Button buttonAllNo = null;

	private int overwrite;

	/**
	 * OverwriteDialog의 생성자
	 */
	public OverwriteDialog() {
		overwrite = NO;
	}

	/**
	 * This method initializes sShell
	 */
	private void createSShell() {
		FormLayout formLayout = new FormLayout();
		formLayout.marginWidth = 10;
		formLayout.spacing = 10;
		formLayout.marginHeight = 10;
		sShell = new Shell(SWT.APPLICATION_MODAL | SWT.DIALOG_TRIM);
		sShell.setText("파일을 덮어쓸까요?");
		sShell.setLayout(formLayout);
		sShell.setSize(new Point(397, 177));
		label = new Label(sShell, SWT.WRAP);
		label.setText("파일이 이미 존재합니다.\n\n이 파일을 덮어쓸까요?");
		createComposite();
		sShell.addShellListener(new org.eclipse.swt.events.ShellAdapter() {
			public void shellClosed(org.eclipse.swt.events.ShellEvent e) {
				overwrite = CANCEL;
			}
		});
	}

	/**
	 * 파일 덮어쓰기 확인 대화상자를 화면에 표시한다.
	 * 
	 * @param parent
	 *            부모 쉘
	 * @param fileName
	 *            덮어쓸 파일명
	 * @return 사용자의 응답
	 */
	public int open(Shell parent, String fileName) {
		createSShell();

		label.setText(fileName + "\n" + label.getText());

		FormData formData;

		formData = new FormData();
		formData.top = new FormAttachment(0);
		formData.left = new FormAttachment(0);
		formData.right = new FormAttachment(100);
		label.setLayoutData(formData);

		formData = new FormData();
		formData.right = new FormAttachment(100);
		formData.bottom = new FormAttachment(100);
		composite.setLayoutData(formData);

		sShell.setParent(parent);

		sShell.open();
		Display display = parent.getDisplay();
		while (!sShell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}

		return overwrite;
	}

	/**
	 * This method initializes composite
	 * 
	 */
	private void createComposite() {
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 4;
		composite = new Composite(sShell, SWT.NONE);
		composite.setLayout(gridLayout);
		buttonYes = new Button(composite, SWT.NONE);
		buttonYes.setText("예(&Y)");
		buttonYes
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(
							org.eclipse.swt.events.SelectionEvent e) {
						overwrite = YES;
						sShell.dispose();
					}
				});
		buttonNo = new Button(composite, SWT.NONE);
		buttonNo.setText("아니오(&N)");
		buttonNo
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(
							org.eclipse.swt.events.SelectionEvent e) {
						overwrite = NO;
						sShell.dispose();
					}
				});
		buttonAllYes = new Button(composite, SWT.NONE);
		buttonAllYes.setText("모두 예(&A)");
		buttonAllYes
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(
							org.eclipse.swt.events.SelectionEvent e) {
						overwrite = ALL_YES;
						sShell.dispose();
					}
				});
		buttonAllNo = new Button(composite, SWT.NONE);
		buttonAllNo.setText("모두 아니오");
		buttonAllNo
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(
							org.eclipse.swt.events.SelectionEvent e) {
						overwrite = ALL_NO;
						sShell.dispose();
					}
				});
	}

}
