/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public abstract class ByteArrayTransfer
extends Transfer {
    public TransferData[] getSupportedTypes() {
        int[] nArray = this.getTypeIds();
        TransferData[] transferDataArray = new TransferData[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            transferDataArray[n] = new TransferData();
            transferDataArray[n].type = nArray[n];
            ++n;
        }
        return transferDataArray;
    }

    public boolean isSupportedType(TransferData transferData) {
        if (transferData == null) {
            return false;
        }
        int[] nArray = this.getTypeIds();
        int n = 0;
        while (n < nArray.length) {
            if (transferData.type == nArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (!this.checkByteArray(object) && !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        byte[] byArray = (byte[])object;
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        transferData.data = new byte[1][];
        transferData.data[0] = byArray2;
        transferData.result = 0;
    }

    protected Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        if (transferData.data.length == 0 || transferData.data[0].length == 0) {
            return null;
        }
        return transferData.data[0];
    }

    boolean checkByteArray(Object object) {
        return object != null && object instanceof byte[] && ((byte[])object).length > 0;
    }
}

