/**
 * ActionSelectionDialog : 동작 선택 대화상자
 */
package net.kldp.jzip;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.RowLayout;

/**
 * 동작 선택 대화상자
 * 
 * @author jeongseungwon
 * 
 */
public class ActionSelectDialog {

	private final class CancelAdaptor extends org.eclipse.swt.events.KeyAdapter {
		public void keyReleased(org.eclipse.swt.events.KeyEvent e) {
			if (e.keyCode == SWT.ESC) {
				// ESC 키를 누른 경우
				select = CANCEL;

				sShell.dispose();
			}
		}
	}

	/**
	 * 취소
	 */
	public static final int CANCEL = 0;

	/**
	 * 추가
	 */
	public static final int ADD = 1;

	/**
	 * 열기
	 */
	public static final int OPEN = 2;

	private Shell sShell = null; // @jve:decl-index=0:visual-constraint="10,10"

	private Label label = null;

	private Composite composite = null;

	private Button buttonCancel = null;

	private Button buttonAdd = null;

	private Button buttonOpen = null;

	private int select;

	public ActionSelectDialog() {
		select = CANCEL;
	}

	/**
	 * This method initializes composite
	 * 
	 */
	private void createComposite() {
		GridData gridData1 = new GridData();
		gridData1.horizontalAlignment = GridData.END;
		gridData1.verticalAlignment = GridData.CENTER;
		composite = new Composite(sShell, SWT.NONE);
		composite.setLayout(new RowLayout());
		composite.setLayoutData(gridData1);
		composite.addKeyListener(new CancelAdaptor());
		buttonCancel = new Button(composite, SWT.NONE);
		buttonCancel.setText("취소(&C)");
		buttonCancel
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(
							org.eclipse.swt.events.SelectionEvent e) {
						select = CANCEL;

						sShell.dispose();
					}
				});
		buttonCancel.addKeyListener(new CancelAdaptor());
		buttonAdd = new Button(composite, SWT.NONE);
		buttonAdd.setText("추가(&A)");
		buttonAdd
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(
							org.eclipse.swt.events.SelectionEvent e) {
						select = ADD;

						sShell.dispose();
					}
				});
		buttonAdd.addKeyListener(new CancelAdaptor());
		buttonOpen = new Button(composite, SWT.NONE);
		buttonOpen.setText("열기(&O)");
		buttonOpen
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(
							org.eclipse.swt.events.SelectionEvent e) {
						select = OPEN;

						sShell.dispose();
					}
				});
		buttonOpen.addKeyListener(new CancelAdaptor());
	}

	/**
	 * This method initializes sShell
	 */
	private void createSShell() {
		GridData gridData = new GridData();
		gridData.widthHint = 300;
		gridData.heightHint = 80;
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		gridLayout.makeColumnsEqualWidth = false;
		sShell = new Shell(SWT.APPLICATION_MODAL | SWT.DIALOG_TRIM);
		sShell.setText("이 파일을 어떻게 처리할까요?");
		sShell.setLayout(gridLayout);
		sShell.setSize(new Point(310, 132));
		label = new Label(sShell, SWT.WRAP);
		label.setText(" 파일을 현재 열려있는 압축 파일에 더하시겠습니까?\n" + "아니면 새로운 압축 파일로 여시겠습니까?");
		label.setLayoutData(gridData);
		createComposite();
		sShell.addKeyListener(new CancelAdaptor());
		sShell.addShellListener(new org.eclipse.swt.events.ShellAdapter() {
			public void shellClosed(org.eclipse.swt.events.ShellEvent e) {
				select = CANCEL;
			}
		});
	}

	/**
	 * {@link ActionSelectDialog}를 화면에 표시하는 메소드
	 * 
	 * @param parent
	 *            부모 {@link Shell}
	 * @param fileName
	 *            파일 명
	 * @return 선택된 동작
	 */
	public int open(Shell parent, String fileName) {
		createSShell();

		label.setText(fileName + label.getText());

		sShell.setParent(parent);

		sShell.pack();

		sShell.open();
		Display display = parent.getDisplay();
		while (!sShell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}

		return select;
	}
}
