/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    int textHandle;
    int buttonHandle;
    int textVisibleRgn;
    int buttonVisibleRgn;
    int increment = 1;
    int pageIncrement = 10;
    int digits = 0;
    static int GAP = 3;

    public Spinner(Composite composite, int n) {
        super(composite, Spinner.checkStyle(n));
    }

    int actionProc(int n, int n2) {
        int n3 = super.actionProc(n, n2);
        if (n3 == 0) {
            return n3;
        }
        if (n == this.buttonHandle) {
            int n4;
            int n5 = n4 = this.getSelectionText();
            switch (n2) {
                case 20: {
                    n5 += this.increment;
                    break;
                }
                case 21: {
                    n5 -= this.increment;
                }
            }
            int n6 = OS.GetControl32BitMaximum(this.buttonHandle);
            int n7 = OS.GetControl32BitMinimum(this.buttonHandle);
            if ((this.style & 0x40) != 0) {
                if (n5 > n6) {
                    n5 = n7;
                }
                if (n5 < n7) {
                    n5 = n6;
                }
            }
            if (n4 != (n5 = Math.min(Math.max(n7, n5), n6))) {
                this.setSelection(n5, true);
            }
        }
        return n3;
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int n) {
        return n & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        Object object;
        this.checkWidget();
        int n4 = 0;
        int n5 = 0;
        int n6 = OS.GetControl32BitMaximum(this.buttonHandle);
        String string = String.valueOf(n6);
        if (this.digits > 0) {
            object = new StringBuffer();
            ((StringBuffer)object).append(string);
            ((StringBuffer)object).append(this.getDecimalSeparator());
            n3 = this.digits - string.length();
            while (n3 >= 0) {
                ((StringBuffer)object).append("0");
                --n3;
            }
            string = ((StringBuffer)object).toString();
        }
        object = new char[string.length()];
        string.getChars(0, ((Object)object).length, (char[])object, 0);
        n3 = OS.CFStringCreateWithCharacters(0, (char[])object, ((Object)object).length);
        Point point = this.textExtent(n3, 0);
        if (n3 != 0) {
            OS.CFRelease(n3);
        }
        n4 = Math.max(n4, point.x);
        n5 = Math.max(n5, point.y);
        int[] nArray = new int[1];
        OS.GetThemeMetric(4, nArray);
        n4 += nArray[0] * 2;
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n5 = n2;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n4, n5);
        OS.GetThemeMetric(27, nArray);
        rectangle.height = Math.max(rectangle.height, nArray[0]);
        return new Point(rectangle.width, rectangle.height);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rect rect = this.inset();
        n3 += rect.left + rect.right;
        int[] nArray = new int[1];
        OS.GetThemeMetric(28, nArray);
        return new Rectangle(n, n2, n3 += nArray[0] + GAP, n4 += rect.top + rect.bottom);
    }

    public void copy() {
        this.checkWidget();
        short[] sArray = new short[2];
        if (OS.GetControlData(this.textHandle, (short)0, 1936026725, 4, sArray, null) != 0) {
            return;
        }
        if (sArray[0] == sArray[1]) {
            return;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (OS.GetControlData(this.textHandle, (short)0, 1667658612, 4, nArray, nArray2) != 0) {
            return;
        }
        CFRange cFRange = new CFRange();
        cFRange.location = sArray[0];
        cFRange.length = sArray[1] - sArray[0];
        char[] cArray = new char[cFRange.length];
        OS.CFStringGetCharacters(nArray[0], cFRange, cArray);
        OS.CFRelease(nArray[0]);
        this.copyToClipboard(cArray);
    }

    void createHandle() {
        int n = OS.GetControlOwner(this.parent.handle);
        int n2 = this.display.actionProc;
        int n3 = 6;
        int[] nArray = new int[1];
        OS.CreateUserPaneControl(n, null, n3, nArray);
        if (nArray[0] == 0) {
            this.error(2);
        }
        this.handle = nArray[0];
        OS.CreateLittleArrowsControl(n, null, 0, 0, 100, 1, nArray);
        if (nArray[0] == 0) {
            this.error(2);
        }
        this.buttonHandle = nArray[0];
        OS.SetControlAction(this.buttonHandle, n2);
        OS.CreateEditUnicodeTextControl(n, null, 0, false, null, nArray);
        if (nArray[0] == 0) {
            this.error(2);
        }
        this.textHandle = nArray[0];
        OS.SetControlData(this.textHandle, 0, 1936157795, 1, new byte[]{1});
        if ((this.style & 8) != 0) {
            OS.SetControlData(this.textHandle, 0, 1819239275, 1, new byte[]{1});
        }
        this.setSelection(0, false);
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        short[] sArray = new short[2];
        if (OS.GetControlData(this.textHandle, (short)0, 1936026725, 4, sArray, null) != 0) {
            return;
        }
        if (sArray[0] == sArray[1]) {
            return;
        }
        char[] cArray = this.setText("", sArray[0], sArray[1], true);
        if (cArray != null) {
            this.copyToClipboard(cArray);
        }
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.textHandle);
        this.display.removeWidget(this.buttonHandle);
    }

    void drawBackground(int n, int n2) {
        if (n == this.textHandle) {
            this.fillBackground(n, n2, null);
        } else {
            this.parent.fillBackground(n, n2, null);
        }
    }

    int focusHandle() {
        return this.textHandle;
    }

    public int getDigits() {
        this.checkWidget();
        return this.digits;
    }

    String getDecimalSeparator() {
        int n = OS.CFLocaleCopyCurrent();
        int n2 = OS.CFNumberFormatterCreate(0, n, 1);
        int n3 = OS.kCFNumberFormatterDecimalSeparator();
        int n4 = OS.CFNumberFormatterCopyProperty(n2, n3);
        CFRange cFRange = new CFRange();
        cFRange.location = 0;
        cFRange.length = OS.CFStringGetLength(n4);
        char[] cArray = new char[cFRange.length];
        OS.CFStringGetCharacters(n4, cFRange, cArray);
        OS.CFRelease(n4);
        OS.CFRelease(n2);
        OS.CFRelease(n);
        return new String(cArray);
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return OS.GetControl32BitMaximum(this.buttonHandle);
    }

    public int getMinimum() {
        this.checkWidget();
        return OS.GetControl32BitMinimum(this.buttonHandle);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        return OS.GetControl32BitValue(this.buttonHandle);
    }

    int getSelectionText() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (OS.GetControlData(this.textHandle, (short)0, 1667658612, 4, nArray, nArray2) == 0) {
            CFRange cFRange = new CFRange();
            cFRange.location = 0;
            cFRange.length = OS.CFStringGetLength(nArray[0]);
            char[] cArray = new char[cFRange.length];
            OS.CFStringGetCharacters(nArray[0], cFRange, cArray);
            OS.CFRelease(nArray[0]);
            String string = new String(cArray);
            try {
                int n;
                int n2;
                if (this.digits > 0) {
                    String string2 = this.getDecimalSeparator();
                    n2 = string.indexOf(string2);
                    if (n2 != -1) {
                        int n3;
                        int n4;
                        String string3 = string.substring(0, n2);
                        String string4 = string.substring(n2 + 1);
                        if (string4.length() > this.digits) {
                            string4 = string4.substring(0, this.digits);
                        } else {
                            n4 = this.digits - string4.length();
                            n3 = 0;
                            while (n3 < n4) {
                                string4 = String.valueOf(string4) + "0";
                                ++n3;
                            }
                        }
                        n4 = Integer.parseInt(string3);
                        n3 = Integer.parseInt(string4);
                        int n5 = 0;
                        while (n5 < this.digits) {
                            n4 *= 10;
                            ++n5;
                        }
                        n = n4 + n3;
                    } else {
                        n = Integer.parseInt(string);
                    }
                } else {
                    n = Integer.parseInt(string);
                }
                int n6 = OS.GetControl32BitMaximum(this.buttonHandle);
                n2 = OS.GetControl32BitMinimum(this.buttonHandle);
                if (n2 <= n && n <= n6) {
                    return n;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return OS.GetControl32BitValue(this.buttonHandle);
    }

    int getVisibleRegion(int n, boolean bl) {
        if (n == this.textHandle) {
            if (!bl) {
                return super.getVisibleRegion(n, bl);
            }
            if (this.textVisibleRgn == 0) {
                this.textVisibleRgn = OS.NewRgn();
                this.calculateVisibleRegion(n, this.textVisibleRgn, bl);
            }
            int n2 = OS.NewRgn();
            OS.CopyRgn(this.textVisibleRgn, n2);
            return n2;
        }
        if (n == this.buttonHandle) {
            if (!bl) {
                return super.getVisibleRegion(n, bl);
            }
            if (this.buttonVisibleRgn == 0) {
                this.buttonVisibleRgn = OS.NewRgn();
                this.calculateVisibleRegion(n, this.buttonVisibleRgn, bl);
            }
            int n3 = OS.NewRgn();
            OS.CopyRgn(this.buttonVisibleRgn, n3);
            return n3;
        }
        return super.getVisibleRegion(n, bl);
    }

    void hookEvents() {
        super.hookEvents();
        int n = this.display.controlProc;
        int[] nArray = new int[]{1668183148, 4, 1668183148, 7, 1668183148, 51};
        int n2 = OS.GetControlEventTarget(this.textHandle);
        OS.InstallEventHandler(n2, n, nArray.length / 2, nArray, this.handle, null);
        n2 = OS.GetControlEventTarget(this.buttonHandle);
        OS.InstallEventHandler(n2, n, nArray.length / 2, nArray, this.handle, null);
    }

    Rect inset() {
        return this.display.editTextInset;
    }

    int kEventControlSetFocusPart(int n, int n2, int n3) {
        int n4 = super.kEventControlSetFocusPart(n, n2, n3);
        if (n4 == 0) {
            short[] sArray = new short[1];
            OS.GetEventParameter(n2, 1668313716, 1668313716, null, 2, null, sArray);
            if (sArray[0] == 0) {
                int n5 = this.getSelectionText();
                this.setSelection(n5, true);
            }
        }
        return n4;
    }

    int kEventUnicodeKeyPressed(int n, int n2, int n3) {
        int n4;
        int n5 = super.kEventUnicodeKeyPressed(n, n2, n3);
        if (n5 == 0) {
            return n5;
        }
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1953721189, 1702261350, null, nArray.length * 4, null, nArray);
        int[] nArray2 = new int[1];
        OS.GetEventParameter(nArray[0], 1801678692, 1835100014, null, nArray2.length * 4, null, nArray2);
        int n6 = 0;
        switch (nArray2[0]) {
            case 36: 
            case 76: {
                n4 = this.getSelectionText();
                this.setSelection(n4, true);
                this.postEvent(14);
                break;
            }
            case 116: {
                n6 = this.pageIncrement;
                break;
            }
            case 121: {
                n6 = -this.pageIncrement;
                break;
            }
            case 125: {
                n6 = -this.increment;
                break;
            }
            case 126: {
                n6 = this.increment;
            }
        }
        if (n6 != 0) {
            n4 = this.getSelectionText();
            int n7 = n4 + n6;
            int n8 = OS.GetControl32BitMaximum(this.buttonHandle);
            int n9 = OS.GetControl32BitMinimum(this.buttonHandle);
            if ((this.style & 0x40) != 0) {
                if (n7 > n8) {
                    n7 = n9;
                }
                if (n7 < n9) {
                    n7 = n8;
                }
            }
            if (n4 != (n7 = Math.min(Math.max(n9, n7), n8))) {
                this.setSelection(n7, true);
            }
            return 0;
        }
        return n5;
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        String string = this.getClipboardText();
        short[] sArray = new short[2];
        if (OS.GetControlData(this.textHandle, (short)0, 1936026725, 4, sArray, null) != 0) {
            return;
        }
        this.setText(string, sArray[0], sArray[1], true);
    }

    public void redraw() {
        this.checkWidget();
        super.redraw();
        this.redrawWidget(this.textHandle, false);
        this.redrawWidget(this.buttonHandle, false);
    }

    void register() {
        super.register();
        this.display.addWidget(this.textHandle, this);
        this.display.addWidget(this.buttonHandle, this);
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    void resetVisibleRegion(int n) {
        if (this.textVisibleRgn != 0) {
            OS.DisposeRgn(this.textVisibleRgn);
            this.textVisibleRgn = 0;
        }
        if (this.buttonVisibleRgn != 0) {
            OS.DisposeRgn(this.buttonVisibleRgn);
            this.buttonVisibleRgn = 0;
        }
        super.resetVisibleRegion(n);
    }

    void resizeClientArea() {
        int[] nArray = new int[1];
        OS.GetThemeMetric(28, nArray);
        int n = nArray[0] + GAP;
        OS.GetThemeMetric(27, nArray);
        int n2 = nArray[0];
        Rect rect = new Rect();
        OS.GetControlBounds(this.handle, rect);
        Rect rect2 = this.inset();
        int n3 = Math.max(0, rect.right - rect.left - rect2.left - rect2.right - n);
        int n4 = Math.max(0, rect.bottom - rect.top - rect2.top - rect2.bottom);
        n2 = Math.min(n2, rect.bottom - rect.top);
        this.setBounds(this.textHandle, rect2.left, rect2.top, n3, n4, true, true, false);
        this.setBounds(this.buttonHandle, rect2.left + rect2.right + n3 + GAP, rect2.top + (n4 - n2) / 2, n, n2, true, true, false);
    }

    boolean sendKeyEvent(int n, Event event) {
        if (!super.sendKeyEvent(n, event)) {
            return false;
        }
        if (n != 1) {
            return true;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        String string = "";
        String string2 = "";
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n2 = 0;
        if (OS.GetControlData(this.textHandle, (short)0, 1667658612, 4, nArray2, nArray) == 0) {
            n2 = OS.CFStringGetLength(nArray2[0]);
            OS.CFRelease(nArray2[0]);
        }
        short[] sArray = new short[2];
        OS.GetControlData(this.textHandle, (short)0, 1936026725, 4, sArray, null);
        int n3 = sArray[0];
        int n4 = sArray[1];
        switch (event.character) {
            case '\b': {
                if (n3 != n4) break;
                if (n3 == 0) {
                    return true;
                }
                n3 = Math.max(0, n3 - 1);
                break;
            }
            case '\u007f': {
                if (n3 != n4) break;
                if (n3 == n2) {
                    return true;
                }
                n4 = Math.min(n4 + 1, n2);
                break;
            }
            case '\r': {
                return true;
            }
            default: {
                if (event.character != '\t' && event.character < ' ') {
                    return true;
                }
                string = new String(new char[]{event.character});
            }
        }
        if ((string2 = this.verifyText(string, n3, n4, event)) == null) {
            return false;
        }
        if (string2 != string) {
            this.setText(string2, n3, n4, false);
            sArray = new short[]{(short)(n3 += string2.length()), (short)n3};
            OS.SetControlData(this.textHandle, 0, 1936026725, 4, sArray);
        }
        this.postEvent(24);
        return string2 == string;
    }

    void setBackground(float[] fArray) {
        super.setBackground(fArray);
        this.setBackground(this.textHandle, fArray);
    }

    public void setDigits(int n) {
        this.checkWidget();
        if (n < 0) {
            this.error(5);
        }
        if (n == this.digits) {
            return;
        }
        this.digits = n;
        int n2 = OS.GetControl32BitValue(this.buttonHandle);
        this.setSelection(n2, false);
    }

    void setFontStyle(Font font) {
        super.setFontStyle(font);
        this.setFontStyle(this.textHandle, font);
    }

    void setForeground(float[] fArray) {
        super.setForeground(fArray);
        this.setForeground(this.textHandle, fArray);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.increment = n;
    }

    public void setMaximum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int n2 = OS.GetControl32BitMinimum(this.buttonHandle);
        if (n <= n2) {
            return;
        }
        int n3 = OS.GetControl32BitValue(this.buttonHandle);
        OS.SetControl32BitMaximum(this.buttonHandle, n);
        if (n3 > n) {
            this.setSelection(n, false);
        }
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int n2 = OS.GetControl32BitMaximum(this.buttonHandle);
        if (n >= n2) {
            return;
        }
        int n3 = OS.GetControl32BitValue(this.buttonHandle);
        OS.SetControl32BitMinimum(this.buttonHandle, n);
        if (n3 < n) {
            this.setSelection(n, false);
        }
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.pageIncrement = n;
    }

    public void setSelection(int n) {
        this.checkWidget();
        int n2 = OS.GetControl32BitMinimum(this.buttonHandle);
        int n3 = OS.GetControl32BitMaximum(this.buttonHandle);
        n = Math.min(Math.max(n2, n), n3);
        this.setSelection(n, false);
    }

    void setSelection(int n, boolean bl) {
        Object object;
        OS.SetControl32BitValue(this.buttonHandle, n);
        String string = String.valueOf(n);
        if (this.digits > 0) {
            object = this.getDecimalSeparator();
            int n2 = string.length() - this.digits;
            StringBuffer stringBuffer = new StringBuffer();
            if (n2 > 0) {
                stringBuffer.append(string.substring(0, n2));
                stringBuffer.append((String)object);
                stringBuffer.append(string.substring(n2));
            } else {
                stringBuffer.append("0");
                stringBuffer.append((String)object);
                while (n2++ < 0) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string);
            }
            string = stringBuffer.toString();
        }
        if (this.hooks(25) || this.filters(25)) {
            object = new int[1];
            int[] nArray = new int[1];
            int n3 = 0;
            if (OS.GetControlData(this.textHandle, (short)0, 1667658612, 4, nArray, (int[])object) == 0) {
                n3 = OS.CFStringGetLength(nArray[0]);
                OS.CFRelease(nArray[0]);
            }
            if ((string = this.verifyText(string, 0, n3, null)) == null) {
                return;
            }
        }
        object = new char[string.length()];
        string.getChars(0, ((Object)object).length, (char[])object, 0);
        int n4 = OS.CFStringCreateWithCharacters(0, (char[])object, ((Object)object).length);
        if (n4 == 0) {
            this.error(13);
        }
        OS.SetControlData(this.textHandle, 0, 1667658612, 4, new int[]{n4});
        OS.CFRelease(n4);
        this.redrawWidget(this.textHandle, false);
        this.sendEvent(24);
        if (bl) {
            this.postEvent(13);
        }
    }

    char[] setText(String string, int n, int n2, boolean bl) {
        if (bl && (this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, n, n2, null)) == null) {
            return null;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (OS.GetControlData(this.textHandle, (short)0, 1667658612, 4, nArray, nArray2) != 0) {
            return null;
        }
        int n3 = OS.CFStringGetLength(nArray[0]);
        char[] cArray = new char[n3 - (n2 - n) + string.length()];
        CFRange cFRange = new CFRange();
        cFRange.location = 0;
        cFRange.length = n;
        char[] cArray2 = new char[cFRange.length];
        OS.CFStringGetCharacters(nArray[0], cFRange, cArray2);
        System.arraycopy(cArray2, 0, cArray, 0, cFRange.length);
        string.getChars(0, string.length(), cArray, n);
        cFRange.location = n2;
        cFRange.length = n3 - n2;
        cArray2 = new char[cFRange.length];
        OS.CFStringGetCharacters(nArray[0], cFRange, cArray2);
        System.arraycopy(cArray2, 0, cArray, n + string.length(), cFRange.length);
        cFRange.location = n;
        cFRange.length = n2 - n;
        cArray2 = new char[cFRange.length];
        OS.CFStringGetCharacters(nArray[0], cFRange, cArray2);
        OS.CFRelease(nArray[0]);
        nArray[0] = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        if (nArray[0] == 0) {
            this.error(13);
        }
        OS.SetControlData(this.textHandle, 0, 1667658612, 4, nArray);
        OS.CFRelease(nArray[0]);
        if (bl) {
            this.sendEvent(24);
        }
        return cArray2;
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n3 <= n2) {
            return;
        }
        if (n4 < 0) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        n = Math.min(Math.max(n2, n), n3);
        this.increment = n5;
        this.pageIncrement = n6;
        this.digits = n4;
        OS.SetControl32BitMaximum(this.buttonHandle, n3);
        OS.SetControl32BitMinimum(this.buttonHandle, n2);
        this.setSelection(n, false);
    }

    void setZOrder() {
        super.setZOrder();
        if (this.textHandle != 0) {
            OS.HIViewAddSubview(this.handle, this.textHandle);
        }
        if (this.buttonHandle != 0) {
            OS.HIViewAddSubview(this.handle, this.buttonHandle);
        }
    }

    String verifyText(String string, int n, int n2, Event event) {
        Event event2 = new Event();
        event2.text = string;
        event2.start = n;
        event2.end = n2;
        if (event != null) {
            event2.character = event.character;
            event2.keyCode = event.keyCode;
            event2.stateMask = event.stateMask;
        }
        int n3 = 0;
        if (this.digits > 0) {
            String string2 = this.getDecimalSeparator();
            n3 = string.indexOf(string2);
            if (n3 != -1) {
                string = String.valueOf(string.substring(0, n3)) + string.substring(n3 + 1);
            }
            n3 = 0;
        }
        while (n3 < string.length()) {
            if (!Character.isDigit(string.charAt(n3))) break;
            ++n3;
        }
        event2.doit = n3 == string.length();
        this.sendEvent(25, event2);
        if (!event2.doit || this.isDisposed()) {
            return null;
        }
        return event2.text;
    }
}

