/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.TypedListener;

public class Shell
extends Decorations {
    int shellHandle;
    int windowGroup;
    boolean resized;
    boolean moved;
    boolean drawing;
    boolean reshape;
    boolean update;
    boolean deferDispose;
    boolean active;
    boolean disposed;
    boolean opened;
    int invalRgn;
    Control lastActive;
    Region region;
    Rect rgnRect;
    static int DEFAULT_CLIENT_WIDTH = -1;
    static int DEFAULT_CLIENT_HEIGHT = -1;

    public Shell() {
        this((Display)null);
    }

    public Shell(int n) {
        this((Display)null, n);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int n) {
        this(display, null, n, 0, false);
    }

    Shell(Display display, Shell shell, int n, int n2, boolean bl) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (shell != null && shell.isDisposed()) {
            this.error(5);
        }
        this.style = Shell.checkStyle(n);
        this.parent = shell;
        this.display = display;
        if (n2 != 0) {
            if (bl) {
                this.handle = n2;
            } else {
                this.shellHandle = n2;
                this.state |= 0x20000;
            }
        }
        this.createWidget();
    }

    public Shell(Shell shell) {
        this(shell, 2144);
    }

    public Shell(Shell shell, int n) {
        this(shell != null ? shell.display : null, shell, n, 0, false);
    }

    public static Shell internal_new(Display display, int n) {
        return new Shell(display, null, 8, n, false);
    }

    static int checkStyle(int n) {
        n = Decorations.checkStyle(n);
        int n2 = 229376;
        int n3 = n & ~n2;
        if ((n & 0x20000) != 0) {
            return n3 | 0x20000;
        }
        if ((n & 0x10000) != 0) {
            return n3 | 0x10000;
        }
        if ((n & 0x8000) != 0) {
            return n3 | 0x8000;
        }
        return n3;
    }

    public void addShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(shellListener);
        this.addListener(26, typedListener);
        this.addListener(21, typedListener);
        this.addListener(27, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
    }

    void bringToTop(boolean bl) {
        if (this.getMinimized()) {
            return;
        }
        if (bl) {
            this.forceActive();
        } else {
            this.setActive();
        }
    }

    void checkOpen() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        Rect rect = new Rect();
        OS.GetWindowStructureWidths(this.shellHandle, rect);
        rectangle.x -= rect.left;
        rectangle.y -= rect.top;
        rectangle.width += rect.left + rect.right;
        rectangle.height += rect.top + rect.bottom;
        return rectangle;
    }

    void createHandle() {
        Object object;
        this.state |= 0x32;
        int n = 0x2000000;
        n |= 0x80000;
        if ((this.style & 8) == 0) {
            if ((this.style & 0x40) != 0) {
                n |= 1;
            }
            if ((this.style & 0x80) != 0) {
                n |= 8;
            }
            if ((this.style & 0x400) != 0) {
                n |= 6;
            }
            if ((this.style & 0x10) != 0) {
                n |= 0x10;
                if ((this.style & 0x20) == 0) {
                    n |= 0x10000000;
                }
                if (!OS.__BIG_ENDIAN__()) {
                    n |= 0x10000000;
                }
            }
        }
        int n2 = 6;
        if ((this.style & 0x60) == 0) {
            n2 = 11;
        }
        if ((this.style & 0x38000) != 0 && (this.style & 0x4C0) == 0) {
            int n3 = n2 = (this.style & 0x20) != 0 ? 4 : 3;
        }
        if (this.shellHandle == 0) {
            object = this.getMonitor();
            Rectangle rectangle = ((Monitor)object).getClientArea();
            int n4 = rectangle.width * 5 / 8;
            int n5 = rectangle.height * 5 / 8;
            Rect rect = new Rect();
            OS.SetRect(rect, (short)0, (short)0, (short)n4, (short)n5);
            int[] nArray = new int[1];
            OS.CreateNewWindow(n2, n &= OS.GetAvailableWindowAttributes(n2), rect, nArray);
            if (nArray[0] == 0) {
                this.error(2);
            }
            this.shellHandle = nArray[0];
            OS.RepositionWindow(this.shellHandle, 0, 4);
            int[] nArray2 = new int[1];
            OS.HIViewFindByID(this.shellHandle, OS.kHIViewWindowContentID(), nArray2);
            if (nArray2[0] == 0) {
                OS.GetRootControl(this.shellHandle, nArray2);
            }
            if (nArray2[0] == 0) {
                this.error(2);
            }
            if ((this.style & 0x300) != 0) {
                this.createScrolledHandle(nArray2[0]);
            } else {
                this.createHandle(nArray2[0]);
            }
            OS.SetControlVisibility(this.topHandle(), false, false);
        } else {
            object = new int[1];
            OS.HIViewFindByID(this.shellHandle, OS.kHIViewWindowContentID(), (int[])object);
            if (object[0] == false) {
                OS.GetRootControl(this.shellHandle, (int[])object);
            }
            this.handle = OS.HIViewGetFirstSubview((int)object[0]);
            if (this.handle == 0) {
                this.error(2);
            }
            if (OS.IsWindowVisible(this.shellHandle)) {
                this.state &= 0xFFFFFFEF;
            }
        }
        object = new int[1];
        OS.CreateWindowGroup(16, (int[])object);
        if (object[0] == false) {
            this.error(2);
        }
        this.windowGroup = (int)object[0];
        int n6 = (this.style & 0x4000) != 0 ? OS.GetWindowGroupOfClass(5) : (this.parent != null ? this.parent.getShell().windowGroup : OS.GetWindowGroupOfClass(n2));
        OS.SetWindowGroup(this.shellHandle, n6);
        OS.SetWindowGroupParent(this.windowGroup, n6);
        OS.SetWindowGroupOwner(this.windowGroup, this.shellHandle);
        CGPoint cGPoint = new CGPoint();
        CGPoint cGPoint2 = new CGPoint();
        OS.GetWindowResizeLimits(this.shellHandle, cGPoint, cGPoint2);
        if (DEFAULT_CLIENT_WIDTH == -1) {
            DEFAULT_CLIENT_WIDTH = (int)cGPoint.x;
        }
        if (DEFAULT_CLIENT_HEIGHT == -1) {
            DEFAULT_CLIENT_HEIGHT = 0;
        }
        cGPoint.y = 0.0f;
        int n7 = 1248;
        if ((this.style & 8) != 0 || (this.style & n7) == 0) {
            cGPoint.x = 0.0f;
        }
        OS.SetWindowResizeLimits(this.shellHandle, cGPoint, cGPoint2);
    }

    void createWidget() {
        super.createWidget();
        this.resizeBounds();
    }

    void deregister() {
        super.deregister();
        int[] nArray = new int[1];
        OS.GetRootControl(this.shellHandle, nArray);
        this.display.removeWidget(nArray[0]);
    }

    void destroyWidget() {
        int n = this.shellHandle;
        Display display = this.display;
        Composite composite = this.parent;
        while (!this.deferDispose && composite != null) {
            Shell shell = composite.getShell();
            this.deferDispose = shell.deferDispose;
            composite = shell.parent;
        }
        if (this.deferDispose) {
            OS.HideWindow(this.shellHandle);
        }
        this.releaseHandle();
        if (n != 0) {
            if (this.deferDispose) {
                display.addDisposeWindow(n);
            } else {
                OS.DisposeWindow(n);
            }
        }
    }

    void drawWidget(int n, int n2, int n3, int n4, int n5) {
        super.drawWidget(n, n2, n3, n4, n5);
        if (this.region == null || this.region.isDisposed()) {
            return;
        }
        boolean bl = this.region.contains(0, 0);
        boolean bl2 = this.region.contains(this.rgnRect.right - 1, this.rgnRect.bottom - 1);
        if (bl && bl2) {
            return;
        }
        CGRect cGRect = new CGRect();
        cGRect.width = 1.0f;
        cGRect.height = 1.0f;
        if (!bl) {
            OS.CGContextClearRect(n2, cGRect);
        }
        if (!bl2) {
            cGRect.x = this.rgnRect.right - 1;
            cGRect.y = this.rgnRect.bottom - 1;
            OS.CGContextClearRect(n2, cGRect);
        }
        OS.CGContextSynchronize(n2);
    }

    Control findBackgroundControl() {
        return this.background != null || this.backgroundImage != null ? this : null;
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    Cursor findCursor() {
        return this.cursor;
    }

    void fixShell(Shell shell, Control control) {
        if (this == shell) {
            return;
        }
        if (control == this.lastActive) {
            this.setActiveControl(null);
        }
    }

    public void forceActive() {
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        OS.SelectWindow(this.shellHandle);
        int[] nArray = new int[2];
        nArray[1] = 2;
        OS.SetFrontProcessWithOptions(nArray, 1);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetWindowBounds(this.shellHandle, (short)32, rect);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    int getDrawCount(int n) {
        if (!this.isTrimHandle(n)) {
            return this.drawCount;
        }
        return 0;
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    public org.eclipse.swt.graphics.Point getLocation() {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetWindowBounds(this.shellHandle, (short)32, rect);
        return new org.eclipse.swt.graphics.Point(rect.left, rect.top);
    }

    public boolean getMaximized() {
        this.checkWidget();
        return super.getMaximized();
    }

    public boolean getMinimized() {
        this.checkWidget();
        if (!this.getVisible()) {
            return super.getMinimized();
        }
        return OS.IsWindowCollapsed(this.shellHandle);
    }

    public org.eclipse.swt.graphics.Point getMinimumSize() {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetWindowStructureWidths(this.shellHandle, rect);
        CGPoint cGPoint = new CGPoint();
        CGPoint cGPoint2 = new CGPoint();
        OS.GetWindowResizeLimits(this.shellHandle, cGPoint, cGPoint2);
        int n = Math.max(1, (int)cGPoint.x + (rect.left + rect.right));
        int n2 = Math.max(1, (int)cGPoint.y + (rect.top + rect.bottom));
        return new org.eclipse.swt.graphics.Point(n, n2);
    }

    float[] getParentBackground() {
        return null;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this;
    }

    public Shell[] getShells() {
        Shell[] shellArray;
        this.checkWidget();
        int n = 0;
        Shell[] shellArray2 = this.display.getShells();
        int n2 = 0;
        while (n2 < shellArray2.length) {
            shellArray = shellArray2[n2];
            while ((shellArray = shellArray.parent) != null && shellArray != this) {
            }
            if (shellArray == this) {
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        shellArray = new Shell[n];
        int n3 = 0;
        while (n3 < shellArray2.length) {
            Composite composite = shellArray2[n3];
            while ((composite = composite.parent) != null && composite != this) {
            }
            if (composite == this) {
                shellArray[n2++] = shellArray2[n3];
            }
            ++n3;
        }
        return shellArray;
    }

    public org.eclipse.swt.graphics.Point getSize() {
        this.checkWidget();
        Rect rect = new Rect();
        OS.GetWindowBounds(this.shellHandle, (short)32, rect);
        return new org.eclipse.swt.graphics.Point(rect.right - rect.left, rect.bottom - rect.top);
    }

    float getThemeAlpha() {
        return 1.0f;
    }

    boolean hasBorder() {
        return false;
    }

    void hookEvents() {
        super.hookEvents();
        int n = this.display.mouseProc;
        int n2 = this.display.windowProc;
        int[] nArray = new int[]{2003398244, 5, 2003398244, 27, 2003398244, 72, 2003398244, 67, 2003398244, 6, 2003398244, 2, 2003398244, 70, 2003398244, 1002, 2003398244, 25, 2003398244, 1003, 2003398244, 24, 2003398244, 1, 2003398244, 8};
        int n3 = OS.GetWindowEventTarget(this.shellHandle);
        OS.InstallEventHandler(n3, n2, nArray.length / 2, nArray, this.shellHandle, null);
        int[] nArray2 = new int[]{1836021107, 1, 1836021107, 6, 1836021107, 5, 1836021107, 2, 1836021107, 10};
        OS.InstallEventHandler(n3, n, nArray2.length / 2, nArray2, this.shellHandle, null);
    }

    void invalidateVisibleRegion(int n) {
        this.resetVisibleRegion(n);
        this.invalidateChildrenVisibleRegion(n);
    }

    void invalWindowRgn(int n, int n2) {
        this.display.needsPaint = true;
        if (this.invalRgn == 0) {
            this.invalRgn = OS.NewRgn();
        }
        OS.UnionRgn(n2, this.invalRgn, this.invalRgn);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    boolean isEnabledCursor() {
        return true;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    int kEventWindowActivated(int n, int n2, int n3) {
        int n4 = super.kEventWindowActivated(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        int[] nArray = new int[1];
        OS.GetWindowActivationScope(this.shellHandle, nArray);
        if (nArray[0] == 0) {
            return n4;
        }
        if (!this.active) {
            this.active = true;
            Display display = this.display;
            display.activeShell = this;
            display.setMenuBar(this.menuBar);
            if (this.menuBar != null) {
                OS.DrawMenuBar();
            }
            this.sendEvent(26);
            if (!(this.isDisposed() || this.restoreFocus() || this.traverseGroup(true))) {
                this.setFocus();
            }
            display.activeShell = null;
        }
        return n4;
    }

    int kEventWindowBoundsChanged(int n, int n2, int n3) {
        int n4 = super.kEventWindowBoundsChanged(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1635021938, 1835100014, null, nArray.length * 4, null, nArray);
        if ((nArray[0] & 8) != 0) {
            this.moved = true;
            this.sendEvent(10);
            if (this.isDisposed()) {
                return 0;
            }
        }
        if ((nArray[0] & 4) != 0) {
            this.resized = true;
            this.resizeBounds();
            this.sendEvent(11);
            if (this.isDisposed()) {
                return 0;
            }
            if (this.layout != null) {
                this.markLayout(false, false);
                this.updateLayout(false);
            }
            if (this.region != null && !this.region.isDisposed()) {
                OS.GetEventParameter(n2, 1668440948, 1902408308, null, 8, null, this.rgnRect);
                OS.SetRect(this.rgnRect, (short)0, (short)0, (short)(this.rgnRect.right - this.rgnRect.left), (short)(this.rgnRect.bottom - this.rgnRect.top));
                OS.ReshapeCustomWindow(this.shellHandle);
            }
        }
        return n4;
    }

    int kEventWindowClose(int n, int n2, int n3) {
        int n4 = super.kEventWindowClose(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        if (this.isEnabled()) {
            this.closeWidget();
        }
        return 0;
    }

    int kEventWindowCollapsed(int n, int n2, int n3) {
        int n4 = super.kEventWindowCollapsed(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        this.minimized = true;
        this.sendEvent(19);
        return n4;
    }

    int kEventWindowDeactivated(int n, int n2, int n3) {
        int n4 = super.kEventWindowDeactivated(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        if (this.active) {
            this.active = false;
            this.deferDispose = true;
            Display display = this.display;
            this.sendEvent(27);
            if (this.isDisposed()) {
                return n4;
            }
            this.saveFocus();
            if (this.savedFocus != null) {
                display.ignoreFocus = true;
                OS.ClearKeyboardFocus(this.shellHandle);
                display.ignoreFocus = false;
                if (!this.savedFocus.isDisposed()) {
                    this.savedFocus.sendFocusEvent(16, false);
                }
            }
            display.setMenuBar(null);
            this.deferDispose = false;
        }
        return n4;
    }

    int kEventWindowDrawContent(int n, int n2, int n3) {
        this.drawing = true;
        int n4 = OS.CallNextEventHandler(n, n2);
        this.drawing = false;
        if (this.reshape) {
            this.reshape = false;
            OS.ReshapeCustomWindow(this.shellHandle);
        }
        return n4;
    }

    int kEventWindowExpanded(int n, int n2, int n3) {
        int n4 = super.kEventWindowExpanded(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        this.minimized = false;
        this.sendEvent(20);
        return n4;
    }

    int kEventWindowGetClickModality(int n, int n2, int n3) {
        int n4 = OS.CallNextEventHandler(n, n2);
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1836542318, 2003398244, null, 4, null, nArray);
        if (nArray[0] != 0) {
            OS.SelectWindow(nArray[0]);
        }
        return n4;
    }

    int kEventWindowGetRegion(int n, int n2, int n3) {
        int n4 = super.kEventWindowGetRegion(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        if (this.region == null || this.region.isDisposed()) {
            return -9874;
        }
        short[] sArray = new short[1];
        OS.GetEventParameter(n2, 2004052080, 2004052080, null, 2, null, sArray);
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1919381096, 1919381096, null, 4, null, nArray);
        int n5 = nArray[0];
        switch (sArray[0]) {
            case 32: 
            case 33: {
                int n6;
                Rect rect;
                OS.RectRgn(n5, this.rgnRect);
                OS.SectRgn(n5, this.region.handle, n5);
                if (!this.region.contains(0, 0)) {
                    rect = new Rect();
                    OS.SetRect(rect, (short)0, (short)0, (short)1, (short)1);
                    n6 = OS.NewRgn();
                    OS.RectRgn(n6, rect);
                    OS.UnionRgn(n6, n5, n5);
                    OS.DisposeRgn(n6);
                }
                if (!this.region.contains(this.rgnRect.right - 1, this.rgnRect.bottom - 1)) {
                    rect = new Rect();
                    OS.SetRect(rect, (short)(this.rgnRect.right - 1), (short)(this.rgnRect.bottom - 1), this.rgnRect.right, this.rgnRect.bottom);
                    n6 = OS.NewRgn();
                    OS.RectRgn(n6, rect);
                    OS.UnionRgn(n6, n5, n5);
                    OS.DisposeRgn(n6);
                }
                return 0;
            }
        }
        OS.DiffRgn(n5, n5, n5);
        return 0;
    }

    int kEventWindowHidden(int n, int n2, int n3) {
        int n4 = super.kEventWindowHidden(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        Shell[] shellArray = this.getShells();
        int n5 = 0;
        while (n5 < shellArray.length) {
            Shell shell = shellArray[n5];
            if (!shell.isDisposed()) {
                shell.setWindowVisible(false);
            }
            ++n5;
        }
        return -9874;
    }

    int kEventWindowHitTest(int n, int n2, int n3) {
        int n4 = super.kEventWindowHitTest(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        if (this.region == null || this.region.isDisposed()) {
            return -9874;
        }
        Point point = new Point();
        int n5 = 4;
        OS.GetEventParameter(n2, 1835822947, 1363439732, null, n5, null, point);
        Rect rect = new Rect();
        OS.GetWindowBounds(this.shellHandle, (short)33, rect);
        OS.SetPt(point, (short)(point.h - rect.left), (short)(point.v - rect.top));
        int n6 = OS.NewRgn();
        OS.RectRgn(n6, this.rgnRect);
        OS.SectRgn(n6, this.region.handle, n6);
        short s = OS.PtInRgn(point, n6) ? (short)1 : 0;
        OS.DisposeRgn(n6);
        OS.SetEventParameter(n2, 2003071075, 2003071092, 2, new short[]{s});
        return 0;
    }

    int kEventWindowShown(int n, int n2, int n3) {
        int n4 = super.kEventWindowShown(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        this.invalidateVisibleRegion(this.topHandle());
        Shell[] shellArray = this.getShells();
        int n5 = 0;
        while (n5 < shellArray.length) {
            Shell shell = shellArray[n5];
            if (!shell.isDisposed() && shell.getVisible()) {
                shell.setWindowVisible(true);
            }
            ++n5;
        }
        return -9874;
    }

    int kEventWindowUpdate(int n, int n2, int n3) {
        this.update = true;
        int n4 = OS.CallNextEventHandler(n, n2);
        this.update = false;
        if (this.invalRgn != 0) {
            OS.InvalWindowRgn(this.shellHandle, this.invalRgn);
            OS.DisposeRgn(this.invalRgn);
            this.invalRgn = 0;
        }
        return n4;
    }

    void resizeBounds() {
        Rect rect = new Rect();
        OS.GetWindowBounds(this.shellHandle, (short)33, rect);
        int n = this.scrolledHandle != 0 ? this.scrolledHandle : this.handle;
        this.setBounds(n, 0, 0, rect.right - rect.left, rect.bottom - rect.top, false, true, false);
        this.resizeClientArea();
    }

    public void open() {
        this.checkWidget();
        this.bringToTop(false);
        this.setVisible(true);
        if (this.isDisposed()) {
            return;
        }
        if (this.active && !this.restoreFocus() && !this.traverseGroup(true)) {
            this.setFocus();
        }
    }

    void register() {
        super.register();
        int[] nArray = new int[1];
        OS.GetRootControl(this.shellHandle, nArray);
        this.display.addWidget(nArray[0], this);
    }

    void releaseChildren(boolean bl) {
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (shell != null && !shell.isDisposed()) {
                shell.dispose();
            }
            ++n;
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.shellHandle = 0;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        super.releaseWidget();
        this.disposed = true;
        if (this.windowGroup != 0) {
            OS.ReleaseWindowGroup(this.windowGroup);
        }
        this.display.updateQuitMenu();
        if (this.invalRgn != 0) {
            OS.DisposeRgn(this.invalRgn);
        }
        this.windowGroup = 0;
        this.invalRgn = 0;
        this.lastActive = null;
        this.region = null;
    }

    public void removeShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(26, shellListener);
        this.eventTable.unhook(21, shellListener);
        this.eventTable.unhook(27, shellListener);
        this.eventTable.unhook(19, shellListener);
        this.eventTable.unhook(20, shellListener);
    }

    public void setActive() {
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        OS.SelectWindow(this.shellHandle);
    }

    void setActiveControl(Control control) {
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] controlArray = control == null ? new Control[]{} : control.getPath();
        Control[] controlArray2 = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int n = 0;
        int n2 = Math.min(controlArray.length, controlArray2.length);
        while (n < n2) {
            if (controlArray[n] != controlArray2[n]) break;
            ++n;
        }
        int n3 = controlArray2.length - 1;
        while (n3 >= n) {
            if (!controlArray2[n3].isDisposed()) {
                controlArray2[n3].sendEvent(27);
            }
            --n3;
        }
        n3 = controlArray.length - 1;
        while (n3 >= n) {
            if (!controlArray[n3].isDisposed()) {
                controlArray[n3].sendEvent(26);
            }
            --n3;
        }
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        Rect rect = new Rect();
        if (!bl) {
            OS.GetWindowBounds(this.shellHandle, (short)32, rect);
            n = rect.left;
            n2 = rect.top;
        }
        if (!bl2) {
            OS.GetWindowBounds(this.shellHandle, (short)32, rect);
            n3 = rect.right - rect.left;
            n4 = rect.bottom - rect.top;
        } else {
            OS.GetWindowStructureWidths(this.shellHandle, rect);
            CGPoint cGPoint = new CGPoint();
            CGPoint cGPoint2 = new CGPoint();
            OS.GetWindowResizeLimits(this.shellHandle, cGPoint, cGPoint2);
            n3 = Math.max(1, Math.max(n3, (int)cGPoint.x + (rect.left + rect.right)));
            n4 = Math.max(1, Math.max(n4, (int)cGPoint.y + (rect.top + rect.bottom)));
        }
        OS.SetRect(rect, (short)n, (short)n2, (short)(n + n3), (short)(n2 + n4));
        OS.SetWindowBounds(this.shellHandle, 32, rect);
        return 0;
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if ((this.state & 8) == 0 == bl) {
            return;
        }
        super.setEnabled(bl);
        if (bl && OS.IsWindowActive(this.shellHandle) && !this.restoreFocus()) {
            this.traverseGroup(false);
        }
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        super.setMenuBar(menu);
        if (this.display.getActiveShell() == this) {
            this.display.setMenuBar(this.menuBar);
        }
    }

    public void setImeInputMode(int n) {
        this.checkWidget();
    }

    public void setMaximized(boolean bl) {
        this.checkWidget();
        super.setMaximized(bl);
        Point point = new Point();
        if (bl) {
            Rect rect = new Rect();
            int n = OS.GetMainDevice();
            OS.GetAvailableWindowPositioningBounds(n, rect);
            point.h = (short)(rect.right - rect.left);
            point.v = (short)(rect.bottom - rect.top);
        }
        short s = (short)(bl ? 8 : 7);
        OS.ZoomWindowIdeal(this.shellHandle, s, point);
    }

    public void setMinimized(boolean bl) {
        this.checkWidget();
        if (this.minimized == bl) {
            return;
        }
        super.setMinimized(bl);
        if (!bl && OS.IsWindowCollapsed(this.shellHandle)) {
            OS.SelectWindow(this.shellHandle);
        }
        OS.CollapseWindow(this.shellHandle, bl);
    }

    public void setMinimumSize(int n, int n2) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        int n5 = 1248;
        if ((this.style & 8) == 0 && (this.style & n5) != 0) {
            n3 = DEFAULT_CLIENT_WIDTH;
            n4 = DEFAULT_CLIENT_HEIGHT;
        }
        Rect rect = new Rect();
        OS.GetWindowStructureWidths(this.shellHandle, rect);
        CGPoint cGPoint = new CGPoint();
        CGPoint cGPoint2 = new CGPoint();
        OS.GetWindowResizeLimits(this.shellHandle, cGPoint, cGPoint2);
        n = Math.max(n, n3 + rect.left + rect.right);
        n2 = Math.max(n2, n4 + rect.top + rect.bottom);
        cGPoint.x = n - (rect.left + rect.right);
        cGPoint.y = n2 - (rect.top + rect.bottom);
        OS.SetWindowResizeLimits(this.shellHandle, cGPoint, cGPoint2);
        org.eclipse.swt.graphics.Point point = this.getSize();
        int n6 = Math.max(point.x, n);
        int n7 = Math.max(point.y, n2);
        if (n6 != point.x || n7 != point.y) {
            this.setSize(n6, n7);
        }
    }

    public void setMinimumSize(org.eclipse.swt.graphics.Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setMinimumSize(point.x, point.y);
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        if (region == null) {
            this.rgnRect = null;
        } else if (this.rgnRect == null) {
            this.rgnRect = new Rect();
            OS.GetWindowBounds(this.shellHandle, (short)32, this.rgnRect);
            OS.SetRect(this.rgnRect, (short)0, (short)0, (short)(this.rgnRect.right - this.rgnRect.left), (short)(this.rgnRect.bottom - this.rgnRect.top));
        }
        this.region = region;
        if (this.drawing) {
            this.reshape = true;
        } else {
            OS.ReshapeCustomWindow(this.shellHandle);
            this.redrawWidget(this.handle, true);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        if (n == 0) {
            this.error(13);
        }
        OS.SetWindowTitleWithCFString(this.shellHandle, n);
        OS.CFRelease(n);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (bl) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        this.setWindowVisible(bl);
    }

    void setWindowVisible(boolean bl) {
        if (OS.IsWindowVisible(this.shellHandle) == bl) {
            return;
        }
        if (bl) {
            int n;
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            int n2 = 0;
            if ((this.style & 0x8000) != 0) {
                n2 = 3;
            }
            if ((this.style & 0x10000) != 0) {
                n2 = 2;
            }
            if ((this.style & 0x20000) != 0) {
                n2 = 1;
            }
            if (n2 != 0) {
                n = 0;
                if (this.parent != null) {
                    n = OS.GetControlOwner(this.parent.handle);
                }
                OS.SetWindowModality(this.shellHandle, n2, n);
            }
            n = this.topHandle();
            OS.SetControlVisibility(n, true, false);
            int[] nArray = new int[1];
            if ((this.style & 0x4000) != 0) {
                OS.GetWindowActivationScope(this.shellHandle, nArray);
                OS.SetWindowActivationScope(this.shellHandle, 0);
            }
            int n3 = this.shellHandle;
            OS.RetainWindow(n3);
            OS.ShowWindow(n3);
            OS.ReleaseWindow(n3);
            if (this.isDisposed()) {
                return;
            }
            if (this.minimized != OS.IsWindowCollapsed(n3)) {
                OS.CollapseWindow(n3, this.minimized);
            }
            if ((this.style & 0x4000) != 0) {
                OS.SetWindowActivationScope(n3, nArray[0]);
                OS.BringToFront(n3);
            }
            this.opened = true;
            if (!this.moved) {
                this.moved = true;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (!this.resized) {
                this.resized = true;
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false);
                }
            }
        } else {
            if (!this.disposed) {
                OS.HideWindow(this.shellHandle);
            }
            if (this.isDisposed()) {
                return;
            }
            int n = this.topHandle();
            OS.SetControlVisibility(n, false, false);
            this.invalidateVisibleRegion(n);
            this.sendEvent(23);
        }
        this.display.updateQuitMenu();
    }

    void setZOrder() {
        if (this.scrolledHandle != 0) {
            OS.HIViewAddSubview(this.scrolledHandle, this.handle);
        }
    }

    void setZOrder(Control control, boolean bl) {
        if (bl) {
            OS.BringToFront(this.shellHandle);
        } else {
            int n = control == null ? 0 : OS.GetControlOwner(control.handle);
            OS.SendBehind(this.shellHandle, n);
        }
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }
}

