/*       D-Day: Normandy by Vipersoft
 ************************************
 *   $Source: /cvsroot/kdday/K\040D-Day\040Project/src/g_arty.c,v $
 *   $Revision: 1.3 $
 *   $Date: 2005/02/08 06:02:20 $
 * 
 ***********************************

Copyright (C) 2002 Vipersoft

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "g_local.h"
// g_arty.c
// D-Day: Normandy Artillery and Airstrikes

//////////////////////////////////////////////////////////////////////
//   This file is for handeling artillery and airstrike functions   //
//////////////////////////////////////////////////////////////////////

/* user definable variables 

	arty_delay  -- seconds for artillary to position           default: 10 
	arty_time   -- seconds between each volley                 default: 60
	arty_max    -- number of shots to be fired in each volley  default: 1
*/
void Airstrike_Plane_Launch(edict_t *ent);
void fire_Knife ( edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick, char *wav, qboolean fists);
void P_ProjectSource(gclient_t * client , vec3_t point , vec3_t distance , vec3_t forward , vec3_t right , vec3_t result );
void Weapon_Bayonet_Fire1 (edict_t *ent)
{
	vec3_t  forward, right;
    vec3_t  start;
    vec3_t  offset;
	vec3_t g_offset;
	
	VectorCopy (vec3_origin,g_offset);

    AngleVectors (ent->client->v_angle, forward, right, NULL);
    VectorSet(offset, 40, 8, ent->viewheight-8);
    VectorAdd (offset, g_offset, offset);
    P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

    VectorScale (forward, -2, ent->client->kick_origin);
    ent->client->kick_angles[0] = -1;
 
	//gi.dprintf("going to fire_knife\n");
	fire_Knife (ent, start, forward, 50, 0, "gbr/bayonet/hit.wav", 0);

	ent->client->ps.gunframe++;

//	Play_WepSound(ent, (armedfists)?"fists/fire.wav":"knife/fire.wav");  //faf
	gi.sound(ent, CHAN_WEAPON, gi.soundindex("gbr/bayonet/swipe.wav"), 1, ATTN_NORM, 0);//faf

	//	gi.sound(ent, CHAN_VOICE, gi.soundindex("*jump1.wav"), 1, ATTN_NORM, 0);
	PlayerNoise(ent, ent->s.origin, PNOISE_SELF);
}


void Arty_Sound (edict_t *ent);
/*
=================
Cmd_Arty_f
CCH: new function to call in airstrikes
=================
*/
void Cmd_Arty_f (edict_t *ent)
{
	vec3_t	start;
	vec3_t	forward;
	vec3_t	end;
	vec3_t world_up;

	edict_t *airstrike;//faf



	trace_t	tr;
	//int randnum;		

	if (!IsValidPlayer)
		return;

	if (ent->client &&
		ent->client->pers.weapon &&
		!strcmp(ent->client->pers.weapon->classname, "weapon_Enfield"))
	{
		if (ent->client->weaponstate == WEAPON_READY &&
			ent->client->ps.gunframe < 104 &&
			!ent->client->aim)
		{
			ent->client->ps.gunframe = 104;
			Weapon_Bayonet_Fire1 (ent);
			return;
		}
		return;
	}



	if (ent->client->resp.mos != OFFICER) {
		gi.cprintf(ent, PRINT_HIGH, "You're not an officer, soldier!\n");
		return;
	}

	if (ent->deadflag || ent->client->limbo_mode ) {
		gi.cprintf(ent, PRINT_HIGH, "You are dead!\n");
		return;
	}




	//faf:  moving this up so you dont have to look through binocs to cancel arty
	// make sure artillary hasn't already been called
	if (ent->client->airstrike)
	{
		gi.cprintf(ent, PRINT_HIGH, "Airstrike cancelled sir!\n");

		G_FreeEdict(ent->client->airstrike);
		ent->client->airstrike = NULL;
		return;
	}
	






	/* Wheaty: Officers can only call airstrikes with binoculars! */
	if (strcmp(ent->client->pers.weapon->classname, "weapon_binoculars"))
	{
		gi.cprintf(ent, PRINT_HIGH, "What the hell are you aiming at? Use your binoculars!\n");
		return;
	}
	else // pbowens: they have to be aiming, too
	{
		if (!(ent->client->buttons & BUTTON_ATTACK)) {
			gi.cprintf(ent, PRINT_HIGH, "Aim at the location, sir.\n");
			return;
		}
	}

	if ( ent->client->arty_time_restrict > level.time)//faf && ent->client->arty_num >= (int)arty_max->value)
	{
		int delay;

		delay = ((int)(ent->client->arty_time_restrict - level.time) +1);

		if (delay == 0)
			gi.cprintf(ent, PRINT_HIGH, "Can not call airstrike for another 1 second, sir!\n");
		else
			gi.cprintf(ent, PRINT_HIGH, "Can not call airstrike for another %i seconds, sir!\n", delay);

		return;
	}

	// reset the fired counter if past restrict time
//	if ( ent->client->arty_time_restrict <= level.time)//faf && ent->client->arty_num >= (int)arty_max->value )
//		ent->client->arty_num = 0;

	VectorCopy(ent->s.origin, start);
	start[2] += ent->viewheight;
	AngleVectors(ent->client->v_angle, forward, NULL, NULL);
	VectorMA(start, 8192, forward, end);

	tr = gi.trace(start, NULL, NULL, end, ent, MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA);

	if ( tr.surface && !(tr.surface->flags & SURF_SKY) )
	{ // We hit something but it wasn't sky, so let's see if there is sky above it

		VectorCopy(tr.endpos,ent->client->arty_target); //assign target to Arty
		VectorSet(world_up, 0, 0, 1);
		VectorMA(start, 8192, world_up, end);

		tr = gi.trace(ent->client->arty_target, NULL, NULL, end, ent, MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA);

		if ( tr.surface && !(tr.surface->flags & SURF_SKY))  // No sky above it either
		{
		gi.cprintf(ent, PRINT_HIGH, "Sir! Airstrikes must be fired in open areas at stationary grounds.\n");
			return;
		}
	}
	else  //faf:  this stops horizontal airstrikes
	{
		gi.cprintf(ent, PRINT_HIGH, "Sir! Airstrikes must be fired in open areas at stationary grounds.\n");
			return;
	}


	// set up for the arty strike
	VectorCopy(tr.endpos, ent->client->arty_entry);
	
		
	//randnum = ((rand() % ARTILLARY_WAIT) + 5);  //generate random number for eta

	if (ent)
		gi.cprintf(ent, PRINT_HIGH, "Ok, give us %d seconds to reach the target!\n", (int)arty_delay->value);

//	ent->client->arty_num++;
//	ent->client->arty_time_fire = level.time + arty_delay->value;

//	ent->client->arty_location = 1;//(rand() % 4) + 1;
	gi.sound(ent, CHAN_ITEM, gi.soundindex(va("%s/arty/target%i.wav", 
		ent->client->resp.team_on->teamid, 1)), 1, ATTN_NORM, 0);


	//faf:  so we can get rid of the arty stuff in clientthink



		airstrike = G_Spawn();
		gi.linkentity (airstrike);

		VectorCopy(tr.endpos, airstrike->pos2);
		airstrike->classname ="airstrike_called";

		airstrike->owner = ent;

		if (airstrikes->value == 1)
		{
			airstrike->think = Airstrike_Plane_Launch;

			ent->client->airstrike = airstrike;

			if (arty_delay->value > 2.1)
			{
				airstrike->nextthink = level.time + arty_delay->value - 2;
			}
			else
				airstrike->nextthink = level.time +.1;
		}
		else//ddaylife
		{
			airstrike->think = Arty_Sound;
			
			ent->client->airstrike = airstrike;

			if (arty_delay->value > 3.1)
			{
				airstrike->nextthink = level.time + arty_delay->value - 3;
			}
			else
				airstrike->nextthink = level.time +.1;
		}

}






void fire_airstrike (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, float damage_radius, int radius_damage);//faf

 
//faf:  deleted a lot of stuff here from 4.1  airstrike/arty

//put back in for ddaylife

void Think_Arty (edict_t *ent)
{
	vec3_t	start;
	vec3_t	forward;
	vec3_t	end;
	vec3_t	targetdir;
	vec3_t  tempvec;
	trace_t	tr;
	trace_t tr_2;



		if (!ent->owner ||
		!ent->owner->client ||
		!ent->owner->inuse ||
		!ent->owner->client->resp.team_on ||
		ent->owner->flyingnun)
	{
		G_FreeEdict(ent);
		return;
	}

	if (!ent->owner->client->airstrike)
	{
		G_FreeEdict(ent);
		return;
	}

	if (ent->owner->client->airstrike &&
		ent->owner->client->airstrike != ent)
	{
		G_FreeEdict(ent);
		return;
	}






	// find the target point
	VectorCopy(ent->owner->s.origin, start);
	start[2] += ent->owner->viewheight;
	AngleVectors(ent->owner->client->v_angle, forward, NULL, NULL);
	VectorMA(start, 8192, forward, end);
	tr = gi.trace(start, NULL, NULL, end, ent->owner, MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA);

	// find the direction from the entry point to the target
    VectorSubtract(ent->owner->client->arty_target, ent->owner->client->arty_entry, targetdir);
    VectorNormalize(targetdir);
    VectorAdd(ent->owner->client->arty_entry, targetdir, start);
	
   // check we have a clear line of fire
    tr_2 = gi.trace(start, NULL, NULL, ent->owner->client->arty_target, ent, MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA);

	// check to make sure we're not materializing in a solid
	if ( gi.pointcontents(start) == CONTENTS_SOLID || tr_2.fraction < 1.0 )
	{
		gi.cprintf(ent->owner, PRINT_HIGH, "Artillery fire was unsuccessful, sir!\n");
		return;
	}

	
//    gi.sound(ent, CHAN_AUTO, gi.soundindex(va("%s/arty/hit%i.wav", ent->client->resp.team_on->teamid, ent->client->arty_location)), 1, ATTN_NORM, 0);
  //		if (IsValidPlayer(ent))
	//		gi.sound(ent->owner, CHAN_AUTO, gi.soundindex(va("%s/arty/hit%i.wav", ent->owner->client->resp.team_on->teamid, 1)), 1, ATTN_NORM, 0);
     

	// fire away!

    /* old arty code
    fire_rocket(ent, start, targetdir, 700, 250, 300, 450);
    fire_rocket(ent, start, targetdir, 600, 450, 200, 430);
    fire_rocket(ent, start, targetdir, 400, 150, 400, 500);
    fire_rocket(ent, start, targetdir, 600, 210, 250, 500);
    fire_rocket(ent, start, targetdir, 300, 430, 200, 450);
    fire_rocket(ent, start, targetdir, 600, 240, 320, 480);
    */

	fire_airstrike(ent->owner, start, targetdir, 700, 250, 300, 450);
	VectorSet(tempvec, 8, 8, 0);
	VectorAdd(tempvec, start, tempvec);
    fire_airstrike(ent->owner, tempvec, targetdir, 600, 450, 200, 430);
	VectorSet(tempvec, 16, 16, 0);
	VectorAdd(tempvec, start, tempvec);
    fire_airstrike(ent->owner, tempvec, targetdir, 400, 150, 400, 500);
	VectorSet(tempvec, 24, 24, 0);
	VectorAdd(tempvec, start, tempvec);
    fire_airstrike(ent->owner, tempvec, targetdir, 600, 210, 250, 500);
	VectorSet(tempvec, 32, 32, 0);
	VectorAdd(tempvec, start, tempvec);
    fire_airstrike(ent->owner, tempvec, targetdir, 300, 430, 200, 450);
	VectorSet(tempvec, 40, 40, 0);
	VectorAdd(tempvec, start, tempvec);
    fire_airstrike(ent->owner, tempvec, targetdir, 600, 240, 320, 480);

	//fire_shell(ent, start, targetdir, 250, ((rand()%500)+900), 300, 75); 	
	
	gi.cprintf(ent->owner, PRINT_HIGH, "Artillery fire confirmed, sir!\n");


	ent->think = G_FreeEdict;
	ent->nextthink = level.time +.1;

	ent->owner->client->airstrike = NULL;

	ent->owner->client->arty_time_restrict = level.time + arty_time->value; // delay for user defined minutes

}

void Arty_Sound (edict_t *ent)
{


		if (!ent->owner ||
		!ent->owner->client ||
		!ent->owner->inuse ||
		!ent->owner->client->resp.team_on ||
		ent->owner->flyingnun)
	{
		G_FreeEdict(ent);
		return;
	}

	if (!ent->owner->client->airstrike)
	{
		G_FreeEdict(ent);
		return;
	}

	if (ent->owner->client->airstrike &&
		ent->owner->client->airstrike != ent)
	{
		G_FreeEdict(ent);
		return;
	}

	gi.sound(ent->owner, CHAN_AUTO, gi.soundindex(va("%s/arty/fire.wav",  ent->owner->client->resp.team_on->teamid)), 1, ATTN_NONE, 0);    
	ent->think = Think_Arty;
	ent->nextthink = level.time +3;

}


//faf
void airstrike_touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);
void Drop_Bomb(edict_t *ent)
{
	edict_t *bomb;
	vec3_t forward, bomb_orig;

	AngleVectors (ent->s.angles, forward, NULL, NULL);
	VectorMA (ent->s.origin, -33, forward, bomb_orig);


	bomb = G_Spawn();
	VectorCopy (bomb_orig, bomb->s.origin);

    bomb->movetype     = MOVETYPE_BOUNCE;
    bomb->clipmask     = MASK_SHOT;
    bomb->solid        = SOLID_BBOX;

	VectorClear (bomb->mins);
	VectorClear (bomb->maxs);

	bomb->owner        = ent->owner;
    
	bomb->touch        = airstrike_touch;

	bomb->nextthink    = level.time + 20;
    bomb->think        = G_FreeEdict;

	bomb->dmg          = 700;


	VectorCopy (ent->movedir, bomb->movedir);
	VectorCopy (ent->s.angles, bomb->s.angles);
//	bomb->s.angles[0]= bomb->s.angles[0] *-1;
//	bomb->s.angles[1]= bomb->s.angles[1] *-1;
//	VectorCopy (ent->velocity, bomb->velocity);
	

	bomb->s.modelindex = gi.modelindex ("models/objects/rocket/tris.md2");


	bomb->radius_dmg = 700;
	bomb->dmg_radius = 300;
	bomb->s.sound = gi.soundindex ("weapons/rockfly.wav");
	bomb->classname = "bomb";
	bomb->gravity = 1; // faf

	gi.linkentity (bomb);
}

void Plane_Fly_Off (edict_t *ent)
{
	ent->nextthink = level.time + 1;

	if (ent->s.angles[2] > 15)
	{
			VectorSet (ent->avelocity, 0, 0, -7);//faf
	}
	if (ent->s.angles[2] < -15) 
	{
			VectorSet (ent->avelocity, 0, 0, 7);//faf
	}

	if (ent->s.angles[2] > -1 && ent->s.angles[2] < 1)
	{
		VectorClear (ent->avelocity);
	}

	if (ent->leave_limbo_time < level.time - 20)
	{
		ent->nextthink= level.time + .1;
		ent->think = G_FreeEdict;
	}

}

void Plane_Fire (edict_t *ent)
{
	if (ent->leave_limbo_time < level.time - 20)
	{
		ent->nextthink= level.time + .1;
		ent->think = G_FreeEdict;
	}


	if (ent->count >= 4)
	{
		ent->think = Plane_Fly_Off;
		ent->nextthink = level.time + .1;

	}
	else
	{
		ent->nextthink = level.time +.2;
	}

	if (ent->count == 0  && ent->owner->client)
		gi.cprintf(ent->owner, PRINT_HIGH, "Airstrike confirmed, sir!\n");

	
	Drop_Bomb(ent);
	ent->count++;
}





void Plane_Think (edict_t *ent)
{
	vec3_t	length;
	float   distance;

	if (!ent->owner ||
		!ent->owner->client ||
		ent->flyingnun)
	
	{
		G_FreeEdict(ent);
		return;
	}



	VectorSubtract(ent->s.origin, ent->owner->client->arty_entry, length);
	distance = VectorLength(length);

	if (distance < 1000)
	{
		if (ent->s.angles[2] == 0 && ent->avelocity[2] == 0) //not spinning yet
		{
			if (random() < .5)
			{
				VectorSet (ent->avelocity, 0, 0, -10);//faf
			}
			else
			{
				VectorSet (ent->avelocity, 0, 0, 10);//faf
			}

		}
	}
	if (ent->s.angles[2] > 15) //don't tip too far
	{
			VectorSet (ent->avelocity, 0, 0, 0);//faf
	}
	if (ent->s.angles[2] < -15) 
	{
			VectorSet (ent->avelocity, 0, 0, 0);//faf
	}


//	gi.bprintf (PRINT_HIGH, "%s \n", vtos(ent->s.angles));

	if (distance < 200)
	{
		ent->think = Plane_Fire;
		ent->nextthink = level.time +.1;

		if (IsValidPlayer(ent))
			gi.sound(ent->owner, CHAN_AUTO, gi.soundindex(va("%s/arty/hit%i.wav", ent->owner->client->resp.team_on->teamid, 1)), 1, ATTN_NORM, 0);
	}
	else
		ent->nextthink = level.time +.1;


}

void plane_die(edict_t * self , edict_t * inflictor , edict_t * attacker , int damage , vec3_t point )
{
	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_EXPLOSION2);
	gi.WritePosition (self->s.origin);
	gi.multicast (self->s.origin, MULTICAST_PHS);
	G_FreeEdict(self);

}

//faf
void Spawn_Plane(edict_t *ent)
{
	//faf
	vec3_t	start;
	vec3_t	end;
	vec3_t left,right,forward,back;
	vec3_t temp, longest, direction, plane_start;

	float speed;

//	int i,j;

	trace_t	tr;

	edict_t *plane;

	if (IsValidPlayer(ent) && 
		ent->client && ent->client->arty_entry)
	{
		VectorCopy(ent->client->arty_entry, start);
	}
	else
		return;

 	VectorClear(longest);

	/*

 
	for(i=-1; i<=1 ;i++)  //faf:  goes through all direction n, ne, e, se etc.
	{
		for(j=-1; j<=1 ;j++)
		{
			if (i ==0 && j == 0)
				break;

			VectorSet (test, i, j, 0);
			VectorMA(start, 8192, test, end);

			tr = gi.trace(start, NULL, NULL, end, ent, MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA);


			VectorSubtract (tr.endpos, start, temp);

//			gi.bprintf (PRINT_HIGH, "%s    %f\n", vtos(test), VectorLength(temp)); 



			if (VectorLength(temp) > VectorLength(longest))
			{
				VectorCopy (temp, longest);
				VectorCopy (test, direction);
				direction[0]= -1 * direction[0];//reverse it
				direction[1]= -1 * direction[1];
//				VectorSet (direction, (-1 * test[0]), (-1 * test[1]), 0);//reversed
				VectorCopy (tr.endpos, plane_start);

			}
		}
	}*/

//	gi.bprintf (PRINT_HIGH, "%s\n", vtos(direction)); 




	VectorSet(left, 1, 0, 0);
	VectorSet(right, -1, 0, 0);
	VectorSet(forward, 0, 1, 0);
	VectorSet(back, 0, -1, 0);

	VectorMA(start, 8192, left, end);
	tr = gi.trace(start, NULL, NULL, end, ent, MASK_ALL);//MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA);

	VectorSubtract (tr.endpos, start, temp);
	if (VectorLength(temp) > VectorLength(longest) &&
		VectorLength(temp)< 8000)
	{
		VectorCopy (temp, longest);
		VectorCopy (right, direction);
		VectorCopy (tr.endpos, plane_start);

	}
	VectorMA(start, 8192, right, end);

	tr = gi.trace(start, NULL, NULL, end, ent, MASK_ALL);//MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA);
	
	VectorSubtract (tr.endpos, start, temp);
	if (VectorLength(temp) > VectorLength(longest) &&
		VectorLength(temp)< 8000)
	{
		VectorCopy (temp, longest);
		VectorCopy (tr.endpos, plane_start);
		VectorCopy (left, direction);
	}
	VectorMA(start, 8192, forward, end);

	tr = gi.trace(start, NULL, NULL, end, ent, MASK_ALL);//MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA);
	
	VectorSubtract (tr.endpos, start, temp);
	if (VectorLength(temp) > VectorLength(longest) &&
		VectorLength(temp)< 8000)
	{
		VectorCopy (temp, longest);
		VectorCopy (tr.endpos, plane_start);
		VectorCopy (back, direction);
	}
	VectorMA(start, 8192, back, end);

	tr = gi.trace(start, NULL, NULL, end, ent, MASK_ALL);//MASK_SHOT|CONTENTS_SLIME|CONTENTS_LAVA);
	
	VectorSubtract (tr.endpos, start, temp);
	if (VectorLength(temp) > VectorLength(longest) &&
		VectorLength(temp)< 8000)
	{
		VectorCopy (temp, longest);
		VectorCopy (tr.endpos, plane_start);
		VectorCopy (forward, direction);
	}
		

//	gi.bprintf (PRINT_HIGH, "%f .\n", VectorLength(longest)); 
//	gi.bprintf (PRINT_HIGH, "%s .\n", vtos(direction)); 

	plane = G_Spawn();
	plane->movetype = MOVETYPE_PUSH;
	plane->solid = SOLID_TRIGGER;
	plane->s.modelindex = gi.modelindex ("models/ships/viper/tris.md2");
	
//faf: requires models	
	plane->s.modelindex = gi.modelindex (va("models/ships/%splane/tris.md2", team_list[ent->client->resp.team_on->index]->teamid));

	plane->owner = ent;
	

	VectorClear (plane->mins);
	VectorClear (plane->maxs);

	/*
	plane->solid = SOLID_BBOX;
	VectorSet (plane->mins, -60, -60, -60);
	VectorSet (plane->maxs, 30, 30, 30);
	plane->health = 1000;
	plane->takedamage = DAMAGE_YES;
	plane->die = plane_die;
*/
	plane->classname = "plane";

	plane->think = Plane_Think;
	plane->nextthink = level.time +.1;

	VectorCopy (direction, plane->movedir);
	vectoangles (direction, plane->s.angles);


	if (VectorLength(longest) > 4000)
		speed = 800;
	else if (VectorLength(longest) > 2000)
		speed = 600;
	else
		speed = 450;

	VectorScale (direction, speed, plane->velocity);
//	VectorScale (direction, 450, plane->velocity);
//	VectorScale (direction, 50, plane->velocity);

	plane->s.sound = gi.soundindex ("dinant/tank.wav");
	
	VectorCopy (plane_start, plane->s.origin);

//	plane->s.origin[2] -= 1;


	plane->leave_limbo_time = level.time;

	gi.linkentity (plane);
	


}

//faf
void Airstrike_Plane_Launch(edict_t *ent)
{
	if (!ent->owner ||
		!ent->owner->client ||
		!ent->owner->inuse ||
		!ent->owner->client->resp.team_on ||
		ent->owner->flyingnun)
	{
		G_FreeEdict(ent);
		return;
	}

	if (!ent->owner->client->airstrike)
	{
		G_FreeEdict(ent);
		return;
	}

	if (ent->owner->client->airstrike &&
		ent->owner->client->airstrike != ent)
	{
		G_FreeEdict(ent);
		return;
	}

	if (!strcmp(ent->owner->client->resp.team_on->teamid, "usa"))
	{
		gi.sound(ent->owner, CHAN_AUTO, gi.soundindex(va("faf/p51f.wav")), 1, ATTN_NONE, 0);
	}
	else if (!strcmp(ent->owner->client->resp.team_on->teamid, "grm"))
	{
		gi.sound(ent->owner, CHAN_AUTO, gi.soundindex(va("airstrike/stuka.wav")), 1, ATTN_NONE, 0);
	}

	else
		gi.sound(ent->owner, CHAN_AUTO, gi.soundindex(va("%s/arty/fire.wav",  ent->owner->client->resp.team_on->teamid)), 1, ATTN_NONE, 0);    
	
	
	Spawn_Plane(ent->owner); //faf

	ent->think = G_FreeEdict;
	ent->nextthink = level.time +.1;

	ent->owner->client->airstrike = NULL;

	ent->owner->client->arty_time_restrict = level.time + arty_time->value; 


}




