/*
 * Decompiled with CFR 0.152.
 */
package klchateclipse;

import klchateclipse.IRCClient;
import klchateclipse.ViewPart;

public class ActionGroup {
    private IRCClient irc = null;
    private ViewPart frmMain = null;

    public ActionGroup(ViewPart frmmain, IRCClient irc) {
        this.irc = irc;
        this.frmMain = frmmain;
    }

    public void actionConnect() {
        this.irc.connect();
    }

    public void actionQuit() {
        this.irc.irc.doQuit("Bye");
        this.frmMain.display.dispose();
    }

    public void actionJoin(String chan) {
        this.frmMain.newTab(chan);
        this.irc.irc.doJoin(chan);
    }

    public void actionNick(String nick) {
        this.irc.irc.doNick(nick);
    }

    public void actionTyped(String text) {
        if (text.startsWith("/")) {
            String[] line = text.split(" ");
            if (line[0].equalsIgnoreCase("/join")) {
                this.actionJoin(line[1]);
            } else if (line[0].equalsIgnoreCase("/nick")) {
                this.actionNick(line[1]);
            }
        } else {
            String chan = this.frmMain.getShowingTab();
            this.irc.irc.doPrivmsg(chan, text);
            this.frmMain.tabMap.get(chan).output(String.valueOf('<') + this.irc.irc.getNick() + "> " + text);
        }
    }

    public void actionTest() {
        System.err.println(this.frmMain.getShowingTab());
    }
}

