// WMPUnlock.cpp : Defines the entry point for the application.
//

#include "StdAfx.h"
#include "resource.h"
#include "Registry.h"

void SetWMPSettings();

/*****************************************************************************

  WinMain

  ***************************************************************************/

int WINAPI WinMain(
    HINSTANCE hInstance,
    HINSTANCE hPrevInstance,
    LPWSTR lpCmdLine,
    int nCmdShow
    )
{
	// Wait for 15 seconds becase M600 starts to remove the registry value
	// related with WMP after booting.
	//
	// This value can be optimized after research.

	Sleep(15000);

    SetWMPSettings();

    return 0;
}

void SetWMPSettings()
{
	CRegistry reg;

	// HKEY_CLASSES_ROOT

	reg.SetValue(HKEY_CLASSES_ROOT, _T("MP3File\\DefaultIcon"),
		NULL, _T("wmplayer.exe,-2001"));
	reg.SetValue(HKEY_CLASSES_ROOT, _T("MP3File\\Shell\\Open\\Command"),
		NULL, _T("wmplayer.exe \"%1\""));

	// HKEY_LOCAL_MACHINE

	const TCHAR* szExt[] =
	{
		_T(".asf"), _T(".asx"), _T(".mp3"), _T(".wax"), _T(".wm"),
		_T(".wma"), _T(".wmp"), _T(".wmv"), _T(".wmx"), _T(".wsx"),
		_T(".wvx")
	};

	int nCount = sizeof (szExt) / sizeof (TCHAR*);

	for (int i = 0; i < nCount; i++)
	{
		TCHAR szExtKey[256];

		_tcscpy(szExtKey,
			_T("SOFTWARE\\Microsoft\\Multimedia\\WMPLAYER\\Extensions\\"));
		_tcscat(szExtKey, szExt[i]);

		reg.SetValue(HKEY_LOCAL_MACHINE, szExtKey, _T("Permissions"),
			(DWORD) 0x1f);
		reg.SetValue(HKEY_LOCAL_MACHINE, szExtKey, _T("Runtime"),
			(DWORD) 0x06);
	}
}

// end WMPUnlock.cpp
