/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.j2ee.kupload;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import net.kldp.j2ee.kupload.DataSection;
import net.kldp.j2ee.kupload.HeaderParser;
import net.kldp.j2ee.kupload.HttpServletUploadException;
import net.kldp.j2ee.kupload.MappedDiskFile;
import net.kldp.j2ee.kupload.Parameters;
import net.kldp.j2ee.kupload.UploadFiles;

public class HttpServletUpload {
    private UploadFiles uploadFiles = new UploadFiles();
    private Parameters parameters = new Parameters();
    private String encoding = "utf-8";
    private final int MEMORY_SIZE = 0x200000;

    public HttpServletUpload(HttpServletRequest httpServletRequest) throws HttpServletUploadException, IOException, ServletException {
        this.execute(httpServletRequest);
    }

    public HttpServletUpload(HttpServletRequest httpServletRequest, String string) throws HttpServletUploadException, IOException, ServletException {
        this.encoding = string;
        this.execute(httpServletRequest);
    }

    private void execute(HttpServletRequest httpServletRequest) throws IOException, HttpServletUploadException {
        DataSection dataSection = new DataSection((InputStream)httpServletRequest.getInputStream(), httpServletRequest.getContentLength(), 0x200000);
        while (this.seekNextDataSection(dataSection)) {
            String string = this.getDataHeader(dataSection);
            this.seekBinaryData(dataSection);
            if (HeaderParser.isFile(string)) {
                this.addFile(dataSection, string);
                continue;
            }
            this.parameters.putParameter(HeaderParser.getFieldName(string), this.getFieldValue(dataSection));
        }
    }

    public UploadFiles getUploadFiles() {
        return this.uploadFiles;
    }

    public Parameters getRequestParameters() {
        return this.parameters;
    }

    private boolean seekNextDataSection(DataSection dataSection) {
        if (dataSection.position == 0) {
            return this.seekFirstDataSection(dataSection);
        }
        if (dataSection.buffer.get(dataSection.position + 1) == 45) {
            return false;
        }
        if (dataSection.position + 2 >= dataSection.length) {
            dataSection.position += 2;
            return false;
        }
        return true;
    }

    private boolean seekFirstDataSection(DataSection dataSection) {
        byte by;
        while (dataSection.position < dataSection.length && (by = dataSection.buffer.get(dataSection.position)) != 13) {
            dataSection.boundary.append((char)by);
            ++dataSection.position;
        }
        ++dataSection.position;
        return dataSection.position != 2;
    }

    private String getFieldValue(DataSection dataSection) {
        return this.toString(dataSection, dataSection.start, dataSection.end);
    }

    private void addFile(DataSection dataSection, String string) {
        if (HeaderParser.isMacBinary(string)) {
            dataSection.start += 128;
        }
        MappedDiskFile mappedDiskFile = new MappedDiskFile(dataSection.buffer, dataSection.start, dataSection.end);
        mappedDiskFile.setFieldName(HeaderParser.getFieldName(string));
        mappedDiskFile.setContentType(HeaderParser.getContentType(string));
        mappedDiskFile.setFilePath(HeaderParser.getFilePath(string));
        this.uploadFiles.putFile(mappedDiskFile.getFieldName(), mappedDiskFile);
    }

    private void seekBinaryData(DataSection dataSection) {
        int n = 0;
        dataSection.start = dataSection.position;
        for (int i = dataSection.position; i <= dataSection.length; ++i) {
            if (dataSection.buffer.get(i) == (byte)dataSection.boundary.charAt(n)) {
                if (n == dataSection.boundary.length() - 1) {
                    dataSection.end = i - dataSection.boundary.length() - 2;
                    break;
                }
                ++n;
                continue;
            }
            n = 0;
        }
        dataSection.position = dataSection.end + dataSection.boundary.length() + 3;
    }

    private String getDataHeader(DataSection dataSection) {
        int n = dataSection.position;
        int n2 = 0;
        while (true) {
            if (dataSection.buffer.get(dataSection.position) == 13 && dataSection.buffer.get(dataSection.position + 2) == 13) {
                n2 = dataSection.position - 1;
                dataSection.position += 2;
                break;
            }
            ++dataSection.position;
        }
        dataSection.position += 2;
        return this.toString(dataSection, n, n2);
    }

    private String toString(DataSection dataSection, int n, int n2) {
        byte[] byArray = new byte[n2 - n + 1];
        dataSection.buffer.position(n);
        dataSection.buffer.get(byArray, 0, n2 - n + 1);
        try {
            return new String(byArray, this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.uploadFiles.finalize();
        this.uploadFiles = null;
        this.parameters = null;
    }
}

