package net.kldp.j2ee.kupload;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

/**
 * MultiPart 파싱을 위한 클래스
 */
final class DataSection {
	StringBuilder boundary = new StringBuilder();
	int position = 0;
	int start = 0;
	int end = 0;
	final int length;
	final ByteBuffer buffer;

	public DataSection(InputStream in, int length, int memSize) throws IOException, HttpServletUploadException {
		this.length = length;
		if (length < memSize)
			this.buffer = new TempByteBuffer(in, length).getBuffer();
		else
			this.buffer = new TempMappedByteBuffer(in, length).getBuffer();
	}
}