/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.j2ee.kupload;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

final class UploadFileInputStream
extends InputStream {
    private ByteBuffer buffer;
    private int position;
    private int size;
    private int mark = 0;

    public UploadFileInputStream(ByteBuffer byteBuffer, int n, int n2) {
        if (n + n2 > byteBuffer.capacity()) {
            throw new IllegalArgumentException("Size is large than buffer capacity.");
        }
        this.buffer = byteBuffer;
        this.position = n;
        this.size = n2;
    }

    @Override
    public int read() throws IOException {
        if (this.mark == this.size) {
            return -1;
        }
        this.mark(this.mark + 1);
        return this.buffer.getInt(this.position + this.mark - 1);
    }

    @Override
    public int available() throws IOException {
        return this.size - this.mark;
    }

    @Override
    public long skip(long l) throws IOException {
        int n = (int)l;
        if (this.mark + n > this.size) {
            int n2 = this.size - this.mark;
            this.mark(this.size);
            return n2;
        }
        this.mark(this.mark + n);
        return l;
    }

    @Override
    public synchronized void mark(int n) {
        this.mark = n;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.size - this.mark;
        if (n < 1) {
            return -1;
        }
        if (n < byArray.length) {
            this.buffer.position(this.position + this.mark);
            this.buffer.get(byArray, 0, n);
            this.mark(this.mark + n);
            return n;
        }
        this.buffer.position(this.position + this.mark);
        this.buffer.get(byArray, 0, byArray.length);
        this.mark(this.mark + byArray.length);
        return byArray.length;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.size - this.mark;
        if (n3 < 1) {
            return -1;
        }
        if (n3 < n2) {
            this.buffer.position(this.position + this.mark);
            this.buffer.get(byArray, n, n3);
            this.mark(this.mark + n3);
            return n3;
        }
        this.buffer.position(this.position + this.mark);
        this.buffer.get(byArray, n, n2);
        this.mark(this.mark + byArray.length);
        return n2;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.buffer.position(this.position);
        this.mark(0);
        super.reset();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.buffer = null;
    }
}

