package net.kldp.j2ee.kupload;

import static net.kldp.j2ee.kuploadold.HeaderParser.getContentType;
import static net.kldp.j2ee.kuploadold.HeaderParser.getFieldName;
import static net.kldp.j2ee.kuploadold.HeaderParser.getFilePath;
import static net.kldp.j2ee.kuploadold.HeaderParser.isFile;
import static net.kldp.j2ee.kuploadold.HeaderParser.isMacBinary;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

/**
 * MultiPart Upload 처리 클래스
 * 
 */
public class HttpServletUpload {
	private UploadFiles uploadFiles = new UploadFiles();
	private Parameters parameters = new Parameters();
	private String encoding = "utf-8";
	private final int MEMORY_SIZE = 1024 * 1024 * 2;

	/**
	 * MultiPart Upload 처리 클래스를 생성한다.
	 * 
	 * @param request
	 * @throws HttpServletUploadException
	 * @throws IOException
	 * @throws ServletException
	 */
	public HttpServletUpload(HttpServletRequest request) throws HttpServletUploadException, IOException,
			ServletException {
		execute(request);
	}

	/**
	 * MultiPart Upload 처리 클래스를 생성한다.
	 * 
	 * @param request
	 * @param encoding
	 * @throws HttpServletUploadException
	 * @throws IOException
	 * @throws ServletException
	 */
	public HttpServletUpload(HttpServletRequest request, String encoding) throws HttpServletUploadException,
			IOException, ServletException {
		this.encoding = encoding;
		execute(request);
	}

	/**
	 * 스트림을 파싱하여 파일업로드와 파라미터를 처리한다.
	 * 
	 * @param request
	 * @throws IOException
	 * @throws HttpServletUploadException
	 */
	private void execute(HttpServletRequest request) throws IOException, HttpServletUploadException {
		String dataHeader;
		DataSection section = new DataSection(request.getInputStream(), request.getContentLength(),
				MEMORY_SIZE);
		while (seekNextDataSection(section)) {
			dataHeader = getDataHeader(section);
			seekBinaryData(section);
			if (isFile(dataHeader))
				addFile(section, dataHeader);
			else
				addParameter(section, dataHeader);
		}
	}

	private void addParameter(DataSection section, String dataHeader) {
		parameters.putParameter(getFieldName(dataHeader), new FieldValue(section.getBuffer(), section.start,
				section.end, encoding));
	}

	/**
	 * 업로드된 바이너리 파일을 얻는다.
	 * 
	 * @return uploadFiles
	 */
	public UploadFiles getUploadFiles() {
		return uploadFiles;
	}

	/**
	 * Form의 field 파라미터를 얻는다.
	 * 
	 * @return parameters
	 */
	public Parameters getRequestParameters() {
		return parameters;
	}

	/**
	 * 다음 데이터 섹션을 검색한다.
	 * 
	 * @param section
	 * @return boolean
	 */
	private boolean seekNextDataSection(DataSection section) {
		if (section.position == 0)
			return seekFirstDataSection(section);
		else if (section.getPosition(section.position + 1) == 45)
			return false;
		else if (section.position + 2 >= section.length) {
			section.position += 2;
			return false;
		} else
			return true;
	}

	/**
	 * 스트림에서 첫번째 데이터 섹션을 찾는다.
	 * 
	 * @param section
	 */
	private boolean seekFirstDataSection(DataSection section) {
		byte b;
		while (section.position < section.length) {
			b = section.getPosition(section.position);
			if (b == 13)
				break;
			else
				section.boundary.append((char) b);
			section.position++;
		}
		section.position++;
		if (section.position == 2)
			return false;
		return true;
	}

	private void addFile(DataSection section, String dataHeader) {
		MappedDiskFile file;
		if (isMacBinary(dataHeader))
			section.start += 128;
		file = new MappedDiskFile(section.getBuffer(), section.start, section.end);
		file.setFieldName(getFieldName(dataHeader));
		file.setContentType(getContentType(dataHeader));
		file.setFilePath(getFilePath(dataHeader));
		uploadFiles.putFile(file.getFieldName(), file);
	}

	/**
	 * 스트림에서 데이터섹션을 찾는다.
	 * 
	 * @param section
	 */
	private void seekBinaryData(DataSection section) {
		int searchPosition = section.position;
		int keyPosition = 0;
		section.start = section.position;
		while (searchPosition <= section.length) {
			if (section.getPosition(searchPosition) == (byte) section.boundary.charAt(keyPosition)) {
				if (keyPosition == section.boundary.length() - 1) {
					section.end = searchPosition - section.boundary.length() - 2;
					break;
				}
				keyPosition++;
			} else {
				keyPosition = 0;
			}
			searchPosition++;
		}
		section.position = section.end + section.boundary.length() + 3;
	}

	/**
	 * 섹션에서 데이터헤더를 분리해낸다.
	 * 
	 * @param section
	 * @return dataHeader
	 */
	private String getDataHeader(DataSection section) {
		byte b;
		ByteData data = new ByteData();
		while (true) {
			b = section.getPosition(section.position);
			if (b == 13 && section.getPosition(section.position + 2) == 13) {
				section.position += 2;
				break;
			} else {
				data.add(b);
				section.position++;
			}
		}
		section.position += 2;
		return data.toString(encoding);
	}
}