#ifndef __FLAG_SETEEPROM
#define __FLAG_SETEEPROM
#endif //__FLAG_SETEEPROM

#define EERIE	3
#define EEMWE	2
#define EEWE	1
#define EERE	0

void EEPROM_write(unsigned int uiAddress, unsigned char ucData)
{
	while(EECR & (1<<EEWE));

	EEAR = uiAddress;
	EEDR = ucData;

	EECR |= (1 << EEMWE);
	EECR |= (1 << EEWE);
}


unsigned char EEPROM_read(unsigned int uiAddress)
{
	while(EECR & (1<<EEWE));

	EEAR = uiAddress;

	EECR |= (1 << EERE);

	return EEDR;
}

