#ifndef __FLAG_SETTWI
#define __FLAG_SETTWI
#endif //__FLAG_SETTWI

void setTWIPrescaler(int prescaler)
{
	switch (prescaler)
	{
		case	1:
			TWSR &= BM_1111_1100;
			break;
		case	4:
			TWSR &= BM_1111_1101;
			break;
		case	16:
			TWSR &= BM_1111_1110;
			break;
		case	64:
			TWSR &= BM_1111_1111;
			break;
	}
}

void setTWIBitRate(float bitrateKHz)
{
	//ATmega8 ͽƮ 167ʿ SCL ļ   ִ.
	//  128 237ʿ ִ.
	//⼭  , TWPS  ֺ Ÿ  ƴ϶, Ʈ ״θ ǹѴ.
	//, TWSR 0,1 Ʈ 00 Ǿ, ֺ 1ε, f_scl Ŀ 0 Ѵ.
	//
	//⼭ 16MHz  ý Ŭ ϰ ִٰ Ѵ.

	TWBR = (unsigned char)(((16000.0 / bitrateKHz) - 16.0)/( 1<<(2*(TWSR&0x03)+1) ));
}

void setTWISlaveAddress(char address)
{
	TWAR = address;
}

#define TWEA	6
void setTWIEnableAcknowledgeBit(void)
{
	TWCR |= 1 << TWEA;
	//TWCR |= BM_0100_0000;
}

#define TWEN	2
void setTWIEnable(void)
{
	TWCR |= 1 << TWEN;
	//TWCR |= BM_0000_0100;
}

void initTWI(void)
{
	setTWIPrescaler(1);
	setTWIBitRate(400.0);
	setTWIEnable();
}

