#ifndef __FLAG_SETUSART
#define __FLAG_SETUSART
#endif //__FLAG_SETUSART

void putSerial0(char data);
void putSerial1(char data);
void putSerial2(char data);
void putSerial3(char data);
void setSerial0RxInterruptEnable(void);
char getSerial0RxData(void);
void setSerial1RxInterruptEnable(void);
char getSerial1RxData(void);
void setSerial2RxInterruptEnable(void);
char getSerial2RxData(void);
void setSerial3RxInterruptEnable(void);
char getSerial3RxData(void);
void setSerial0RxInterruptDisable(void);
void setSerial1RxInterruptDisable(void);
void setSerial2RxInterruptDisable(void);
void setSerial3RxInterruptDisable(void);
void setSerial0RxEnable(void);
void setSerial0TxEnable(void);
void setSerial1RxEnable(void);
void setSerial1TxEnable(void);
void setSerial2RxEnable(void);
void setSerial2TxEnable(void);
void setSerial3RxEnable(void);
void setSerial3TxEnable(void);
void setSerial0RxDisable(void);
void setSerial0TxDisable(void);
void setSerial1RxDisable(void);
void setSerial1TxDisable(void);
void setSerial2RxDisable(void);
void setSerial2TxDisable(void);
void setSerial3RxDisable(void);
void setSerial3TxDisable(void);
void setSerial0Baudrate_16MHz(int baudrate);
void setSerial1Baudrate_16MHz(int baudrate);
void setSerial2Baudrate_16MHz(int baudrate);
void setSerial3Baudrate_16MHz(int baudrate);
char checkSerial0RXComplete(void);
char checkSerial1RXComplete(void);
char checkSerial2RXComplete(void);
char checkSerial3RXComplete(void);
char checkSerial0TXComplete(void);
char checkSerial1TXComplete(void);
char checkSerial2TXComplete(void);
char checkSerial3TXComplete(void);
///////////////////////////////// Ʒ Լ



void putSerial0(char data)
{
	//   ٸ.
	// Ʈũ : UDRE(UCSRA 5° Ʈ), USART Transmmit Complete Flag,    Ŭ ȴ.(0 ȴ.)
	while ( (UCSR0A & BM_0010_0000) == 0 );	
	// Ϳ ø Tx Shift Register ö󰡰,  ۵ȴ.
	UDR0 = data;
}

void putSerial1(char data)
{
	//   ٸ.
	// Ʈũ : UDRE(UCSRA 5° Ʈ), USART Transmmit Complete Flag,    Ŭ ȴ.(0 ȴ.)
	while ( (UCSR1A & BM_0010_0000) == 0 );	
	// Ϳ ø Tx Shift Register ö󰡰,  ۵ȴ.
	UDR1 = data;
}

void putSerial2(char data)
{
	//   ٸ.
	// Ʈũ : UDRE(UCSRA 5° Ʈ), USART Transmmit Complete Flag,    Ŭ ȴ.(0 ȴ.)
	while ( (UCSR2A & BM_0010_0000) == 0 );	
	// Ϳ ø Tx Shift Register ö󰡰,  ۵ȴ.
	UDR2 = data;
}

void putSerial3(char data)
{
	//   ٸ.
	// Ʈũ : UDRE(UCSRA 5° Ʈ), USART Transmmit Complete Flag,    Ŭ ȴ.(0 ȴ.)
	while ( (UCSR3A & BM_0010_0000) == 0 );	
	// Ϳ ø Tx Shift Register ö󰡰,  ۵ȴ.
	UDR3 = data;
}

void setSerial0RxInterruptEnable(void)
{
	//ͷƮ ɸ , ŵ 1Ʈ ڰ UDR0 ִ ̴.
	setSerial0RxEnable();
	UCSR0B |= BM_1000_0000;
}

char getSerial0RxData(void)
{
	return UDR0;
}

void setSerial1RxInterruptEnable(void)
{
	//ͷƮ ɸ , ŵ 1Ʈ ڰ UDR1 ִ ̴.
	setSerial1RxEnable();
	UCSR1B |= BM_1000_0000;
}

char getSerial1RxData(void)
{
	return UDR1;
}

void setSerial2RxInterruptEnable(void)
{
	//ͷƮ ɸ , ŵ 1Ʈ ڰ UDR0 ִ ̴.
	setSerial2RxEnable();
	UCSR2B |= BM_1000_0000;
}

char getSerial2RxData(void)
{
	return UDR2;
}

void setSerial3RxInterruptEnable(void)
{
	//ͷƮ ɸ , ŵ 1Ʈ ڰ UDR0 ִ ̴.
	setSerial3RxEnable();
	UCSR3B |= BM_1000_0000;
}

char getSerial3RxData(void)
{
	return UDR3;
}

void setSerial0RxInterruptDisable(void)
{
	UCSR0B &= BM_0111_1111;
}

void setSerial1RxInterruptDisable(void)
{
	UCSR1B &= BM_0111_1111;
}

void setSerial2RxInterruptDisable(void)
{
	UCSR2B &= BM_0111_1111;
}

void setSerial3RxInterruptDisable(void)
{
	UCSR3B &= BM_0111_1111;
}


void setSerial0RxEnable(void)
{
	UCSR0B |= BM_0001_0000;
}

void setSerial0TxEnable(void)
{
	UCSR0B |= BM_0000_1000;
}

void setSerial1RxEnable(void)
{
	UCSR1B |= BM_0001_0000;
}

void setSerial1TxEnable(void)
{
	UCSR1B |= BM_0000_1000;
}

void setSerial2RxEnable(void)
{
	UCSR2B |= BM_0001_0000;
}

void setSerial2TxEnable(void)
{
	UCSR2B |= BM_0000_1000;
}

void setSerial3RxEnable(void)
{
	UCSR3B |= BM_0001_0000;
}

void setSerial3TxEnable(void)
{
	UCSR3B |= BM_0000_1000;
}


void setSerial0RxDisable(void)
{
	UCSR0B &= BM_1110_1111;
}

void setSerial0TxDisable(void)
{
	UCSR0B &= BM_1111_0111;
}

void setSerial1RxDisable(void)
{
	UCSR1B &= BM_1110_1111;
}

void setSerial1TxDisable(void)
{
	UCSR1B &= BM_1111_0111;
}

void setSerial2RxDisable(void)
{
	UCSR2B &= BM_1110_1111;
}

void setSerial2TxDisable(void)
{
	UCSR0B &= BM_1111_0111;
}

void setSerial3RxDisable(void)
{
	UCSR3B &= BM_1110_1111;
}

void setSerial3TxDisable(void)
{
	UCSR3B &= BM_1111_0111;
}



void setSerial0Baudrate_16MHz(int baudrate)
{
	switch (baudrate)
	{
		case BR_2400:
			UBRR0H = BM_0000_0001;
			UBRR0L = BM_1010_0000;
			break;
		case BR_4800:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_1100_1111;
			break;
		case BR_9600:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0110_0111;
			break;
		case BR_14400:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0100_0100;
			break;
		case BR_19200:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0011_0011;
			break;
		case BR_38400:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0001_1001;
			break;
		case BR_56000:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0001_0001;
			break;
		case BR_57600:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0001_0000;
			break;
		case BR_76800:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0000_1100;
			break;
		case BR_115200:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0000_1000;
			break;
		case BR_230400:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0000_0011;
			break;
		case BR_250K:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0000_0011;
			break;
		case BR_500K:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0000_0001;
			break;
		case BR_1M:
			UBRR0H = BM_0000_0000;
			UBRR0L = BM_0000_0000;
			break;
defalut:
			break;
	}

}

void setSerial1Baudrate_16MHz(int baudrate)
{
	switch (baudrate)
	{
		case BR_2400:
			UBRR1H = BM_0000_0001;
			UBRR1L = BM_1010_0000;
			break;
		case BR_4800:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_1100_1111;
			break;
		case BR_9600:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0110_0111;
			break;
		case BR_14400:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0100_0100;
			break;
		case BR_19200:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0011_0011;
			break;
		case BR_38400:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0001_1001;
			break;
		case BR_56000:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0001_0001;
			break;
		case BR_57600:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0001_0000;
			break;
		case BR_76800:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0000_1100;
			break;
		case BR_115200:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0000_1000;
			break;
		case BR_230400:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0000_0011;
			break;
		case BR_250K:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0000_0011;
			break;
		case BR_500K:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0000_0001;
			break;
		case BR_1M:
			UBRR1H = BM_0000_0000;
			UBRR1L = BM_0000_0000;
			break;
defalut:
			break;
	}

}

void setSerial2Baudrate_16MHz(int baudrate)
{
	switch (baudrate)
	{
		case BR_2400:
			UBRR2H = BM_0000_0001;
			UBRR2L = BM_1010_0000;
			break;
		case BR_4800:
			UBRR2H = BM_0000_0000;
			UBRR2L = BM_1100_1111;
			break;
		case BR_9600:
			UBRR2H = BM_0000_0000;
			UBRR2L = BM_0110_0111;
			break;
		case BR_14400:
			UBRR2H = BM_0000_0000;
			UBRR2L = BM_0100_0100;
			break;
		case BR_19200:
			UBRR2H = BM_0000_0000;
			UBRR2L = BM_0011_0011;
			break;
		case BR_38400:
			UBRR2H = BM_0000_0000;
			UBRR2L = BM_0001_1001;
			break;
		case BR_56000:
			UBRR2H = BM_0000_0000;
			UBRR2L = BM_0001_0001;
			break;
		case BR_57600:
			UBRR2H = BM_0000_0000;
			UBRR2L = BM_0001_0000;
			break;
		case BR_76800:
			UBRR2H = BM_0000_0000;
			UBRR2L = BM_0000_1100;
			break;
		case BR_115200:
			UBRR2H = BM_0000_0000;
			UBRR2L = BM_0000_1000;
			break;
		case BR_230400:
			UBRR2H = BM_0000_0000;
			UBRR2L = BM_0000_0011;
			break;
		case BR_250K:
			UBRR2H = BM_0000_0000;
			UBRR2L = BM_0000_0011;
			break;
		case BR_500K:
			UBRR2H = BM_0000_0000;
			UBRR2L = BM_0000_0001;
			break;
		case BR_1M:
			UBRR2H = BM_0000_0000;
			UBRR2L = BM_0000_0000;
			break;
defalut:
			break;
	}

}

void setSerial3Baudrate_16MHz(int baudrate)
{
	switch (baudrate)
	{
		case BR_2400:
			UBRR3H = BM_0000_0001;
			UBRR3L = BM_1010_0000;
			break;
		case BR_4800:
			UBRR3H = BM_0000_0000;
			UBRR3L = BM_1100_1111;
			break;
		case BR_9600:
			UBRR3H = BM_0000_0000;
			UBRR3L = BM_0110_0111;
			break;
		case BR_14400:
			UBRR3H = BM_0000_0000;
			UBRR3L = BM_0100_0100;
			break;
		case BR_19200:
			UBRR3H = BM_0000_0000;
			UBRR3L = BM_0011_0011;
			break;
		case BR_38400:
			UBRR3H = BM_0000_0000;
			UBRR3L = BM_0001_1001;
			break;
		case BR_56000:
			UBRR3H = BM_0000_0000;
			UBRR3L = BM_0001_0001;
			break;
		case BR_57600:
			UBRR3H = BM_0000_0000;
			UBRR3L = BM_0001_0000;
			break;
		case BR_76800:
			UBRR3H = BM_0000_0000;
			UBRR3L = BM_0000_1100;
			break;
		case BR_115200:
			UBRR3H = BM_0000_0000;
			UBRR3L = BM_0000_1000;
			break;
		case BR_230400:
			UBRR3H = BM_0000_0000;
			UBRR3L = BM_0000_0011;
			break;
		case BR_250K:
			UBRR3H = BM_0000_0000;
			UBRR3L = BM_0000_0011;
			break;
		case BR_500K:
			UBRR3H = BM_0000_0000;
			UBRR3L = BM_0000_0001;
			break;
		case BR_1M:
			UBRR3H = BM_0000_0000;
			UBRR3L = BM_0000_0000;
			break;
defalut:
			break;
	}

}

char checkSerial0RXComplete(void)
{
	return UCSR0A & BM_1000_0000;
}

char checkSerial1RXComplete(void)
{
	return UCSR1A & BM_1000_0000;
}

char checkSerial2RXComplete(void)
{
	return UCSR2A & BM_1000_0000;
}

char checkSerial3RXComplete(void)
{
	return UCSR3A & BM_1000_0000;
}

char checkSerial0TXComplete(void)
{
	return UCSR0A & BM_0100_0000;
}

char checkSerial1TXComplete(void)
{
	return UCSR1A & BM_0100_0000;
}

char checkSerial2TXComplete(void)
{
	return UCSR2A & BM_0100_0000;
}

char checkSerial3TXComplete(void)
{
	return UCSR3A & BM_0100_0000;
}

