/*
 * ADC   ְ Ѵ.
 *
 *   ϴ  ʹ ׻ ʿ  ǰ Ѵ.
 * (ADLAR Ʈ 0 .)
 * 
 */
#ifndef _FLAG_SETADC
#define _FLAG_SETADC
#endif	//_FLAG_SETADC

#define	CONVERTINGTIME	30

void setAdcReferenceInternal(void);
void setAdcReferenceExtAVCC(void);
void setAdcReferenceExtAREF(void);
unsigned int getAdc0Value(void);
unsigned int getAdc1Value(void);
unsigned int getAdc2Value(void);
unsigned int getAdc3Value(void);
unsigned int getAdc4Value(void);
unsigned int getAdc5Value(void);
unsigned int getAdc6Value(void);
unsigned int getAdc7Value(void);
void setAdcSelect0(void);
void setAdcSelect1(void);
void setAdcSelect2(void);
void setAdcSelect3(void);
void setAdcSelect4(void);
void setAdcSelect4(void);
void setAdcSelect6(void);
void setAdcSelect7(void);
void waitAdcConverting(void);
void setAdcClockTo128(void);
void setAdcClockTo64(void);
void setAdcClockTo32(void);
void setAdcClockTo16(void);
void setAdcClockTo8(void);
void setAdcClockTo4(void);
void setAdcClockTo2(void);
void setAdcInterruptEnable(void);
void setAdcModeSingleRunning(void);
void setAdcModeFreeRunning(void);
void setAdcStart(void);
void setAdcDisable(void);
void setAdcEnable(void);
void initAdc(void);
void setAdcConversionStart(void);

void setAdcConversionStart(void)
{
	ADCSRA &= BM_1011_1111;
	ADCSRA |= BM_0100_0000;
}

void initAdc(void)
{
	ADMUX &= BM_1101_1111;	//ADLAR = 0, Data Ϳ Ǵ  ADCL 8Ʈ, ADCH 2Ʈ ȴ.

	setAdcEnable();

	setAdcReferenceInternal();

	setAdcModeFreeRunning();
	setAdcClockTo16();

	setAdcConversionStart();

}


void setAdcEnable(void)
{
	//ADC ϰ Ѵ.
	//A/D Converting ϱ  ݵ  Ѿ Ѵ.
	ADCSRA &= BM_0111_1111;
	ADCSRA |= BM_1000_0000;
}

void setAdcDisable(void)
{
	ADCSRA &= BM_0111_1111;
}

void setAdcStart(void)
{
	//FreeRunning  ù ° ȯ ۵ǰ,  ȯѴ.
	//SingleRunning    ȯϰ .
	//ADCSRA &= BM_1011_1111;
	ADCSRA |= BM_0100_0000;
}

void setAdcModeFreeRunning(void)
{
	ADCSRA &= BM_1101_1111;
	ADCSRA |= BM_0010_0000;
}

void setAdcModeSingleRunning(void)
{
	ADCSRA &= BM_1101_1111;
}

void setAdcInterruptEnable(void)
{
	ADCSRA |= BM_0000_1000;
}

void setAdcInterruptDisable(void)
{
	ADCSRA &= BM_1111_0111;
}

void setAdcClockTo2(void)
{
	//8 MHz øѴ.
	//ø/Ȧ ּ 1.5Ŭ, ִ 13.5Ŭ(ʺȯ)
	//ÿ ּ 13Ŭ, ִ 25Ŭ(ʺȯ)
	// Ŭ ʿ  Ͽ Ѵ.
	ADCSRA &= BM_1111_1000;
	ADCSRA |= BM_0000_0000;
}

void setAdcClockTo4(void)
{
	//4 MHz øѴ.
	//ø/Ȧ ּ 1.5Ŭ, ִ 13.5Ŭ(ʺȯ)
	//ÿ ּ 13Ŭ, ִ 25Ŭ(ʺȯ)
	// Ŭ ʿ  Ͽ Ѵ.
	ADCSRA &= BM_1111_1000;
	ADCSRA |= BM_0000_0010;
}

void setAdcClockTo8(void)
{
	//2 MHz øѴ.
	//ø/Ȧ ּ 1.5Ŭ, ִ 13.5Ŭ(ʺȯ)
	//ÿ ּ 13Ŭ, ִ 25Ŭ(ʺȯ)
	// Ŭ ʿ  Ͽ Ѵ.
	//10Ʈ ش   ؼ 50KHz~200KHz  Ŭ ȴ.
	ADCSRA &= BM_1111_1000;
	ADCSRA |= BM_0000_0011;
}

void setAdcClockTo16(void)
{
	//1 MHz øѴ.	16MHz Ŭ ÿ ̴.
	//ø/Ȧ ּ 1.5Ŭ, ִ 13.5Ŭ(ʺȯ)
	//ÿ ּ 13Ŭ, ִ 25Ŭ(ʺȯ)
	// Ŭ ʿ  Ͽ Ѵ.
	//10Ʈ ش   ؼ 50KHz~200KHz  Ŭ ȴ.
	ADCSRA &= BM_1111_1000;
	ADCSRA |= BM_0000_0100;
}

void setAdcClockTo32(void)
{
	//500 KHz øѴ.
	//ø/Ȧ ּ 1.5Ŭ, ִ 13.5Ŭ(ʺȯ)
	//ÿ ּ 13Ŭ, ִ 25Ŭ(ʺȯ)
	// Ŭ ʿ  Ͽ Ѵ.
	//10Ʈ ش   ؼ 50KHz~200KHz  Ŭ ȴ.
	ADCSRA &= BM_1111_1000;
	ADCSRA |= BM_0000_0101;
}

void setAdcClockTo64(void)
{
	//250KHz øѴ.
	//ø/Ȧ ּ 1.5Ŭ, ִ 13.5Ŭ(ʺȯ)
	//ÿ ּ 13Ŭ, ִ 25Ŭ(ʺȯ)
	// Ŭ ʿ  Ͽ Ѵ.
	//10Ʈ ش   ؼ 50KHz~200KHz  Ŭ ȴ.
	ADCSRA &= BM_1111_1000;
	ADCSRA |= BM_0000_0110;
}

void setAdcClockTo128(void)
{
	//125KHz øѴ.
	//ø/Ȧ ּ 1.5Ŭ, ִ 13.5Ŭ(ʺȯ)
	//ÿ ּ 13Ŭ, ִ 25Ŭ(ʺȯ)
	// Ŭ ʿ  Ͽ Ѵ.
	//10Ʈ ش   ؼ 50KHz~200KHz  Ŭ ȴ.
	ADCSRA &= BM_1111_1000;
	ADCSRA |= BM_0000_0111;
}


void setAdcSelect0(void)
{
	//ADMUX &= BM_1110_0000;
	//ADMUX |= BM_0000_0000;
	ADMUX = (ADMUX & BM_1110_0000) | BM_0000_0000;
}


void setAdcSelect1(void)
{
	//ADMUX &= BM_1110_0000;
	//ADMUX |= BM_0000_0001;
	ADMUX = (ADMUX & BM_1110_0000) | BM_0000_0001;
}

void setAdcSelect2(void)
{
	//ADMUX &= BM_1110_0000;
	//ADMUX |= BM_0000_0010;
	ADMUX = (ADMUX & BM_1110_0000) | BM_0000_0010;
}

void setAdcSelect3(void)
{
	//ADMUX &= BM_1110_0000;
	//ADMUX |= BM_0000_0011;
	ADMUX = (ADMUX & BM_1110_0000) | BM_0000_0011;
}

void setAdcSelect4(void)
{
	//ADMUX &= BM_1110_0000;
	//ADMUX |= BM_0000_0100;
	ADMUX = (ADMUX & BM_1110_0000) | BM_0000_0100;
}

void setAdcSelect5(void)
{
	//ADMUX &= BM_1110_0000;
	//ADMUX |= BM_0000_0101;
	ADMUX = (ADMUX & BM_1110_0000) | BM_0000_0101;
}

void setAdcSelect6(void)
{
	//ADMUX &= BM_1110_0000;
	//ADMUX |= BM_0000_0110;
	ADMUX = (ADMUX & BM_1110_0000) | BM_0000_0110;
}

void setAdcSelect7(void)
{
	//ADMUX &= BM_1110_0000;
	//ADMUX |= BM_0000_0111;
	ADMUX = (ADMUX & BM_1110_0000) | BM_0000_0111;
}

void waitAdcConverting(void)
{
	while( (ADCSRA & BM_0001_0000) != 0 );	//A/D   ٸ.
	ADCSRA |= BM_0001_0000;	//Ȯ ٲ´.	TODO:̰   ?
}


unsigned int getAdc0Value(void)
{
	//return = Vin / Vref * 1024
	setAdcSelect0();
	delay_us(CONVERTINGTIME);

	return (ADCL | (ADCH * 256));
}

unsigned int getAdc1Value(void)
{
	setAdcSelect1();
	delay_us(CONVERTINGTIME);

	return (ADCL | (ADCH * 256));
}


unsigned int getAdc2Value(void)
{
	setAdcSelect2();
	delay_us(CONVERTINGTIME);

	return (ADCL | (ADCH * 256));
}


unsigned int getAdc3Value(void)
{
	setAdcSelect3();
	delay_us(CONVERTINGTIME);

	return (ADCL | (ADCH * 256));
}


unsigned int getAdc4Value(void)
{
	setAdcSelect4();
	delay_us(CONVERTINGTIME);

	return (ADCL | (ADCH * 256));
}


unsigned int getAdc5Value(void)
{
	setAdcSelect5();
	delay_us(CONVERTINGTIME);

	return (ADCL | (ADCH * 256));
}


unsigned int getAdc6Value(void)
{
	setAdcSelect6();
	delay_us(CONVERTINGTIME);

	return (ADCL | (ADCH * 256));
}


unsigned int getAdc7Value(void)
{
	setAdcSelect7();
	delay_us(CONVERTINGTIME);

	return (ADCL | (ADCH * 256));
}

void setAdcReferenceExtAREF(void)
{
	//AREF   ֿ켱̴.
	ADMUX &= BM_0011_1111;
	ADMUX |= BM_0000_0000;
}

void setAdcReferenceExtAVCC(void)
{
	//̰   AREFڿ ׶ ̿ ĳнͰ ʿϴ.
	//AREF ɿ ٸ    AREF   ϰ Ǳ ̴.
	ADMUX &= BM_0011_1111;
	ADMUX |= BM_0100_0000;
}

void setAdcReferenceInternal(void)
{
	//  2.56V̴.
	//̰   AREFڿ ׶ ̿ ĳнͰ ʿϴ.
	//AREF ɿ ٸ    AREF   ϰ Ǳ ̴.
	
	//ADMUX &= BM_0011_1111;
	ADMUX |= BM_1100_0000;
}

