#ifndef __FLAG_PWM
#define __FLAG_PWM
#endif //__FLAG_PWM


/*
 * PWM  ߻ų  ְ Ѵ.
 */
 
#ifdef	_AVR_ATMEGA128
#include "mega128/settimer.h"
#ifdef	_PWM_BY_TIMER
/*
 * ̷ Ѵ.

 initTimer0();
 setTimer0ModeNormal();		//ī MAX 0xFF Ų.
 setTimer0OutputToggle();	//÷ζ   ۸Ѵ.
 setTimer0ClockUseExtern();	//ܺԷŬ Ѵ.
 setTimer0ClockTo8();		//ī Ŭ ý Ŭ 8ָ Ѵ.

 initTimer2();
 setTimer2ModeCTC();			//MAX OCR ̿ؼ Ѵ.
 setTimer2OutputToggle();	//÷ζ   ۸Ѵ.
 setTimer2ClockTo1024();		//ī Ŭ ý Ŭ 1024ָ Ѵ.
 setTimer2OCR(0xFF);			//MAX 0xFF Ѵ.

//1. Pwm ϱ  Լ
initTimer1();
setPwm123_8_period(20000);
setPwm1_8_width(2500);
setPwm2_8_width(5000);
setPwm3_8_width(7500);

initTimer3();
setPwm456_8_period(20000);
setPwm4_8_width(10000);
setPwm5_8_width(12500);
setPwm6_8_width(15000);


//2. ñ׳ Ŭ ϱ  Լ
//1) ֱ ϴ Լ
setTimer0ModeCTC();
setTimer0OutputToggle();
setTimer0ClockUseInternal();
setTimer0ClockTo64();
setTimer0OCR(0x3F);
setTimer0InterruptCompare();

*/

//Pwm  Ǵ Լ
#define PFCPWMWITHICR1	1
#define PFCPWMWITHICR3	2
unsigned int checkVariableRange (unsigned int, unsigned int, unsigned long int);
unsigned int calcPwm(int, char, unsigned long int );

void setPwm123_1_period(unsigned long int);	//setPwm[ ] Լ  Լ ޸ ּ    Ȯ .
void setPwm123_8_period(unsigned long int);
void setPwm123_64_period(unsigned long int);
void setPwm123_256_period(unsigned long int);
void setPwm123_1024_period(unsigned long int);

void setPwm456_1_period(unsigned long int);	
void setPwm456_8_period(unsigned long int);
void setPwm456_64_period(unsigned long int);
void setPwm456_256_period(unsigned long int);
void setPwm456_1024_period(unsigned long int);

void setPwm1_1_width(unsigned long int);	//PWM1 PB5
void setPwm1_8_width(unsigned long int);
void setPwm1_64_width(unsigned long int);
void setPwm1_256_width(unsigned long int);
void setPwm1_1024_width(unsigned long int);

void setPwm2_1_width(unsigned long int);	//PWM2 PB6
void setPwm2_8_width(unsigned long int);
void setPwm2_64_width(unsigned long int);
void setPwm2_256_width(unsigned long int);
void setPwm2_1024_width(unsigned long int);

void setPwm3_1_width(unsigned long int);	//PWM3 PB7
void setPwm3_8_width(unsigned long int);
void setPwm3_64_width(unsigned long int);
void setPwm3_256_width(unsigned long int);
void setPwm3_1024_width(unsigned long int);

void setPwm4_1_width(unsigned long int);	//PWM4 PE3
void setPwm4_8_width(unsigned long int);
void setPwm4_64_width(unsigned long int);
void setPwm4_256_width(unsigned long int);
void setPwm4_1024_width(unsigned long int);

void setPwm5_1_width(unsigned long int);	//PWM5 PE4
void setPwm5_8_width(unsigned long int);
void setPwm5_64_width(unsigned long int);
void setPwm5_256_width(unsigned long int);
void setPwm5_1024_width(unsigned long int);

void setPwm6_1_width(unsigned long int);	//PWM6 PE5
void setPwm6_8_width(unsigned long int);
void setPwm6_64_width(unsigned long int);
void setPwm6_256_width(unsigned long int);
void setPwm6_1024_width(unsigned long int);

/////////////////////////////////////////////////////////////////////////////////////
//PWM ÿ Ǵ Լ
//	-
/////////////////////////////////////////////////////////////////////////////////////
unsigned int checkVariableRange (unsigned int min, unsigned int max, unsigned long int var)
{
	// 
	//printf("min, max, var : %x(%d) %x(%d) %x(%d)\r\n", min, max, var);
	if ( var <= min )	//TODO:̰͵ Ʒ ִ밪 ϴ ó ľ . ÷ο .
	{
		return min;
	}

	if ( ( var / max ) >= 1 )	//÷   ؼ long int ޾Ƽ ó.
	{
		return max;
	}

	return (unsigned int)(var);
}

unsigned int calcPwm(int duty, char mode, unsigned long int time)
{
	//ֺ  ϴ ð Է ޾Ƽ
	//ش ֺ 忡 ϴ ð ǥ  ִ  ȯѴ.
	switch ( mode )
	{
		//TODO: PFCPWMWITHICR 尡 ƴ ٸ 忡 ؼ  Ǿ  ʴ.
		case PFCPWMWITHICR1:
		case PFCPWMWITHICR3:
			//Phased and Frequency Correct Pwm Mode
			switch (duty)
			{
				case 1:
					//ֺ 1
					return (unsigned int)(time * 8);
					return (unsigned int)( time << 4 ) ;
					break;
				case 8:
					//ֺ 8
					return (unsigned int)time;
					break;
				case 64:
					//ֺ 64
					//return (unsigned int)(( time / 4 ) /2) ;
					return (unsigned int)( time >> 3 ) ;
					break;
				case 256:
					//ֺ 256
					//return (unsigned int)(( time / 16 ) /2) ;
					return (unsigned int)( time >> 5 ) ;
					break;
				case 1024:
					//ֺ 1024
					//return (unsigned int)(( time / 64 ) /2) ;
					return (unsigned int)( time >> 7 ) ;
					break;



				default:
					break;
			}

			break;
		default:
			break;
	}
}

void setPwm1_1_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(1, PFCPWMWITHICR1, width);
	setTimer1AOCR(width);
}

void setPwm1_8_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(8, PFCPWMWITHICR1, width);
	setTimer1AOCR(width);
}

void setPwm1_64_width(unsigned long int width)
{
	width = calcPwm(64, PFCPWMWITHICR1, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer1AOCR(width);
}

void setPwm1_256_width(unsigned long int width)
{
	width = calcPwm(256, PFCPWMWITHICR1, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer1AOCR(width);
}

void setPwm1_1024_width(unsigned long int width)
{
	width = calcPwm(1024, PFCPWMWITHICR1, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer1AOCR(width);
}

void setPwm2_1_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(1, PFCPWMWITHICR1, width);
	setTimer1BOCR(width);
}

void setPwm2_8_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(8, PFCPWMWITHICR1, width);
	setTimer1BOCR(width);
}

void setPwm2_64_width(unsigned long int width)
{
	width = calcPwm(64, PFCPWMWITHICR1, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer1BOCR(width);
}

void setPwm2_256_width(unsigned long int width)
{
	width = calcPwm(256, PFCPWMWITHICR1, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer1BOCR(width);
}

void setPwm2_1024_width(unsigned long int width)
{
	width = calcPwm(1024, PFCPWMWITHICR1, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer1BOCR(width);
}

void setPwm3_1_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(1, PFCPWMWITHICR1, width);
	setTimer1COCR(width);
}

void setPwm3_8_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(8, PFCPWMWITHICR1, width);
	setTimer1COCR(width);
}

void setPwm3_64_width(unsigned long int width)
{
	width = calcPwm(64, PFCPWMWITHICR1, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer1COCR(width);
}

void setPwm3_256_width(unsigned long int width)
{
	width = calcPwm(256, PFCPWMWITHICR1, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer1COCR(width);
}

void setPwm3_1024_width(unsigned long int width)
{
	width = calcPwm(1024, PFCPWMWITHICR1, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer1COCR(width);
}

void setPwm4_1_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(1, PFCPWMWITHICR3, width);
	setTimer3AOCR(width);
}

void setPwm4_8_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(8, PFCPWMWITHICR3, width);
	setTimer3AOCR(width);
}

void setPwm4_64_width(unsigned long int width)
{
	width = calcPwm(64, PFCPWMWITHICR3, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer3AOCR(width);
}

void setPwm4_256_width(unsigned long int width)
{
	width = calcPwm(256, PFCPWMWITHICR3, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer3AOCR(width);
}

void setPwm4_1024_width(unsigned long int width)
{
	width = calcPwm(1024, PFCPWMWITHICR3, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer3AOCR(width);
}

void setPwm5_1_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(1, PFCPWMWITHICR3, width);
	setTimer3BOCR(width);
}

void setPwm5_8_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(8, PFCPWMWITHICR3, width);
	setTimer3BOCR(width);
}

void setPwm5_64_width(unsigned long int width)
{
	width = calcPwm(64, PFCPWMWITHICR3, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer3BOCR(width);
}

void setPwm5_256_width(unsigned long int width)
{
	width = calcPwm(256, PFCPWMWITHICR3, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer3BOCR(width);
}

void setPwm5_1024_width(unsigned long int width)
{
	width = calcPwm(1024, PFCPWMWITHICR3, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer3BOCR(width);
}

void setPwm6_1_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(1, PFCPWMWITHICR3, width);
	setTimer3COCR(width);
}

void setPwm6_8_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(8, PFCPWMWITHICR3, width);
	setTimer3COCR(width);
}

void setPwm6_64_width(unsigned long int width)
{
	width = calcPwm(64, PFCPWMWITHICR3, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer3COCR(width);
}

void setPwm6_256_width(unsigned long int width)
{
	width = calcPwm(256, PFCPWMWITHICR3, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer3COCR(width);
}

void setPwm6_1024_width(unsigned long int width)
{
	width = calcPwm(1024, PFCPWMWITHICR3, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer3COCR(width);
}


void setPwm123_1_period(unsigned long int period_us)
{
	//setPwm[ȣ]_[ֺ]_[]
	//
	//Ÿ̸1 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 1
	//16MHz 
	//ū ֱ  : 0 ~ 8191.875us
	// ֱ е : 0.125us (0.0625us * 2)
	//							(ִ밪  ʿ ϱ ̴.)
	//							(ڼ   Ʈ Ÿֵ̹ )
	setTimer1ModePFCPwmwithICR1();	//Phased and Frequency Correct Pwm Mode ϰ Ѵ.
	//  ICR  ö󰬴ٰ ٽ 0 .
	//16bits īͰ  ICR ι踸ŭ ȴٰ  ȴ.
	setTimer1AOutputNormalLow();	//⺻ 0, ȣ   1 Ѵ.
	setTimer1BOutputNormalLow();	//⺻ 0, ȣ   1 Ѵ.
	setTimer1COutputNormalLow();	//⺻ 0, ȣ   1 Ѵ.
	setTimer1ClockTo1();			//16MHz Ŭ Ѵ.( ʴ´.)
	//׷ Ŭ 0.0625us  ҿȴ.
	// ִ ū ֱ ( 0xFFFF * 2 -1 ) *0.0625  8191.8125 us ̴.
	//,  unsigned int  صξ  1us ̻ ּ  ؾѴ.
	//(̰ 1us Ϸ Ʈ ϴ 찡 Ŷ ؼ ġ ̴.)
	// Է period 16 ش.	(0.0625us * 16 = 1us)
	//׷ īͰ ϰ  ٽ ϱ  ϴ period ݸ ؾ Ѵ.
	//period_us = period_us * 8;	//    ó 8 Ѵ.
	//  ԼȭѴ.
	period_us = calcPwm(1, PFCPWMWITHICR1, period_us);		
	//ū ֱⰪ ϴ ICR  High Low  8Ʈ 16Ʈ̱ , ִ밪  ʵ Ѵ.
	//ִ밪 0xFFFF(65536-1)̴.
	period_us = checkVariableRange(0, 0xFFFF, period_us);
	setTimer1ICR1(period_us);		//⼭ ū ֱ⸦ Ѵ.
}

void setPwm123_8_period(unsigned long int period_us)
{
	//Ÿ̸1 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 8
	//16MHz 
	//ū ֱ  : 0 ~ 65535us
	// ֱ е : 1us (0.5us * 2)
	//
	//  setPwm123_1_period ּ Ǿ ִ.
	setTimer1ModePFCPwmwithICR1();
	setTimer1AOutputNormalLow();
	setTimer1BOutputNormalLow();
	setTimer1COutputNormalLow();
	setTimer1ClockTo8();
	period_us = calcPwm(8, PFCPWMWITHICR1, period_us);
	period_us = checkVariableRange(0, 0xFFFF, period_us);
	setTimer1ICR1(period_us);
}

void setPwm123_64_period(unsigned long int period_us)
{
	//Ÿ̸1 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 64
	//16MHz 
	//ū ֱ  : 0 ~ 524280us	( 1/16MHz*64 * 2 * 0xFFFF )
	//е : 8us (4us * 2) 
	//
	//  setPwm123_1_period ּ Ǿ ִ.
	setTimer1ModePFCPwmwithICR1();
	setTimer1AOutputNormalLow();
	setTimer1BOutputNormalLow();
	setTimer1COutputNormalLow();
	setTimer1ClockTo64();
	//printf("period_us : %x\r\n", period_us>>16, period_us);
	period_us = calcPwm(64, PFCPWMWITHICR1, period_us);		//524272us  ϸ, 0xFFFE ; .
	period_us = checkVariableRange(0, 0xFFFF, period_us);	//0xFFFE ϸ, 0xFFFE  ; .
	//printf("period_us : %x\r\n", period_us);
	setTimer1ICR1(period_us);
}

void setPwm123_256_period(unsigned long int period_us)
{
	//Ÿ̸1 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 64
	//16MHz 
	//ū ֱ  : 0 ~ 2097120us	( 1/16MHz*256 * 2 * 0xFFFF )
	//е : 32us (1/16MHz*256 * 2) 
	//
	//  setPwm123_1_period ּ Ǿ ִ.
	setTimer1ModePFCPwmwithICR1();
	setTimer1AOutputNormalLow();
	setTimer1BOutputNormalLow();
	setTimer1COutputNormalLow();
	setTimer1ClockTo256();
	//printf("period_us : %x\r\n", period_us>>16, period_us);
	period_us = calcPwm(256, PFCPWMWITHICR1, period_us);
	period_us = checkVariableRange(0, 0xFFFF, period_us);
	//printf("period_us : %x\r\n", period_us);
	setTimer1ICR1(period_us);
}

void setPwm123_1024_period(unsigned long int period_us)
{
	//Ÿ̸1 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 64
	//16MHz 
	//ū ֱ  : 0 ~ 8388480us (8.388480s)	( 1/16MHz*1024 * 2 * 0xFFFF )
	//е : 128us (1/16MHz*256 * 2) 
	//
	//  setPwm123_1_period ּ Ǿ ִ.
	setTimer1ModePFCPwmwithICR1();
	setTimer1AOutputNormalLow();
	setTimer1BOutputNormalLow();
	setTimer1COutputNormalLow();
	setTimer1ClockTo1024();
	//printf("period_us : %x\r\n", period_us>>16, period_us);
	period_us = calcPwm(1024, PFCPWMWITHICR1, period_us);
	period_us = checkVariableRange(0, 0xFFFF, period_us);
	//printf("period_us : %x\r\n", period_us);
	setTimer1ICR1(period_us);
}

void setPwm456_1_period(unsigned long int period_us)
{
	//setPwm[ȣ]_[ֺ]_[]
	//
	//Ÿ̸3 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 1
	//16MHz 
	//ū ֱ  : 0 ~ 8191.875us
	// ֱ е : 0.125us (0.0625us * 2)
	//							(ִ밪  ʿ ϱ ̴.)
	//							(ڼ   Ʈ Ÿֵ̹ )
	setTimer3ModePFCPwmwithICR3();	//Phased and Frequency Correct Pwm Mode ϰ Ѵ.
	//  ICR  ö󰬴ٰ ٽ 0 .
	//16bits īͰ  ICR ι踸ŭ ȴٰ  ȴ.
	setTimer3AOutputNormalLow();	//⺻ 0, ȣ   1 Ѵ.
	setTimer3BOutputNormalLow();	//⺻ 0, ȣ   1 Ѵ.
	setTimer3COutputNormalLow();	//⺻ 0, ȣ   1 Ѵ.
	setTimer3ClockTo1();			//16MHz Ŭ Ѵ.( ʴ´.)
	//׷ Ŭ 0.0625us  ҿȴ.
	// ִ ū ֱ ( 0xFFFF * 2 -1 ) *0.0625  8191.8125 us ̴.
	//,  unsigned int  صξ  1us ̻ ּ  ؾѴ.
	//(̰ 1us Ϸ Ʈ ϴ 찡 Ŷ ؼ ġ ̴.)
	// Է period 16 ش.	(0.0625us * 16 = 1us)
	//׷ īͰ ϰ  ٽ ϱ  ϴ period ݸ ؾ Ѵ.
	//period_us = period_us * 8;	//    ó 8 Ѵ.
	//  ԼȭѴ.
	period_us = calcPwm(1, PFCPWMWITHICR3, period_us);		
	//ū ֱⰪ ϴ ICR  High Low  8Ʈ 16Ʈ̱ , ִ밪  ʵ Ѵ.
	//ִ밪 0xFFFF(65536-1)̴.
	period_us = checkVariableRange(0, 0xFFFF, period_us);
	setTimer3ICR3(period_us);		//⼭ ū ֱ⸦ Ѵ.
}

void setPwm456_8_period(unsigned long int period_us)
{
	//Ÿ̸3 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 8
	//16MHz 
	//ū ֱ  : 0 ~ 65535us
	// ֱ е : 1us (0.5us * 2)
	//
	//  setPwm456_1_period ּ Ǿ ִ.
	setTimer3ModePFCPwmwithICR3();
	setTimer3AOutputNormalLow();
	setTimer3BOutputNormalLow();
	setTimer3COutputNormalLow();
	setTimer3ClockTo8();
	period_us = calcPwm(8, PFCPWMWITHICR3, period_us);
	period_us = checkVariableRange(0, 0xFFFF, period_us);
	setTimer3ICR3(period_us);
}

void setPwm456_64_period(unsigned long int period_us)
{
	//Ÿ̸3 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 64
	//16MHz 
	//ū ֱ  : 0 ~ 524280us	( 1/16MHz*64 * 2 * 0xFFFF )
	//е : 8us (4us * 2) 
	//
	//  setPwm456_1_period ּ Ǿ ִ.
	setTimer3ModePFCPwmwithICR3();
	setTimer3AOutputNormalLow();
	setTimer3BOutputNormalLow();
	setTimer3COutputNormalLow();
	setTimer3ClockTo64();
	//printf("period_us : %x\r\n", period_us>>16, period_us);
	period_us = calcPwm(64, PFCPWMWITHICR3, period_us);		//524272us  ϸ, 0xFFFE ; .
	period_us = checkVariableRange(0, 0xFFFF, period_us);	//0xFFFE ϸ, 0xFFFE  ; .
	//printf("period_us : %x\r\n", period_us);
	setTimer3ICR3(period_us);
}

void setPwm456_256_period(unsigned long int period_us)
{
	//Ÿ̸3 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 64
	//16MHz 
	//ū ֱ  : 0 ~ 2097120us	( 1/16MHz*256 * 2 * 0xFFFF )
	//е : 32us (1/16MHz*256 * 2) 
	//
	//  setPwm456_1_period ּ Ǿ ִ.
	setTimer3ModePFCPwmwithICR3();
	setTimer3AOutputNormalLow();
	setTimer3BOutputNormalLow();
	setTimer3COutputNormalLow();
	setTimer3ClockTo256();
	//printf("period_us : %x\r\n", period_us>>16, period_us);
	period_us = calcPwm(256, PFCPWMWITHICR3, period_us);
	period_us = checkVariableRange(0, 0xFFFF, period_us);
	//printf("period_us : %x\r\n", period_us);
	setTimer3ICR3(period_us);
}

void setPwm456_1024_period(unsigned long int period_us)
{
	//Ÿ̸3 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 64
	//16MHz 
	//ū ֱ  : 0 ~ 8388480us (8.388480s)	( 1/16MHz*1024 * 2 * 0xFFFF )
	//е : 128us (1/16MHz*256 * 2) 
	//
	//  setPwm456_1_period ּ Ǿ ִ.
	setTimer3ModePFCPwmwithICR3();
	setTimer3AOutputNormalLow();
	setTimer3BOutputNormalLow();
	setTimer3COutputNormalLow();
	setTimer3ClockTo1024();
	//printf("period_us : %x\r\n", period_us>>16, period_us);
	period_us = calcPwm(1024, PFCPWMWITHICR3, period_us);
	period_us = checkVariableRange(0, 0xFFFF, period_us);
	//printf("period_us : %x\r\n", period_us);
	setTimer3ICR3(period_us);
}

/////////////////////////////////////////////////////////////////////////////////////
//PWM ÿ Ǵ Լ
//	-
/////////////////////////////////////////////////////////////////////////////////////
#endif	// _PWM_BY_TIMER
#ifdef _PWM_BY_TIMERINTERRUPT
#endif	// _PWM_BY_TIMERINTERRUPT
#endif	// _AVR_ATMEGA128



#ifdef	_AVR_ATMEGA2560
#include "mega2560/settimer.h"
#ifdef	_PWM_BY_TIMER
/*
 * ̷ Ѵ.

 initTimer0();
 setTimer0ModeNormal();		//ī MAX 0xFF Ų.
 setTimer0OutputToggle();	//÷ζ   ۸Ѵ.
 setTimer0ClockUseExtern();	//ܺԷŬ Ѵ.
 setTimer0ClockTo8();		//ī Ŭ ý Ŭ 8ָ Ѵ.

 initTimer2();
 setTimer2ModeCTC();			//MAX OCR ̿ؼ Ѵ.
 setTimer2OutputToggle();	//÷ζ   ۸Ѵ.
 setTimer2ClockTo1024();		//ī Ŭ ý Ŭ 1024ָ Ѵ.
 setTimer2OCR(0xFF);			//MAX 0xFF Ѵ.

//1. Pwm ϱ  Լ
initTimer1();
setPwm123_8_period(20000);
setPwm1_8_width(2500);
setPwm2_8_width(5000);
setPwm3_8_width(7500);

initTimer3();
setPwm456_8_period(20000);
setPwm4_8_width(10000);
setPwm5_8_width(12500);
setPwm6_8_width(15000);


//2. ñ׳ Ŭ ϱ  Լ
//1) ֱ ϴ Լ
setTimer0ModeCTC();
setTimer0OutputToggle();
setTimer0ClockUseInternal();
setTimer0ClockTo64();
setTimer0OCR(0x3F);
setTimer0InterruptCompare();

*/

//Pwm  Ǵ Լ
#define PFCPWMWITHICR1	1
#define PFCPWMWITHICR3	2
unsigned int checkVariableRange (unsigned int, unsigned int, unsigned long int);
unsigned int calcPwm(int, char, unsigned long int );

void setPwm123_1_period(unsigned long int);	//setPwm[ ] Լ  Լ ޸ ּ    Ȯ .
void setPwm123_8_period(unsigned long int);
void setPwm123_64_period(unsigned long int);
void setPwm123_256_period(unsigned long int);
void setPwm123_1024_period(unsigned long int);

void setPwm456_1_period(unsigned long int);	
void setPwm456_8_period(unsigned long int);
void setPwm456_64_period(unsigned long int);
void setPwm456_256_period(unsigned long int);
void setPwm456_1024_period(unsigned long int);

void setPwm1_1_width(unsigned long int);	//PWM1 PB5
void setPwm1_8_width(unsigned long int);
void setPwm1_64_width(unsigned long int);
void setPwm1_256_width(unsigned long int);
void setPwm1_1024_width(unsigned long int);

void setPwm2_1_width(unsigned long int);	//PWM2 PB6
void setPwm2_8_width(unsigned long int);
void setPwm2_64_width(unsigned long int);
void setPwm2_256_width(unsigned long int);
void setPwm2_1024_width(unsigned long int);

void setPwm3_1_width(unsigned long int);	//PWM3 PB7
void setPwm3_8_width(unsigned long int);
void setPwm3_64_width(unsigned long int);
void setPwm3_256_width(unsigned long int);
void setPwm3_1024_width(unsigned long int);

void setPwm4_1_width(unsigned long int);	//PWM4 PE3
void setPwm4_8_width(unsigned long int);
void setPwm4_64_width(unsigned long int);
void setPwm4_256_width(unsigned long int);
void setPwm4_1024_width(unsigned long int);

void setPwm5_1_width(unsigned long int);	//PWM5 PE4
void setPwm5_8_width(unsigned long int);
void setPwm5_64_width(unsigned long int);
void setPwm5_256_width(unsigned long int);
void setPwm5_1024_width(unsigned long int);

void setPwm6_1_width(unsigned long int);	//PWM6 PE5
void setPwm6_8_width(unsigned long int);
void setPwm6_64_width(unsigned long int);
void setPwm6_256_width(unsigned long int);
void setPwm6_1024_width(unsigned long int);

/////////////////////////////////////////////////////////////////////////////////////
//PWM ÿ Ǵ Լ
//	-
/////////////////////////////////////////////////////////////////////////////////////
unsigned int checkVariableRange (unsigned int min, unsigned int max, unsigned long int var)
{
	// 
	//printf("min, max, var : %x(%d) %x(%d) %x(%d)\r\n", min, max, var);
	if ( var <= min )	//TODO:̰͵ Ʒ ִ밪 ϴ ó ľ . ÷ο .
	{
		return min;
	}

	if ( ( var / max ) >= 1 )	//÷   ؼ long int ޾Ƽ ó.
	{
		return max;
	}

	return (unsigned int)(var);
}

unsigned int calcPwm(int duty, char mode, unsigned long int time)
{
	//ֺ  ϴ ð Է ޾Ƽ
	//ش ֺ 忡 ϴ ð ǥ  ִ  ȯѴ.
	switch ( mode )
	{
		//TODO: PFCPWMWITHICR 尡 ƴ ٸ 忡 ؼ  Ǿ  ʴ.
		case PFCPWMWITHICR1:
		case PFCPWMWITHICR3:
			//Phased and Frequency Correct Pwm Mode
			switch (duty)
			{
				case 1:
					//ֺ 1
					return time * 8;
					return (unsigned int)( time << 4 ) ;
					break;
				case 8:
					//ֺ 8
					return (unsigned int)time;
					break;
				case 64:
					//ֺ 64
					//return (unsigned int)(( time / 4 ) /2) ;
					return (unsigned int)( time >> 3 ) ;
					break;
				case 256:
					//ֺ 256
					//return (unsigned int)(( time / 16 ) /2) ;
					return (unsigned int)( time >> 5 ) ;
					break;
				case 1024:
					//ֺ 1024
					//return (unsigned int)(( time / 64 ) /2) ;
					return (unsigned int)( time >> 7 ) ;
					break;



				default:
					break;
			}

			break;
		default:
			break;
	}
}

void setPwm1_1_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(1, PFCPWMWITHICR1, width);
	setTimer1AOCR(width);
}

void setPwm1_8_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(8, PFCPWMWITHICR1, width);
	setTimer1AOCR(width);
}

void setPwm1_64_width(unsigned long int width)
{
	width = calcPwm(64, PFCPWMWITHICR1, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer1AOCR(width);
}

void setPwm1_256_width(unsigned long int width)
{
	width = calcPwm(256, PFCPWMWITHICR1, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer1AOCR(width);
}

void setPwm1_1024_width(unsigned long int width)
{
	width = calcPwm(1024, PFCPWMWITHICR1, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer1AOCR(width);
}

void setPwm2_1_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(1, PFCPWMWITHICR1, width);
	setTimer1BOCR(width);
}

void setPwm2_8_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(8, PFCPWMWITHICR1, width);
	setTimer1BOCR(width);
}

void setPwm2_64_width(unsigned long int width)
{
	width = calcPwm(64, PFCPWMWITHICR1, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer1BOCR(width);
}

void setPwm2_256_width(unsigned long int width)
{
	width = calcPwm(256, PFCPWMWITHICR1, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer1BOCR(width);
}

void setPwm2_1024_width(unsigned long int width)
{
	width = calcPwm(1024, PFCPWMWITHICR1, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer1BOCR(width);
}

void setPwm3_1_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(1, PFCPWMWITHICR1, width);
	setTimer1COCR(width);
}

void setPwm3_8_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(8, PFCPWMWITHICR1, width);
	setTimer1COCR(width);
}

void setPwm3_64_width(unsigned long int width)
{
	width = calcPwm(64, PFCPWMWITHICR1, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer1COCR(width);
}

void setPwm3_256_width(unsigned long int width)
{
	width = calcPwm(256, PFCPWMWITHICR1, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer1COCR(width);
}

void setPwm3_1024_width(unsigned long int width)
{
	width = calcPwm(1024, PFCPWMWITHICR1, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer1COCR(width);
}

void setPwm4_1_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(1, PFCPWMWITHICR3, width);
	setTimer3AOCR(width);
}

void setPwm4_8_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(8, PFCPWMWITHICR3, width);
	setTimer3AOCR(width);
}

void setPwm4_64_width(unsigned long int width)
{
	width = calcPwm(64, PFCPWMWITHICR3, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer3AOCR(width);
}

void setPwm4_256_width(unsigned long int width)
{
	width = calcPwm(256, PFCPWMWITHICR3, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer3AOCR(width);
}

void setPwm4_1024_width(unsigned long int width)
{
	width = calcPwm(1024, PFCPWMWITHICR3, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer3AOCR(width);
}

void setPwm5_1_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(1, PFCPWMWITHICR3, width);
	setTimer3BOCR(width);
}

void setPwm5_8_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(8, PFCPWMWITHICR3, width);
	setTimer3BOCR(width);
}

void setPwm5_64_width(unsigned long int width)
{
	width = calcPwm(64, PFCPWMWITHICR3, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer3BOCR(width);
}

void setPwm5_256_width(unsigned long int width)
{
	width = calcPwm(256, PFCPWMWITHICR3, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer3BOCR(width);
}

void setPwm5_1024_width(unsigned long int width)
{
	width = calcPwm(1024, PFCPWMWITHICR3, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer3BOCR(width);
}

void setPwm6_1_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(1, PFCPWMWITHICR3, width);
	setTimer3COCR(width);
}

void setPwm6_8_width(unsigned long int width)
{
	width = checkVariableRange(0, 0xFFFF, width);
	width = calcPwm(8, PFCPWMWITHICR3, width);
	setTimer3COCR(width);
}

void setPwm6_64_width(unsigned long int width)
{
	width = calcPwm(64, PFCPWMWITHICR3, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer3COCR(width);
}

void setPwm6_256_width(unsigned long int width)
{
	width = calcPwm(256, PFCPWMWITHICR3, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer3COCR(width);
}

void setPwm6_1024_width(unsigned long int width)
{
	width = calcPwm(1024, PFCPWMWITHICR3, width);
	width = checkVariableRange(0, 0xFFFF, width);
	setTimer3COCR(width);
}


void setPwm123_1_period(unsigned long int period_us)
{
	//setPwm[ȣ]_[ֺ]_[]
	//
	//Ÿ̸1 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 1
	//16MHz 
	//ū ֱ  : 0 ~ 8191.875us
	// ֱ е : 0.125us (0.0625us * 2)
	//							(ִ밪  ʿ ϱ ̴.)
	//							(ڼ   Ʈ Ÿֵ̹ )
	setTimer1ModePFCPwmwithICR1();	//Phased and Frequency Correct Pwm Mode ϰ Ѵ.
	//  ICR  ö󰬴ٰ ٽ 0 .
	//16bits īͰ  ICR ι踸ŭ ȴٰ  ȴ.
	setTimer1AOutputNormalLow();	//⺻ 0, ȣ   1 Ѵ.
	setTimer1BOutputNormalLow();	//⺻ 0, ȣ   1 Ѵ.
	setTimer1COutputNormalLow();	//⺻ 0, ȣ   1 Ѵ.
	setTimer1ClockTo1();			//16MHz Ŭ Ѵ.( ʴ´.)
	//׷ Ŭ 0.0625us  ҿȴ.
	// ִ ū ֱ ( 0xFFFF * 2 -1 ) *0.0625  8191.8125 us ̴.
	//,  unsigned int  صξ  1us ̻ ּ  ؾѴ.
	//(̰ 1us Ϸ Ʈ ϴ 찡 Ŷ ؼ ġ ̴.)
	// Է period 16 ش.	(0.0625us * 16 = 1us)
	//׷ īͰ ϰ  ٽ ϱ  ϴ period ݸ ؾ Ѵ.
	//period_us = period_us * 8;	//    ó 8 Ѵ.
	//  ԼȭѴ.
	period_us = calcPwm(1, PFCPWMWITHICR1, period_us);		
	//ū ֱⰪ ϴ ICR  High Low  8Ʈ 16Ʈ̱ , ִ밪  ʵ Ѵ.
	//ִ밪 0xFFFF(65536-1)̴.
	period_us = checkVariableRange(0, 0xFFFF, period_us);
	setTimer1ICR1(period_us);		//⼭ ū ֱ⸦ Ѵ.
}

void setPwm123_8_period(unsigned long int period_us)
{
	//Ÿ̸1 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 8
	//16MHz 
	//ū ֱ  : 0 ~ 65535us
	// ֱ е : 1us (0.5us * 2)
	//
	//  setPwm123_1_period ּ Ǿ ִ.
	setTimer1ModePFCPwmwithICR1();
	setTimer1AOutputNormalLow();
	setTimer1BOutputNormalLow();
	setTimer1COutputNormalLow();
	setTimer1ClockTo8();
	period_us = calcPwm(8, PFCPWMWITHICR1, period_us);
	period_us = checkVariableRange(0, 0xFFFF, period_us);
	setTimer1ICR1(period_us);
}

void setPwm123_64_period(unsigned long int period_us)
{
	//Ÿ̸1 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 64
	//16MHz 
	//ū ֱ  : 0 ~ 524280us	( 1/16MHz*64 * 2 * 0xFFFF )
	//е : 8us (4us * 2) 
	//
	//  setPwm123_1_period ּ Ǿ ִ.
	setTimer1ModePFCPwmwithICR1();
	setTimer1AOutputNormalLow();
	setTimer1BOutputNormalLow();
	setTimer1COutputNormalLow();
	setTimer1ClockTo64();
	//printf("period_us : %x\r\n", period_us>>16, period_us);
	period_us = calcPwm(64, PFCPWMWITHICR1, period_us);		//524272us  ϸ, 0xFFFE ; .
	period_us = checkVariableRange(0, 0xFFFF, period_us);	//0xFFFE ϸ, 0xFFFE  ; .
	//printf("period_us : %x\r\n", period_us);
	setTimer1ICR1(period_us);
}

void setPwm123_256_period(unsigned long int period_us)
{
	//Ÿ̸1 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 64
	//16MHz 
	//ū ֱ  : 0 ~ 2097120us	( 1/16MHz*256 * 2 * 0xFFFF )
	//е : 32us (1/16MHz*256 * 2) 
	//
	//  setPwm123_1_period ּ Ǿ ִ.
	setTimer1ModePFCPwmwithICR1();
	setTimer1AOutputNormalLow();
	setTimer1BOutputNormalLow();
	setTimer1COutputNormalLow();
	setTimer1ClockTo256();
	//printf("period_us : %x\r\n", period_us>>16, period_us);
	period_us = calcPwm(256, PFCPWMWITHICR1, period_us);
	period_us = checkVariableRange(0, 0xFFFF, period_us);
	//printf("period_us : %x\r\n", period_us);
	setTimer1ICR1(period_us);
}

void setPwm123_1024_period(unsigned long int period_us)
{
	//Ÿ̸1 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 64
	//16MHz 
	//ū ֱ  : 0 ~ 8388480us (8.388480s)	( 1/16MHz*1024 * 2 * 0xFFFF )
	//е : 128us (1/16MHz*256 * 2) 
	//
	//  setPwm123_1_period ּ Ǿ ִ.
	setTimer1ModePFCPwmwithICR1();
	setTimer1AOutputNormalLow();
	setTimer1BOutputNormalLow();
	setTimer1COutputNormalLow();
	setTimer1ClockTo1024();
	//printf("period_us : %x\r\n", period_us>>16, period_us);
	period_us = calcPwm(1024, PFCPWMWITHICR1, period_us);
	period_us = checkVariableRange(0, 0xFFFF, period_us);
	//printf("period_us : %x\r\n", period_us);
	setTimer1ICR1(period_us);
}

void setPwm456_1_period(unsigned long int period_us)
{
	//setPwm[ȣ]_[ֺ]_[]
	//
	//Ÿ̸3 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 1
	//16MHz 
	//ū ֱ  : 0 ~ 8191.875us
	// ֱ е : 0.125us (0.0625us * 2)
	//							(ִ밪  ʿ ϱ ̴.)
	//							(ڼ   Ʈ Ÿֵ̹ )
	setTimer3ModePFCPwmwithICR3();	//Phased and Frequency Correct Pwm Mode ϰ Ѵ.
	//  ICR  ö󰬴ٰ ٽ 0 .
	//16bits īͰ  ICR ι踸ŭ ȴٰ  ȴ.
	setTimer3AOutputNormalLow();	//⺻ 0, ȣ   1 Ѵ.
	setTimer3BOutputNormalLow();	//⺻ 0, ȣ   1 Ѵ.
	setTimer3COutputNormalLow();	//⺻ 0, ȣ   1 Ѵ.
	setTimer3ClockTo1();			//16MHz Ŭ Ѵ.( ʴ´.)
	//׷ Ŭ 0.0625us  ҿȴ.
	// ִ ū ֱ ( 0xFFFF * 2 -1 ) *0.0625  8191.8125 us ̴.
	//,  unsigned int  صξ  1us ̻ ּ  ؾѴ.
	//(̰ 1us Ϸ Ʈ ϴ 찡 Ŷ ؼ ġ ̴.)
	// Է period 16 ش.	(0.0625us * 16 = 1us)
	//׷ īͰ ϰ  ٽ ϱ  ϴ period ݸ ؾ Ѵ.
	//period_us = period_us * 8;	//    ó 8 Ѵ.
	//  ԼȭѴ.
	period_us = calcPwm(1, PFCPWMWITHICR3, period_us);		
	//ū ֱⰪ ϴ ICR  High Low  8Ʈ 16Ʈ̱ , ִ밪  ʵ Ѵ.
	//ִ밪 0xFFFF(65536-1)̴.
	period_us = checkVariableRange(0, 0xFFFF, period_us);
	setTimer3ICR3(period_us);		//⼭ ū ֱ⸦ Ѵ.
}

void setPwm456_8_period(unsigned long int period_us)
{
	//Ÿ̸3 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 8
	//16MHz 
	//ū ֱ  : 0 ~ 65535us
	// ֱ е : 1us (0.5us * 2)
	//
	//  setPwm456_1_period ּ Ǿ ִ.
	setTimer3ModePFCPwmwithICR3();
	setTimer3AOutputNormalLow();
	setTimer3BOutputNormalLow();
	setTimer3COutputNormalLow();
	setTimer3ClockTo8();
	period_us = calcPwm(8, PFCPWMWITHICR3, period_us);
	period_us = checkVariableRange(0, 0xFFFF, period_us);
	setTimer3ICR3(period_us);
}

void setPwm456_64_period(unsigned long int period_us)
{
	//Ÿ̸3 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 64
	//16MHz 
	//ū ֱ  : 0 ~ 524280us	( 1/16MHz*64 * 2 * 0xFFFF )
	//е : 8us (4us * 2) 
	//
	//  setPwm456_1_period ּ Ǿ ִ.
	setTimer3ModePFCPwmwithICR3();
	setTimer3AOutputNormalLow();
	setTimer3BOutputNormalLow();
	setTimer3COutputNormalLow();
	setTimer3ClockTo64();
	//printf("period_us : %x\r\n", period_us>>16, period_us);
	period_us = calcPwm(64, PFCPWMWITHICR3, period_us);		//524272us  ϸ, 0xFFFE ; .
	period_us = checkVariableRange(0, 0xFFFF, period_us);	//0xFFFE ϸ, 0xFFFE  ; .
	//printf("period_us : %x\r\n", period_us);
	setTimer3ICR3(period_us);
}

void setPwm456_256_period(unsigned long int period_us)
{
	//Ÿ̸3 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 64
	//16MHz 
	//ū ֱ  : 0 ~ 2097120us	( 1/16MHz*256 * 2 * 0xFFFF )
	//е : 32us (1/16MHz*256 * 2) 
	//
	//  setPwm456_1_period ּ Ǿ ִ.
	setTimer3ModePFCPwmwithICR3();
	setTimer3AOutputNormalLow();
	setTimer3BOutputNormalLow();
	setTimer3COutputNormalLow();
	setTimer3ClockTo256();
	//printf("period_us : %x\r\n", period_us>>16, period_us);
	period_us = calcPwm(256, PFCPWMWITHICR3, period_us);
	period_us = checkVariableRange(0, 0xFFFF, period_us);
	//printf("period_us : %x\r\n", period_us);
	setTimer3ICR3(period_us);
}

void setPwm456_1024_period(unsigned long int period_us)
{
	//Ÿ̸3 ̿ PWM  ū ֱ Լ(16bits Ÿ̸)
	//ֺ : 64
	//16MHz 
	//ū ֱ  : 0 ~ 8388480us (8.388480s)	( 1/16MHz*1024 * 2 * 0xFFFF )
	//е : 128us (1/16MHz*256 * 2) 
	//
	//  setPwm456_1_period ּ Ǿ ִ.
	setTimer3ModePFCPwmwithICR3();
	setTimer3AOutputNormalLow();
	setTimer3BOutputNormalLow();
	setTimer3COutputNormalLow();
	setTimer3ClockTo1024();
	//printf("period_us : %x\r\n", period_us>>16, period_us);
	period_us = calcPwm(1024, PFCPWMWITHICR3, period_us);
	period_us = checkVariableRange(0, 0xFFFF, period_us);
	//printf("period_us : %x\r\n", period_us);
	setTimer3ICR3(period_us);
}

/////////////////////////////////////////////////////////////////////////////////////
//PWM ÿ Ǵ Լ
//	-
/////////////////////////////////////////////////////////////////////////////////////
#endif	// _PWM_BY_TIMER
#ifdef _PWM_BY_TIMERINTERRUPT
#endif	// _PWM_BY_TIMERINTERRUPT
#endif	// _AVR_ATMEGA2560
