#include <stddef.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <string.h>
#include <ncurses.h>
#include <stdlib.h>
#include <panel.h>

#define TRUE	1
#define FALSE	0

#define MSG_WIN_SIZE_ROWS 5


int  title(WINDOW *win);

/*int main(void)
{
        WINDOW *win;
        char path[1024];
 
        initscr();
        //cbreak();
        start_color();
 
        keypad(stdscr, TRUE);
		
	messageBox("aaaaaweioroijewofjdl;kfjoiepwqhfiowjfpqwioefj");
	endwin();
 
        return 0;
}*/
 
 
int messageBox(char *path)
{
	WINDOW* win;
	PANEL* panel;
	int ch = 0;

	int len = strlen(path);

	init_pair(20, COLOR_GREEN, 	COLOR_GREEN);   
	init_pair(21, COLOR_RED,	COLOR_GREEN);
	init_pair(22, COLOR_YELLOW,	COLOR_BLACK);


	if(len < 20) len = 20;	

	win = newwin(MSG_WIN_SIZE_ROWS, len+10, 
		(LINES/2)-(MSG_WIN_SIZE_ROWS/2),
		(COLS/2)-((len+10)/2) );

	panel = new_panel(win);

	wattron(win, COLOR_PAIR(22));
	title(win);
	wattroff(win, COLOR_PAIR(22));

	wattron(win, COLOR_PAIR(22));
	mvwprintw(win, 1, ((len+10)/2)-(strlen(path)/2), "%s", path);
	wattroff(win, COLOR_PAIR(22));

	wattron(win, COLOR_PAIR(22));
	mvwprintw(win, 3, (len+10)/2-7, "OK(y)");
	mvwprintw(win, 3, (len+10)/2+1, "Cancel(n)");
	wattroff(win, COLOR_PAIR(22));

	box(win, 0, 0);
	mvwaddch(win, 2, 0, ACS_LTEE);
	mvwhline(win, 2, 1, ACS_HLINE, len + 10- 2);
	mvwaddch(win, 2, len + 10, ACS_RTEE);
	wrefresh(win);

	show_panel(panel);
	update_panels();
	doupdate();

	while( (ch = getch()) != KEY_F(1) )
	{
		switch(ch)
		{
			case 'y':
				wclear(win);
				hide_panel(panel);
				update_panels();
				doupdate();
				delwin(win);
				return TRUE;
				break;

			case 'n':
				wclear(win);
				hide_panel(panel);
				update_panels();
				doupdate();
				delwin(win);
				return FALSE;
				break;
			default:
				break;
		}//end switch
	}// end while
 
	wclear(win);
	delwin(win);

	
	return -1;
}
 




int title(WINDOW *win)
{
	int i=0, j=0;
	int y=0, x=0;


	getmaxyx(win, y, x);

	//for(i=0; i<y; i++)
	for(j=0; j<x; j++)
		mvwprintw(win, 1 ,j ," ");

	return 0;

}
