import myMySQLdb, sql, message, Privilege, config

class Quota :

	db = None
	address = None

	quota_size = None
	max_quota_size = None
	current_usage = None

	is_overquota = False
	is_max_overquota = False

	def __init__(self, db, address) :
		""" """

		self.db = db
		self.address = address

		self.P = Privilege.Privilege(self.db, address)
		self.P.check()

	def __get_quota (self, id, which="user") :
		""" """

		if which == "domain" :
			table_name = "domain_priv"
		elif which == "user" :
			table_name = "user_priv"

		DB = myMySQLdb.myMySQLdb(self.db)
		DB.query(sql.SQL_GET_QUOTA % (table_name, id), True)

		if DB.num_rows < 0 or DB.num_rows > 1:
			retval = False
		else :
			a = DB.fetch()
			quota_size = a["quota"]

			retval = quota_size

		return retval

	def get_quota (self) :
		""" """

		if self.P.is_valid_user :
			a = self.__get_quota(self.P.user_id, "user")
			b = self.__get_quota(self.P.domain_id, "domain")

			self.user_id = self.P.user_id

		if a :
			self.quota_size = a
		elif not a and not b :
			self.quota_size = config.default["quota"]["default_quota"]
		elif not a :
			self.quota_size = b

		self.max_quota_size = self.quota_size + \
			int(self.quota_size * (float(config.default["quota"]["over_quota"]) / 100))

		return self.quota_size

	def get_current_usage (self) :

		DB = myMySQLdb.myMySQLdb(self.db)
		DB.query(sql.SQL_GET_USAGE % self.P.user_id, True)

		if DB.num_rows > 0 :
			a = DB.fetch()
			try :
				message = int(a["sum"])
			except TypeError :
				message = 0
		else :
			message = 0

		DB.query(sql.SQL_GET_USAGE_DOC % self.P.user_id, True)

		if DB.num_rows > 0 :
			a = DB.fetch()

			try :
				doc = int(a["sum"])
			except TypeError :
				doc = 0
		else :
			doc = 0

		self.current_usage = message + doc

		retval = self.current_usage

		return retval

	def check (self, size=None) :
		"""
		Return value
			True : OK
			False : Over quota
		"""

		self.get_quota()
		self.get_current_usage()

		if size :
			current = self.current_usage + size
		else :
			current = self.current_usage

		if current > self.quota_size :
			self.is_overquota = True
		else :
			self.is_overquota = False

		if current > self.max_quota_size :
			self.is_max_overquota = True
		else :
			self.is_max_overquota = False

		return self.is_overquota

__author__ =  "Spike^ekipS <spike@spikeekips.net>"
__version__=  "0.1"
__nonsense__ = ""

__file__ = "Quota.py"


