<?
include_once $global["root"] . "/lib/Directory.php";
include_once $global["root"] . "/include/print_byte.php";

class Directories {

	var $compact;
	var $navigate;

	var $DB;
	var $Directory;
	var $Template;

	var $total_size;
	var $depth;
	var $parent_list;

	var $directory_system;

	// sql queries
	var $SQL_GET_PARENT_DIRECTORY =
			"select SQL_CACHE parent from directory_%s where no = '%s'";
	var $SQL_SUB_DIRECTORY_LIST =
			"select SQL_CACHE no,name from directory_%s where parent = '%s'";
	var $SQL_DIRECTORY_LIST_ALL =
			"select SQL_CACHE no,name from directory_%s where parent = '0'";

	function Directories () {
		global $global;

		$this->Template = new Template;

		// define system directory
		$this->directory_system = array_flip($global["directory"]);

	}

	function gather_size ($size="") {
		if (! $size) $size = $this->Directory->get_size();

		$this->total_size += $size;

		$retval = $size;
		return $retval;
	}

	function return_nums_item() {

		$d = $this->Directory->get_nums_item();

		if ($d == "0") {
			$retval = "-";
		} else {
			$retval = $d;
		}

		return $retval;
	}

	function assign ($info) {
		global $string;

		$retval["depth"] = $this->depth * 15;
		$retval["num"] = $this->Directory->no;

		if (array_key_exists($this->Directory->no, $this->directory_system)) {
			$retval["name"] = $string["directory". $this->Directory->no];
			$retval["is_system"] = true;
		} else {
			$retval["name"] = $info[$this->Directory->no]["name"];
			$retval["is_system"] = false;
		}

		if (! $this->compact and ! $this->navigate)
			$retval["directory_size"] = print_byte($this->gather_size());
		if (! $this->compact and ! $this->navigate)
			$retval["number_of_items"] = $this->return_nums_item();

		return $retval;

	}

	function return_directory ($info, $sub=false) {
		global $global, $string;

		$c = $this->assign($info);

		$c["icon"] = $this->set_icon($c["num"]);
		// system directory
		if ($c["num"] == $global["directory"]["mydirectory"]) {
			if ($this->compact) $tmpl = "_compact";
			if ($this->navigate) $tmpl = "_navigate";

			$template = sprintf("/module/item/template/directory%s_list_line_mydirectory",
				$tmpl, $c);
		} else if (! $c["is_system"]) {
			if ($this->compact) $tmpl = "_compact";
			if ($this->navigate) $tmpl = "_navigate";

			if ($info[$this->Directory->no]["is_system"]) $system = "_system";

			$template = sprintf("/module/item/template/directory%s_list_line%s",
				$tmpl, $system);

		// normal directory
		} else {

			if ($this->compact) $tmpl = "_compact";
			if ($this->navigate) $tmpl = "_navigate";

			$template = sprintf("/module/item/template/directory%s_list_line_system",
				$tmpl);
		}

		$retval = $this->Template->generate($template, $c);

		if ($sub) $retval .= $this->return_list_subdirectory();

		return $retval;
	}

	function return_list () {
		global $global, $string;

		// initiate
		$this->Directory = new myDirectory();
		$this->DB = new MySQLdb;
		$this->total_size = 0;

		$this->depth = 0;

		//-------------------------------------------------- root
		$c["num"] = "0";
		$c["name"] = $string["item16"];

		$c["icon"] = $this->set_icon("0");

		if ($this->compact) {
			$main["content"] =
				$this->Template->generate(
					"/module/item/template/directory_compact_list_line_desktop", $c);
		} else if ($this->navigate) {
			$main["content"] =
				$this->Template->generate(
					"/module/item/template/directory_navigate_list_line_desktop", $c);
		} else {
			$main["content"] =
				$this->Template->generate(
					"/module/item/template/directory_list_line_desktop", $c);
		}

		$this->Directory->no = "0";
		$info = $this->Directory->get_info_subdirectory();

		while (list($i, $j) = each($info)) {
			if ($i == $global["directory"]["mydirectory"]) continue;
			$this->Directory->no = $i;
			$this->depth = "0";
			$main["content"] .= $this->return_directory($info);
		}

		$this->depth = "0";
		$this->Directory->no = $global["directory"]["mydirectory"];
		$info = $this->Directory->get_info_subdirectory();

		$main["content"] .= $this->return_directory($info, true);

		//-------------------------------------------------- disk usage
		if (! $this->compact and ! $this->navigate) {
			$main["disk_usage"] = $this->return_disk_usage($this->total_size);
		}

		//-------------------------------------------------- return ALL.
		if ($this->compact) {
			$retval = $this->Template->generate(
				"/module/item/template/directory_compact_list", $main);
		} else if ($this->navigate) {
			$retval = $this->Template->generate(
				"/module/item/template/directory_navigate_list", $main);
		} else {
			$retval = $this->Template->generate(
				"/module/item/template/directory_list", $main);
		}

		return $retval;
	}

	function return_list_subdirectory () {
		global $global, $string;

		$this->depth += 1;
		$info = $this->Directory->get_info_subdirectory();

		if (!is_array($info)) {
			$retval = "";
		} else {

			$depth = $this->depth;
			while (list($i, $j) = each($info)) {
				$this->Directory->no = $i;
				$this->depth = $depth;
				$main .= $this->return_directory($info, true);
			}

			$retval = $main;
		}

		return $retval;
	}

	function set_icon ($directory_num, $size="25") {
		global $global, $string;

		$a = array_flip($global["directory"]);

		if (array_key_exists($directory_num, $a)) {
			$directory_type = $global["icon"]["directory"][$directory_num];
		} else {
			$directory_type = "directory";
		}

		$icon = sprintf("<img class=\"mesian\" src=\"%s/image/directory/%s-%s-on.png\">",
			$_SESSION["user_www_url"], $directory_type, $size);

		$retval = $icon;

		return $retval;
	}

	function return_menu_subdirectory ($no, $depth=1) {
		global $global, $string;

		$this->Directory = new myDirectory($no);

		$info = $this->Directory->get_info_subdirectory($no);

		if (! is_array($info)) {
			$main["content"] = "";
		} else {
			while (list($i, $j) = each($info)) {
				unset($c);

				$c["depth"] = $depth * 10;
				$c["num"] = $i;
				$c["name"] = $j["name"];

				$this->Directory->no = $i;
				$c["icon"] = $this->set_icon($i);

				$main["content"] .=
					$this->Template->generate(
						"/module/item/template/directory_menu_list_line_subdirectory", $c);

				if ($this->parent_list[$depth+1] == $i)
					$main["content"] .= $this->return_menu_subdirectory($i, $depth+1);
			}
		}

		$retval = $main["content"];

		return $retval;
	}

	function return_menu ($no) {
		global $global, $string;

		// get parent list.
		$Directory = new myDirectory($no);

		$this->parent_list = $Directory->get_parent_list();

		// system directory
		while (list($i, $j) = each($this->directory_system)) {
			if ($i == $global["directory"]["mydirectory"]) continue;
			if ($i == $global["directory"]["desktop"]) continue;
			$c["num"] = $i;
			$c["name"] = $string["directory" . $i];

			$c["icon"] = $this->set_icon($i);

			/*
			// clean up buttton.
			if ($i == $global["directory"]["trash"] or
					$i == $global["directory"]["tmp"] or $i == $global["directory"]["spam"]) {
				$c["add"] = sprintf(
					"(<a href=\"%s/mail?mode=drct_select&action=cleanup&directory=%s\"\n
						>%s</a>)", $_SESSION["user_www_url"], $i, $string["item13"]);
			}
			*/

			$main["content"] .=
				$this->Template->generate(
					"/module/item/template/directory_menu_list_line", $c);

			unset($c);
		}

		// my directory
		$c["num"] = $global["directory"]["mydirectory"];
		$c["name"] = $string["directory6"];

		$c["icon"] =
			$this->set_icon($global["directory"]["mydirectory"]);

		$main["content"] .=
			$this->Template->generate(
				"/module/item/template/directory_menu_list_line", $c);

		// print subdirectory
		$main["content"] .=
			$this->return_menu_subdirectory($global["directory"]["mydirectory"], 1);

		$template = "/module/item/template/directory_menu_list";

		$retval = $this->Template->generate($template, $main);

		return $retval;
	}

	function return_select_box_one ($sub=false) {
		global $global, $string;

		$c["depth"] = $this->depth * 15;
		$c["num"] = $this->Directory->no;
		$c["name"] = $this->Directory->get_name();

		// icon.
		$c["icon"] = $this->set_icon($c["num"]);

		if ($this->Directory->is_system() or 
				$this->Directory->no == $_SESSION["user_directory"]) {
			$retval .=
				$this->Template->generate(
					"/module/item/template/directory_select_box_list_line_system", $c);
		} else {
			$retval .=
				$this->Template->generate(
					"/module/item/template/directory_select_box_list_line", $c);
		}

		if ($sub) {
			$this->depth += 1;
			$retval.= $this->return_select_box_list_subdirectory();
		}

		return $retval;
	}

	function return_select_box ($action="", $items="") {
		global $global, $string;

		//-------------------------------------------------- root
		$this->Directory = new myDirectory("0");
		$info = $this->Directory->get_info_subdirectory();

		$c["num"] = "0";
		$c["name"] = $string["item16"];
		$c["icon"] = $this->set_icon("0");

		$main["content"] =
			$this->Template->generate(
				"/module/item/template/directory_select_box_list_line_system", $c);

		while (list($i, $j) = each($info)) {
			if ($i == $global["directory"]["mydirectory"]) continue;

			$this->depth = "0";
			$this->Directory->no = $i;
			$main["content"] .= $this->return_select_box_one($info);
		}

		// my directory list (and sub-directories)
		$this->Directory->no = $global["directory"]["mydirectory"];
		$main["content"] .= $this->return_select_box_one($info, true);

		// set label.
		switch ($action) {
			case ("copy") :
				$main["button_label"] = $string["item52"];
			break;
			case ("move") :
				$main["button_label"] = $string["item49"];
			break;
		}

		$main["action"] = $action;
		$main["items"] = implode(",", $items);

		$main["label"] = "Select Directory.";

		$template = "/module/item/template/directory_select_box_list";

		$retval = $this->Template->generate($template, $main);

		return $retval;
	}

	function return_select_box_list_subdirectory () {
		global $global, $string;

		$info = $this->Directory->get_info_subdirectory();

		if (!is_array($info)) {
			$retval = "";
		} else {

			$depth = $this->depth;

			while (list($i, $j) = each($info)) {
				$this->depth = $depth + 1;
				$this->Directory->no = $i;
				$retval .= $this->return_select_box_one ($info, true);
			}
		}

		return $retval;
	}

	function return_path ($no) {
		global $global, $string;

		$this->Directory = new myDirectory($no);

		$this->parent_list = $this->Directory->get_parent_list();

		if (! is_array($this->parent_list)) {
			$main["content"] = "";
		} else {
			while (list($i, $j) = each($this->parent_list)) {
				if ($j == 0) continue;

				$b["no"] = $j;
				$this->Directory->no = $j;
				$b["name"] = $this->Directory->get_name();

				$c[] = $this->Template->generate(
					"/module/item/template/directory_path_list_line", $b);
			}

			$main["content"] = implode("", $c);
		}

		$retval = $this->Template->generate(
			"/module/item/template/directory_path_list", $main);

		return $retval;
	}

	function return_select_options_sub ($no, $esc="") {

		$DB = new MySQLdb;

		$DB->query(
			sprintf($this->SQL_SUB_DIRECTORY_LIST, $_SESSION["config_id"], $no), true);

		$depth = $this->depth;

		for ($i = 0; $i < $DB->num_rows; $i++) {
			$o = $DB->fetch();

			if (is_array($esc)) {
				$tmp_esc = array_flip($esc);
				if (array_key_exists($o["no"], $tmp_esc)) continue;
			}

			$this->Directory->no = $o["no"];

			$name = str_repeat("-", $this->depth) . "&nbsp;" . $this->Directory->get_name();

			$a[] = array("name" => $name, "no" => $o["no"]);

			$this->depth = $depth + 1;
			$b = $this->return_select_options_sub($o["no"], $esc);

			$a = array_merge($a, $b);
		}

		$retval = $a;

		return $retval;

	}

	function return_select_options ($esc="", $selected="", $is_system=false) {

		$this->Directory = new myDirectory();

		if ($is_system) {

			if (is_array($esc)) $tmp_esc = array_flip($esc);

			while (list($i, $j) = each($this->Directory->system)) {

				if (array_key_exists($i, $tmp_esc)) continue;
				if ($i == 0) continue;

				$this->Directory->no = $i;
				$a[] = array("name" => $this->Directory->get_name(), "no" => $i);

				$this->depth = 1;

				$a = array_merge($a, $b);
			}
		} else {
			$DB = new MySQLdb;

			$DB->query(
				sprintf($this->SQL_DIRECTORY_LIST_ALL, $_SESSION["config_id"]), true);

			for ($i = 0; $i < $DB->num_rows; $i++) {
				$o = $DB->fetch();

				if (is_array($esc)) {
					$tmp_esc = array_flip($esc);
					if (array_key_exists($o["no"], $tmp_esc)) continue;
				}

				$this->Directory->no = $o["no"];
				$a[] = array("name" => $this->Directory->get_name(), "no" => $o["no"]);

				$this->depth = 1;
				$b = $this->return_select_options_sub($o["no"], $esc);

				$a = array_merge($a, $b);
			}
		}

		while (list($j, $k) = each($a)) {
			$this->Directory->no = $k["no"];

			if ($selected == $k["no"]) {
				$retval .= sprintf(
					"<option value=\"%s\" selected>%s", 
						$k["no"], $k["name"]);
			} else {
				$retval .= sprintf(
					"<option value=\"%s\">%s", 
						$k["no"], $k["name"]);
			}
		}

		return $retval;

	}

	function return_disk_usage ($size="") {
		global $global, $string;

		if (! $size) {
			$Directory = new myDirectory;
			$size = $Directory->get_total_size();
		}

		$b = intval(($size / $_SESSION["config_quota"]) * 100); // get percentage.
		$main["usage"] = print_byte($size);

		if ($b > 100) {
			$b = "100";
			$main["percentage"] = "<blink>Over Quota!</blink>";
		} else {
			$main["percentage"] = $b . "%";
		}

		$main["width"] = $b . "%";

		$main["quota"] = print_byte(intval($_SESSION["config_quota"]));

		$retval = $this->Template->generate("/module/item/template/disk_usage", $main);

		return $retval;
	}

}

/*
Description
-----------

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
