<?
include_once $global["root"] . "/lib/Page.php";
include_once $global["root"] . "/lib/Item.php";
include_once $global["root"] . "/lib/Directory.php";
include_once $global["root"] . "/lib/Directories.php";

include_once $global["root"] . "/include/print_time.php";

class Items {

	var $page;
	var $directory;
	var $sort_key;
	var $this_page;

	var $Page;
	var $DB;

	var $empty;

	var $SQL_GET_ITEMS =
		"select SQL_CACHE no,item_num,item_type from item_%s
			where directory_num = '%s' order by no desc limit %s, %s";

	function Items ($directory="", $this_page="", $sort_key="") {

		// assign parameters.
		if ($this_page) {
			$this->this_page = $this_page;
		} else if ($_SESSION["user_page_number"]) {
			$this->this_page = $_SESSION["user_page_number"];
		} else {
			$this->this_page = "0";
		}

		if ($directory) {
			$this->directory = $directory;
		} else if ($_SESSION["user_directory"]) {
			$this->directory = $_SESSION["user_directory"];
		} else {
			$this->directory = "0";
		}

		if ($sort_key) {
			$this->sort_key = $sort_key;
		} else if (! $_SESSION["user_sort_state"]) {
				$this->sort_key = "createdTime";
		} else if (array_key_exists($this->directory, $_SESSION["user_sort_state"])) {
				$this->sort_key = $_SESSION["user_sort_state"][$this->directory];
		} else {
				$this->sort_key = "createdTime";
		}

		// set module.
		$this->DB = new MySQLdb;
		$this->Template = new Template;
		$this->Page = new Page($this->directory, $this->this_page);
	}

	function get_list () {

		$this->DB->query(sprintf($this->SQL_GET_ITEMS,
			$_SESSION["config_id"], $this->directory,
				$this->this_page * $_SESSION["config_pageLimit"],
				$_SESSION["config_pageLimit"]), true); // get rows.

		if ($this->DB->num_rows < 1) {
			$ret = false;
			$this->empty = true;
		} else {

			$item = new Item();

			for ($i = 0; $i < $this->DB->num_rows; $i++) {
				$o = $this->DB->fetch();

				$item->set($o["no"], $o["item_num"], $o["item_type"]);

				$p = $item->info();

				if (is_array($p)) {
					$ret["title"][$o["item_num"]] = $p["title"];
					$ret["author"][$o["item_num"]] = $p["author"]["short"];
					$ret["author2"][$o["item_num"]] = $p["author"]["full"];
					$ret["createdTime"][$o["item_num"]] = $p["createdTime"];
					$ret["item_type"][$o["item_num"]] = $o["item_type"];
					$ret["item_num"][$o["item_num"]] = $o["item_num"];
					$ret["no"][$o["item_num"]] = $o["no"];
					$ret["flag"][$o["item_num"]] = $p["flag"];
					$ret["type"][$o["item_num"]] = $p["type"];
				}
			}

			if (count($ret) < 1) $this->empty = true;
		}

		return $ret;
	}

	function return_list () {
		global $global, $string;

		$q = $this->get_list(); // get list.

		//--------------------
		if ($this->empty) {
			$main["content"] =
				$this->Template->generate("/module/item/template/item_list_empty");
		} else {

			// print page list.
			if ($this->Page->item_total_num > $_SESSION["config_pageLimit"]) {
				$main["page_list"] = $this->Page->print_list();
			}

			// sort!!!
			$main["content"] = $this->sort_list($q);
		}

		//-------------------- item list menu
		$Directory = new myDirectory($_SESSION["user_directory"]);
		$Directories = new Directories;

		if ($this->empty) {
			$item_list_menu_template = "/template/item_list_menu/not_active";
		} else if ($Directory->no == $global["directory"]["spam"]) {
			$item_list_menu_template = "/template/item_list_menu/spam";
		} else if ($Directory->no == $global["directory"]["trash"]) {
			$item_list_menu_template = "/template/item_list_menu/trash";
		} else if ( $Directory->no == $global["directory"]["inbox"] or
				$Directory->no == $global["directory"]["sent"] or
				$Directory->no == $global["directory"]["tmp"] or
				$Directory->no == $global["directory"]["spam"]) {
			$item_list_menu_template = "/template/item_list_menu/mail";
		} else {
			$item_list_menu_template = "/template/item_list_menu/item_list_menu";
		}

		// menu argument.
		$m["directory_num"] = $this->directory;

		$main["item_list_menu"] = $this->Template->generate($item_list_menu_template, $m);
		//--------------------

		$main["sort_add_argument"] =
			ereg_replace("st=(title|author|createdTime)&","",
				ereg_replace("^\&", "", $_SERVER["QUERY_STRING"]));

		$main["directory_name"] = $Directory->get_name();
		$main["directory_icon"] = $Directories->set_icon($_SESSION["user_directory"], 70);

		$ret = $this->Template->generate("/module/item/template/item_list", $main);

		return $ret;
	}

	function sort_list ($list) {
		global $global, $string;

		arsort($list[$this->sort_key]);
		reset($list[$this->sort_key]);

		while (list($i, $j) = each($list[$this->sort_key])) {
			unset($tmp);
			unset($a);

			if ($list["type"][$i]) {
				$a["icon"] =
					sprintf("<img class=\"mesian\" src=\"%s/module/%s/image/content_type-%s-25.png\">",
						$_SESSION["user_www_url"],
						$_SESSION["user_item_type"][$list["item_type"][$i]],
						$list["type"][$i]
					);
			} else {
				$a["icon"] =
					sprintf("<img class=\"mesian\" src=\"%s/module/%s/image/content_type-25.png\">",
						$_SESSION["user_www_url"],
						$_SESSION["user_item_type"][$list["item_type"][$i]]
					);
			}

			// check read flag.
			if ($list["flag"][$i]) {
				$tmp["flag"] = "read";
			} else {
				$tmp["flag"] = "bold";
			}

			$a["title"] =
				sprintf("<a href=\"%s/mail?no=%s&mode=view\" class=\"%s\">%s</a>",
					$_SESSION["user_www_url"], $list["no"][$i], $tmp["flag"],
					wordwrap($list["title"][$i], 55, "<br>"));

			if ($list["author2"][$i]) {
				$a["author"] =
					sprintf("<a href=\"%s/mail?mode=add&no=1&address=%s\">%s</a>",
						$_SESSION["user_www_url"], $list["author2"][$i],
						wordwrap($list["author"][$i], 18, "<br>"));
			} else {
				$a["author"] = wordwrap($list["author"][$i], 18, "<br>");
			}

			$a["no"] = $list["no"][$i];
			$a["num"] = $i;
			$a["item_type"] = $list["item_type"][$i];
			$a["createdTime"] = print_time($list["createdTime"][$i], "simple");

			$retval .= $this->Template->generate("/module/item/template/item_list_line", $a);
		}

		return $retval;
	}

}

/*
Description
-----------

Author
------
 Spike^ekipS <spike@spikeekips.net>

Changelog
---------

Usage
-----

*/

?>
